/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.view.Surface;
import com.serenegiant.media.AbstractVideoEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import com.serenegiant.media.VideoConfig;

@TargetApi(value=18)
public class SurfaceEncoder
extends AbstractVideoEncoder {
    protected Surface mInputSurface;

    public SurfaceEncoder(IRecorder recorder, EncoderListener listener) {
        super("video/avc", recorder, listener);
    }

    @Override
    public Surface getInputSurface() {
        return this.mInputSurface;
    }

    @Override
    public int getCaptureFormat() {
        return 0;
    }

    @Override
    public void prepare() throws Exception {
        this.mTrackIndex = -1;
        this.mRecorderStarted = false;
        this.mIsCapturing = true;
        this.mIsEOS = false;
        MediaCodecInfo codecInfo = this.selectVideoCodec("video/avc");
        if (codecInfo == null) {
            return;
        }
        boolean mayFail = this.mWidth >= 1000 || this.mHeight >= 1000;
        MediaFormat format = MediaFormat.createVideoFormat((String)"video/avc", (int)this.mWidth, (int)this.mHeight);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", this.mBitRate > 0 ? this.mBitRate : VideoConfig.getBitrate(this.mWidth, this.mHeight));
        format.setInteger("frame-rate", this.mFramerate > 0 ? this.mFramerate : VideoConfig.captureFps);
        format.setInteger("i-frame-interval", this.mIFrameIntervals > 0 ? this.mIFrameIntervals : VideoConfig.getIFrame());
        this.mMediaCodec = MediaCodec.createEncoderByType((String)"video/avc");
        this.mMediaCodec.configure(format, null, null, 1);
        this.mInputSurface = this.mMediaCodec.createInputSurface();
        this.mMediaCodec.start();
        this.callOnStartEncode(this.mInputSurface, this.getCaptureFormat(), mayFail);
    }

    @Override
    public void release() {
        super.release();
        this.mInputSurface = null;
    }

    @Override
    public void signalEndOfInputStream() {
        this.mIsEOS = true;
        if (this.mMediaCodec != null) {
            this.mMediaCodec.signalEndOfInputStream();
        }
    }
}

