/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.serenegiant.glutils.EGLBase;
import com.serenegiant.glutils.GLDrawer2D;

class RendererSurfaceRec {
    private Object mSurface;
    private EGLBase.IEglSurface mTargetSurface;
    final float[] mMvpMatrix = new float[16];

    static RendererSurfaceRec newInstance(EGLBase egl, Object surface, int maxFps) {
        return maxFps > 0 ? new RendererSurfaceRecHasWait(egl, surface, maxFps) : new RendererSurfaceRec(egl, surface);
    }

    private RendererSurfaceRec(EGLBase egl, Object surface) {
        this.mSurface = surface;
        this.mTargetSurface = egl.createFromSurface(surface);
        Matrix.setIdentityM((float[])this.mMvpMatrix, (int)0);
    }

    public void release() {
        if (this.mTargetSurface != null) {
            this.mTargetSurface.release();
            this.mTargetSurface = null;
        }
        this.mSurface = null;
    }

    public boolean isValid() {
        return this.mTargetSurface != null && this.mTargetSurface.isValid();
    }

    public boolean canDraw() {
        return true;
    }

    public void draw(GLDrawer2D drawer, int textId, float[] texMatrix) {
        this.mTargetSurface.makeCurrent();
        GLES20.glClear((int)16384);
        drawer.setMvpMatrix(this.mMvpMatrix, 0);
        drawer.draw(textId, texMatrix, 0);
        this.mTargetSurface.swap();
    }

    public void makeCurrent() {
        this.mTargetSurface.makeCurrent();
    }

    public void swap() {
        this.mTargetSurface.swap();
    }

    private static class RendererSurfaceRecHasWait
    extends RendererSurfaceRec {
        private long mNextDraw;
        private final long mIntervalsNs;

        private RendererSurfaceRecHasWait(EGLBase egl, Object surface, int maxFps) {
            super(egl, surface);
            this.mIntervalsNs = 1000000000L / (long)maxFps;
            this.mNextDraw = System.nanoTime() + this.mIntervalsNs;
        }

        @Override
        public boolean canDraw() {
            return System.nanoTime() > this.mNextDraw;
        }

        @Override
        public void draw(GLDrawer2D drawer, int textId, float[] texMatrix) {
            this.mNextDraw = System.nanoTime() + this.mIntervalsNs;
            super.draw(drawer, textId, texMatrix);
        }
    }
}

