/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import com.serenegiant.common.R;
import com.serenegiant.widget.DividerItemDecoration;

public class RecycleViewWithEmptyView
extends RecyclerView {
    private static final boolean DEBUG = false;
    private static final String TAG = RecycleViewWithEmptyView.class.getSimpleName();
    @Nullable
    private View mEmptyView;
    private final RecyclerView.AdapterDataObserver mAdapterDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            super.onChanged();
            RecycleViewWithEmptyView.this.updateEmptyView();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            super.onItemRangeChanged(positionStart, itemCount);
            RecycleViewWithEmptyView.this.updateEmptyView();
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            super.onItemRangeRemoved(positionStart, itemCount);
            RecycleViewWithEmptyView.this.updateEmptyView();
        }
    };

    public RecycleViewWithEmptyView(Context context) {
        this(context, null, 0);
    }

    public RecycleViewWithEmptyView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecycleViewWithEmptyView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        Drawable divider = null;
        if (attrs != null) {
            int defStyleRes = 0;
            TypedArray attribs = context.obtainStyledAttributes(attrs, R.styleable.RecycleViewWithEmptyView, defStyle, defStyleRes);
            try {
                if (attribs.hasValue(R.styleable.RecycleViewWithEmptyView_listDivider)) {
                    divider = attribs.getDrawable(R.styleable.RecycleViewWithEmptyView_listDivider);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            attribs.recycle();
        }
        int orientation = 1;
        if (this.getLayoutManager() instanceof LinearLayoutManager) {
            orientation = ((LinearLayoutManager)this.getLayoutManager()).getOrientation();
        }
        DividerItemDecoration deco = new DividerItemDecoration(context, divider);
        deco.setOrientation(orientation);
        this.addItemDecoration(deco);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (this.getAdapter() != adapter) {
            try {
                if (this.getAdapter() != null) {
                    this.getAdapter().unregisterAdapterDataObserver(this.mAdapterDataObserver);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.setAdapter(adapter);
            if (adapter != null) {
                adapter.registerAdapterDataObserver(this.mAdapterDataObserver);
            }
        }
        this.updateEmptyView();
    }

    public void setEmptyView(View empty_view) {
        if (this.mEmptyView != empty_view) {
            this.mEmptyView = empty_view;
            this.updateEmptyView();
        }
    }

    protected void updateEmptyView() {
        if (this.mEmptyView != null) {
            final RecyclerView.Adapter adapter = this.getAdapter();
            this.post(new Runnable(){

                @Override
                public void run() {
                    RecycleViewWithEmptyView.this.mEmptyView.setVisibility(adapter == null || adapter.getItemCount() == 0 ? 0 : 8);
                }
            });
        }
    }
}

