/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.net.Uri;
import android.util.Log;
import com.serenegiant.utils.BuildCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PermissionCheck {
    public static final void dumpPermissions(Context context) {
        if (context == null) {
            return;
        }
        try {
            PackageManager pm = context.getPackageManager();
            List list = pm.getAllPermissionGroups(128);
            for (PermissionGroupInfo info : list) {
                Log.d((String)"PermissionCheck", (String)info.name);
            }
        }
        catch (Exception e) {
            Log.w((String)"", (Throwable)e);
        }
    }

    @SuppressLint(value={"NewApi"})
    public static boolean hasPermission(Context context, String permissionName) {
        if (context == null) {
            return false;
        }
        boolean result = false;
        try {
            int check;
            if (BuildCheck.isMarshmallow()) {
                check = context.checkSelfPermission(permissionName);
            } else {
                PackageManager pm = context.getPackageManager();
                check = pm.checkPermission(permissionName, context.getPackageName());
            }
            switch (check) {
                case -1: {
                    break;
                }
                case 0: {
                    result = true;
                }
            }
        }
        catch (Exception e) {
            Log.w((String)"", (Throwable)e);
        }
        return result;
    }

    public static boolean hasAudio(Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.RECORD_AUDIO");
    }

    public static boolean hasNetwork(Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.INTERNET");
    }

    public static boolean hasWriteExternalStorage(Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    @SuppressLint(value={"InlinedApi"})
    public static boolean hasReadExternalStorage(Context context) {
        if (BuildCheck.isAndroid4()) {
            return PermissionCheck.hasPermission(context, "android.permission.READ_EXTERNAL_STORAGE");
        }
        return PermissionCheck.hasPermission(context, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public static boolean hasAccessLocation(Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION") && PermissionCheck.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION");
    }

    public static boolean hasAccessCoarseLocation(Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
    }

    public static boolean hasAccessFineLocation(Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION");
    }

    public static boolean hasCamera(Context context) {
        return PermissionCheck.hasPermission(context, "android.permission.CAMERA");
    }

    public static void openSettings(Context context) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
        intent.setData(uri);
        context.startActivity(intent);
    }

    public static List<String> missingPermissions(Context context, String[] expectations) throws IllegalArgumentException, PackageManager.NameNotFoundException {
        return PermissionCheck.missingPermissions(context, new ArrayList<String>(Arrays.asList(expectations)));
    }

    public static List<String> missingPermissions(Context context, List<String> expectations) throws IllegalArgumentException, PackageManager.NameNotFoundException {
        if (context == null || expectations == null) {
            throw new IllegalArgumentException("context or expectations is null");
        }
        PackageManager pm = context.getPackageManager();
        PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 4096);
        String[] info = pi.requestedPermissions;
        if (info != null) {
            for (String i : info) {
                expectations.remove(i);
            }
        }
        return expectations;
    }
}

