/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.res.AssetFileDescriptor;
import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import com.serenegiant.media.IFrameCallback;
import com.serenegiant.utils.BuildCheck;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;

@SuppressLint(value={"InlinedApi"})
@TargetApi(value=16)
public class MediaMoviePlayer {
    private static final boolean DEBUG = false;
    private static final String TAG_STATIC = "MediaMoviePlayer:";
    private final String TAG = "MediaMoviePlayer:" + this.getClass().getSimpleName();
    private final IFrameCallback mCallback;
    private final boolean mAudioEnabled;
    private static final int TIMEOUT_USEC = 10000;
    private static final int STATE_STOP = 0;
    private static final int STATE_PREPARED = 1;
    private static final int STATE_PLAYING = 2;
    private static final int STATE_PAUSED = 3;
    private static final int REQ_NON = 0;
    private static final int REQ_PREPARE = 1;
    private static final int REQ_START = 2;
    private static final int REQ_SEEK = 3;
    private static final int REQ_STOP = 4;
    private static final int REQ_PAUSE = 5;
    private static final int REQ_RESUME = 6;
    private static final int REQ_QUIT = 9;
    protected MediaMetadataRetriever mMetadata;
    private final Object mSync = new Object();
    private volatile boolean mIsRunning;
    private int mState;
    private Object mSource;
    private long mDuration;
    private int mRequest;
    private long mRequestTime;
    private final Object mVideoSync = new Object();
    private final Surface mOutputSurface;
    protected MediaExtractor mVideoMediaExtractor;
    private MediaCodec mVideoMediaCodec;
    private MediaCodec.BufferInfo mVideoBufferInfo;
    private ByteBuffer[] mVideoInputBuffers;
    private ByteBuffer[] mVideoOutputBuffers;
    private long mVideoStartTime;
    private long previousVideoPresentationTimeUs = -1L;
    private volatile int mVideoTrackIndex;
    private boolean mVideoInputDone;
    private boolean mVideoOutputDone;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mBitrate;
    private float mFrameRate;
    private int mRotation;
    private final Object mAudioSync = new Object();
    protected MediaExtractor mAudioMediaExtractor;
    private MediaCodec mAudioMediaCodec;
    private MediaCodec.BufferInfo mAudioBufferInfo;
    private ByteBuffer[] mAudioInputBuffers;
    private ByteBuffer[] mAudioOutputBuffers;
    private long mAudioStartTime;
    private long previousAudioPresentationTimeUs = -1L;
    private volatile int mAudioTrackIndex;
    private boolean mAudioInputDone;
    private boolean mAudioOutputDone;
    private int mAudioChannels;
    private int mAudioSampleRate;
    private int mAudioInputBufSize;
    private boolean mHasAudio;
    private byte[] mAudioOutTempBuf;
    private AudioTrack mAudioTrack;
    private final Runnable mMoviePlayerTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            boolean local_isRunning = false;
            try {
                Object object = MediaMoviePlayer.this.mSync;
                synchronized (object) {
                    local_isRunning = MediaMoviePlayer.this.mIsRunning = true;
                    MediaMoviePlayer.this.mState = 0;
                    MediaMoviePlayer.this.mRequest = 0;
                    MediaMoviePlayer.this.mRequestTime = -1L;
                    MediaMoviePlayer.this.mSync.notifyAll();
                }
                while (local_isRunning) {
                    try {
                        int local_req;
                        object = MediaMoviePlayer.this.mSync;
                        synchronized (object) {
                            local_isRunning = MediaMoviePlayer.this.mIsRunning;
                            local_req = MediaMoviePlayer.this.mRequest;
                            MediaMoviePlayer.this.mRequest = 0;
                        }
                        switch (MediaMoviePlayer.this.mState) {
                            case 0: {
                                local_isRunning = MediaMoviePlayer.this.processStop(local_req);
                                break;
                            }
                            case 1: {
                                local_isRunning = MediaMoviePlayer.this.processPrepared(local_req);
                                break;
                            }
                            case 2: {
                                local_isRunning = MediaMoviePlayer.this.processPlaying(local_req);
                                break;
                            }
                            case 3: {
                                local_isRunning = MediaMoviePlayer.this.processPaused(local_req);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    catch (Exception e) {
                        Log.e((String)MediaMoviePlayer.this.TAG, (String)"MoviePlayerTask:", (Throwable)e);
                        break;
                    }
                }
            }
            finally {
                MediaMoviePlayer.this.handleStop();
            }
        }
    };
    private final Runnable mVideoTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (MediaMoviePlayer.this.mIsRunning && !MediaMoviePlayer.this.mVideoInputDone && !MediaMoviePlayer.this.mVideoOutputDone) {
                try {
                    if (!MediaMoviePlayer.this.mVideoInputDone) {
                        MediaMoviePlayer.this.handleInputVideo();
                    }
                    if (MediaMoviePlayer.this.mVideoOutputDone) continue;
                    MediaMoviePlayer.this.handleOutputVideo(MediaMoviePlayer.this.mCallback);
                }
                catch (Exception e) {
                    Log.e((String)MediaMoviePlayer.this.TAG, (String)"VideoTask:", (Throwable)e);
                    break;
                }
            }
            Object object = MediaMoviePlayer.this.mSync;
            synchronized (object) {
                MediaMoviePlayer.this.mVideoInputDone = (MediaMoviePlayer.this.mVideoOutputDone = true);
                MediaMoviePlayer.this.mSync.notifyAll();
            }
        }
    };
    private final Runnable mAudioTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (MediaMoviePlayer.this.mIsRunning && !MediaMoviePlayer.this.mAudioInputDone && !MediaMoviePlayer.this.mAudioOutputDone) {
                try {
                    if (!MediaMoviePlayer.this.mAudioInputDone) {
                        MediaMoviePlayer.this.handleInputAudio();
                    }
                    if (MediaMoviePlayer.this.mAudioOutputDone) continue;
                    MediaMoviePlayer.this.handleOutputAudio(MediaMoviePlayer.this.mCallback);
                }
                catch (Exception e) {
                    Log.e((String)MediaMoviePlayer.this.TAG, (String)"VideoTask:", (Throwable)e);
                    break;
                }
            }
            Object object = MediaMoviePlayer.this.mSync;
            synchronized (object) {
                MediaMoviePlayer.this.mAudioInputDone = (MediaMoviePlayer.this.mAudioOutputDone = true);
                MediaMoviePlayer.this.mSync.notifyAll();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaMoviePlayer(Surface outputSurface, IFrameCallback callback, boolean audio_enable) throws NullPointerException {
        if (outputSurface == null || callback == null) {
            throw new NullPointerException("outputSurface and callback should not be null");
        }
        this.mOutputSurface = outputSurface;
        this.mCallback = callback;
        this.mAudioEnabled = audio_enable;
        new Thread(this.mMoviePlayerTask, this.TAG).start();
        Object object = this.mSync;
        synchronized (object) {
            try {
                if (!this.mIsRunning) {
                    this.mSync.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public final int getWidth() {
        return this.mVideoWidth;
    }

    public final int getHeight() {
        return this.mVideoHeight;
    }

    public final int getBitRate() {
        return this.mBitrate;
    }

    public final float getFramerate() {
        return this.mFrameRate;
    }

    public final int getRotation() {
        return this.mRotation;
    }

    public final long getDurationUs() {
        return this.mDuration;
    }

    public final int getSampleRate() {
        return this.mAudioSampleRate;
    }

    public final boolean hasAudio() {
        return this.mHasAudio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prepare(String src) {
        Object object = this.mSync;
        synchronized (object) {
            this.mSource = src;
            this.mRequest = 1;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void prepare(AssetFileDescriptor src) {
        Object object = this.mSync;
        synchronized (object) {
            this.mSource = src;
            this.mRequest = 1;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void play() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState == 2) {
                return;
            }
            this.mRequest = 2;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void seek(long newTime) {
        Object object = this.mSync;
        synchronized (object) {
            this.mRequest = 3;
            this.mRequestTime = newTime;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState != 0) {
                this.mRequest = 4;
                this.mSync.notifyAll();
                try {
                    this.mSync.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mSync;
        synchronized (object) {
            this.mRequest = 5;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mSync;
        synchronized (object) {
            this.mRequest = 6;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        this.stop();
        Object object = this.mSync;
        synchronized (object) {
            this.mRequest = 9;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean processStop(int req) throws InterruptedException, IOException {
        Object object;
        boolean local_isRunning = true;
        switch (req) {
            case 1: {
                this.handlePrepare(this.mSource);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                throw new IllegalStateException("invalid state:" + this.mState);
            }
            case 9: {
                local_isRunning = false;
                break;
            }
            default: {
                object = this.mSync;
                synchronized (object) {
                    this.mSync.wait();
                    break;
                }
            }
        }
        object = this.mSync;
        synchronized (object) {
        }
        return local_isRunning &= this.mIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean processPrepared(int req) throws InterruptedException {
        Object object;
        boolean local_isRunning = true;
        switch (req) {
            case 2: {
                this.handleStart();
                break;
            }
            case 5: 
            case 6: {
                throw new IllegalStateException("invalid state:" + this.mState);
            }
            case 4: {
                this.handleStop();
                break;
            }
            case 9: {
                local_isRunning = false;
                break;
            }
            default: {
                object = this.mSync;
                synchronized (object) {
                    this.mSync.wait();
                    break;
                }
            }
        }
        object = this.mSync;
        synchronized (object) {
        }
        return local_isRunning &= this.mIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean processPlaying(int req) {
        boolean local_isRunning = true;
        switch (req) {
            case 1: 
            case 2: 
            case 6: {
                throw new IllegalStateException("invalid state:" + this.mState);
            }
            case 3: {
                this.handleSeek(this.mRequestTime);
                break;
            }
            case 4: {
                this.handleStop();
                break;
            }
            case 5: {
                this.handlePause();
                break;
            }
            case 9: {
                local_isRunning = false;
                break;
            }
            default: {
                this.handleLoop(this.mCallback);
            }
        }
        Object object = this.mSync;
        synchronized (object) {
        }
        return local_isRunning &= this.mIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean processPaused(int req) throws InterruptedException {
        Object object;
        boolean local_isRunning = true;
        switch (req) {
            case 1: 
            case 2: {
                throw new IllegalStateException("invalid state:" + this.mState);
            }
            case 3: {
                this.handleSeek(this.mRequestTime);
                break;
            }
            case 4: {
                this.handleStop();
                break;
            }
            case 6: {
                this.handleResume();
                break;
            }
            case 9: {
                local_isRunning = false;
                break;
            }
            default: {
                object = this.mSync;
                synchronized (object) {
                    this.mSync.wait();
                    break;
                }
            }
        }
        object = this.mSync;
        synchronized (object) {
        }
        return local_isRunning &= this.mIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handlePrepare(Object source) throws IOException {
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState != 0) {
                throw new RuntimeException("invalid state:" + this.mState);
            }
        }
        this.mAudioTrackIndex = -1;
        this.mVideoTrackIndex = -1;
        if (source instanceof String) {
            String srcString = (String)source;
            File src = new File(srcString);
            if (TextUtils.isEmpty((CharSequence)srcString) || !src.canRead()) {
                throw new FileNotFoundException("Unable to read " + source);
            }
            this.mMetadata = new MediaMetadataRetriever();
            this.mMetadata.setDataSource((String)source);
        } else if (source instanceof AssetFileDescriptor) {
            this.mMetadata = new MediaMetadataRetriever();
            this.mMetadata.setDataSource(((AssetFileDescriptor)source).getFileDescriptor());
        } else {
            throw new IllegalArgumentException("unknown source type:source=" + source);
        }
        this.updateMovieInfo();
        this.mVideoTrackIndex = this.internal_prepare_video(source);
        if (this.mAudioEnabled) {
            this.mAudioTrackIndex = this.internal_prepare_audio(source);
        }
        boolean bl = this.mHasAudio = this.mAudioTrackIndex >= 0;
        if (this.mVideoTrackIndex < 0 && this.mAudioTrackIndex < 0) {
            throw new RuntimeException("No video and audio track found in " + source);
        }
        object = this.mSync;
        synchronized (object) {
            this.mState = 1;
        }
        this.mCallback.onPrepared();
    }

    @SuppressLint(value={"NewApi"})
    protected int internal_prepare_video(Object source) {
        int trackindex = -1;
        this.mVideoMediaExtractor = new MediaExtractor();
        try {
            if (source instanceof String) {
                this.mVideoMediaExtractor.setDataSource((String)source);
            } else if (source instanceof AssetFileDescriptor) {
                if (BuildCheck.isAndroid7()) {
                    this.mVideoMediaExtractor.setDataSource((AssetFileDescriptor)source);
                } else {
                    this.mVideoMediaExtractor.setDataSource(((AssetFileDescriptor)source).getFileDescriptor());
                }
            } else {
                throw new IllegalArgumentException("unknown source type:source=" + source);
            }
            trackindex = MediaMoviePlayer.selectTrack(this.mVideoMediaExtractor, "video/");
            if (trackindex >= 0) {
                this.mVideoMediaExtractor.selectTrack(trackindex);
                MediaFormat format = this.mVideoMediaExtractor.getTrackFormat(trackindex);
                this.mVideoWidth = format.getInteger("width");
                this.mVideoHeight = format.getInteger("height");
                this.mDuration = format.getLong("durationUs");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return trackindex;
    }

    @SuppressLint(value={"NewApi"})
    protected int internal_prepare_audio(Object source) {
        int trackindex = -1;
        this.mAudioMediaExtractor = new MediaExtractor();
        try {
            if (source instanceof String) {
                this.mAudioMediaExtractor.setDataSource((String)source);
            } else if (source instanceof AssetFileDescriptor) {
                if (BuildCheck.isAndroid7()) {
                    this.mVideoMediaExtractor.setDataSource((AssetFileDescriptor)source);
                } else {
                    this.mVideoMediaExtractor.setDataSource(((AssetFileDescriptor)source).getFileDescriptor());
                }
            } else {
                throw new IllegalArgumentException("unknown source type:source=" + source);
            }
            trackindex = MediaMoviePlayer.selectTrack(this.mAudioMediaExtractor, "audio/");
            if (trackindex >= 0) {
                this.mAudioMediaExtractor.selectTrack(trackindex);
                MediaFormat format = this.mAudioMediaExtractor.getTrackFormat(trackindex);
                this.mAudioChannels = format.getInteger("channel-count");
                this.mAudioSampleRate = format.getInteger("sample-rate");
                int min_buf_size = AudioTrack.getMinBufferSize((int)this.mAudioSampleRate, (int)(this.mAudioChannels == 1 ? 4 : 12), (int)2);
                int max_input_size = format.getInteger("max-input-size");
                int n = this.mAudioInputBufSize = min_buf_size > 0 ? min_buf_size * 4 : max_input_size;
                if (this.mAudioInputBufSize > max_input_size) {
                    this.mAudioInputBufSize = max_input_size;
                }
                int frameSizeInBytes = this.mAudioChannels * 2;
                this.mAudioInputBufSize = this.mAudioInputBufSize / frameSizeInBytes * frameSizeInBytes;
                this.mAudioTrack = new AudioTrack(3, this.mAudioSampleRate, this.mAudioChannels == 1 ? 4 : 12, 2, this.mAudioInputBufSize, 1);
                try {
                    this.mAudioTrack.play();
                }
                catch (Exception e) {
                    Log.e((String)this.TAG, (String)"failed to start audio track playing", (Throwable)e);
                    this.mAudioTrack.release();
                    this.mAudioTrack = null;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return trackindex;
    }

    protected void updateMovieInfo() {
        this.mBitrate = 0;
        this.mRotation = 0;
        this.mVideoHeight = 0;
        this.mVideoWidth = 0;
        this.mDuration = 0L;
        this.mFrameRate = 0.0f;
        String value = this.mMetadata.extractMetadata(18);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            this.mVideoWidth = Integer.parseInt(value);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = this.mMetadata.extractMetadata(19)))) {
            this.mVideoHeight = Integer.parseInt(value);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = this.mMetadata.extractMetadata(24)))) {
            this.mRotation = Integer.parseInt(value);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = this.mMetadata.extractMetadata(20)))) {
            this.mBitrate = Integer.parseInt(value);
        }
        if (!TextUtils.isEmpty((CharSequence)(value = this.mMetadata.extractMetadata(9)))) {
            this.mDuration = Long.parseLong(value) * 1000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleStart() {
        MediaCodec codec;
        Object object = this.mSync;
        synchronized (object) {
            if (this.mState != 1) {
                throw new RuntimeException("invalid state:" + this.mState);
            }
            this.mState = 2;
        }
        if (this.mRequestTime > 0L) {
            this.handleSeek(this.mRequestTime);
        }
        this.previousAudioPresentationTimeUs = -1L;
        this.previousVideoPresentationTimeUs = -1L;
        this.mVideoOutputDone = true;
        this.mVideoInputDone = true;
        Thread videoThread = null;
        Thread audioThread = null;
        if (this.mVideoTrackIndex >= 0) {
            codec = this.internal_start_video(this.mVideoMediaExtractor, this.mVideoTrackIndex);
            if (codec != null) {
                this.mVideoMediaCodec = codec;
                this.mVideoBufferInfo = new MediaCodec.BufferInfo();
                this.mVideoInputBuffers = codec.getInputBuffers();
                this.mVideoOutputBuffers = codec.getOutputBuffers();
            }
            this.mVideoOutputDone = false;
            this.mVideoInputDone = false;
            videoThread = new Thread(this.mVideoTask, "VideoTask");
        }
        this.mAudioOutputDone = true;
        this.mAudioInputDone = true;
        if (this.mAudioTrackIndex >= 0) {
            codec = this.internal_start_audio(this.mAudioMediaExtractor, this.mAudioTrackIndex);
            if (codec != null) {
                this.mAudioMediaCodec = codec;
                this.mAudioBufferInfo = new MediaCodec.BufferInfo();
                this.mAudioInputBuffers = codec.getInputBuffers();
                this.mAudioOutputBuffers = codec.getOutputBuffers();
            }
            this.mAudioOutputDone = false;
            this.mAudioInputDone = false;
            audioThread = new Thread(this.mAudioTask, "AudioTask");
        }
        if (videoThread != null) {
            videoThread.start();
        }
        if (audioThread != null) {
            audioThread.start();
        }
    }

    protected MediaCodec internal_start_video(MediaExtractor media_extractor, int trackIndex) {
        MediaCodec codec = null;
        if (trackIndex >= 0) {
            MediaFormat format = media_extractor.getTrackFormat(trackIndex);
            String mime = format.getString("mime");
            try {
                codec = MediaCodec.createDecoderByType((String)mime);
                codec.configure(format, this.mOutputSurface, null, 0);
                codec.start();
            }
            catch (IOException e) {
                Log.w((String)this.TAG, (Throwable)e);
            }
        }
        return codec;
    }

    protected MediaCodec internal_start_audio(MediaExtractor media_extractor, int trackIndex) {
        MediaCodec codec = null;
        if (trackIndex >= 0) {
            MediaFormat format = media_extractor.getTrackFormat(trackIndex);
            String mime = format.getString("mime");
            try {
                codec = MediaCodec.createDecoderByType((String)mime);
                codec.configure(format, null, null, 0);
                codec.start();
                ByteBuffer[] buffers = codec.getOutputBuffers();
                int sz = buffers[0].capacity();
                if (sz <= 0) {
                    sz = this.mAudioInputBufSize;
                }
                this.mAudioOutTempBuf = new byte[sz];
            }
            catch (IOException e) {
                Log.w((String)this.TAG, (Throwable)e);
            }
        }
        return codec;
    }

    private final void handleSeek(long newTime) {
        if (newTime < 0L) {
            return;
        }
        if (this.mVideoTrackIndex >= 0) {
            this.mVideoMediaExtractor.seekTo(newTime, 2);
            this.mVideoMediaExtractor.advance();
        }
        if (this.mAudioTrackIndex >= 0) {
            this.mAudioMediaExtractor.seekTo(newTime, 2);
            this.mAudioMediaExtractor.advance();
        }
        this.mRequestTime = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleLoop(IFrameCallback frameCallback) {
        Object object = this.mSync;
        synchronized (object) {
            try {
                this.mSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.mVideoInputDone && this.mVideoOutputDone && this.mAudioInputDone && this.mAudioOutputDone) {
            this.handleStop();
        }
    }

    protected boolean internal_process_input(MediaCodec codec, MediaExtractor extractor, ByteBuffer[] inputBuffers, long presentationTimeUs, boolean isAudio) {
        int inputBufIndex;
        boolean result = true;
        while (this.mIsRunning && (inputBufIndex = codec.dequeueInputBuffer(10000L)) != -1) {
            if (inputBufIndex < 0) continue;
            int size = extractor.readSampleData(inputBuffers[inputBufIndex], 0);
            if (size > 0) {
                codec.queueInputBuffer(inputBufIndex, 0, size, presentationTimeUs, 0);
            }
            result = extractor.advance();
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleInputVideo() {
        long presentationTimeUs = this.mVideoMediaExtractor.getSampleTime();
        boolean b = this.internal_process_input(this.mVideoMediaCodec, this.mVideoMediaExtractor, this.mVideoInputBuffers, presentationTimeUs, false);
        if (!b) {
            while (this.mIsRunning) {
                int inputBufIndex = this.mVideoMediaCodec.dequeueInputBuffer(10000L);
                if (inputBufIndex < 0) continue;
                this.mVideoMediaCodec.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                break;
            }
            Object object = this.mSync;
            synchronized (object) {
                this.mVideoInputDone = true;
                this.mSync.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleOutputVideo(IFrameCallback frameCallback) {
        while (this.mIsRunning && !this.mVideoOutputDone) {
            int decoderStatus = this.mVideoMediaCodec.dequeueOutputBuffer(this.mVideoBufferInfo, 10000L);
            if (decoderStatus == -1) {
                return;
            }
            if (decoderStatus == -3) {
                this.mVideoOutputBuffers = this.mVideoMediaCodec.getOutputBuffers();
                continue;
            }
            if (decoderStatus == -2) {
                MediaFormat mediaFormat = this.mVideoMediaCodec.getOutputFormat();
                continue;
            }
            if (decoderStatus < 0) {
                throw new RuntimeException("unexpected result from video decoder.dequeueOutputBuffer: " + decoderStatus);
            }
            boolean doRender = false;
            if (this.mVideoBufferInfo.size > 0) {
                boolean bl = doRender = this.mVideoBufferInfo.size != 0 && !this.internal_write_video(this.mVideoOutputBuffers[decoderStatus], 0, this.mVideoBufferInfo.size, this.mVideoBufferInfo.presentationTimeUs);
                if (doRender && !frameCallback.onFrameAvailable(this.mVideoBufferInfo.presentationTimeUs)) {
                    this.mVideoStartTime = this.adjustPresentationTime(this.mVideoSync, this.mVideoStartTime, this.mVideoBufferInfo.presentationTimeUs);
                }
            }
            this.mVideoMediaCodec.releaseOutputBuffer(decoderStatus, doRender);
            if ((this.mVideoBufferInfo.flags & 4) == 0) continue;
            Object object = this.mSync;
            synchronized (object) {
                this.mVideoOutputDone = true;
                this.mSync.notifyAll();
            }
        }
    }

    protected boolean internal_write_video(ByteBuffer buffer, int offset, int size, long presentationTimeUs) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleInputAudio() {
        long presentationTimeUs = this.mAudioMediaExtractor.getSampleTime();
        boolean b = this.internal_process_input(this.mAudioMediaCodec, this.mAudioMediaExtractor, this.mAudioInputBuffers, presentationTimeUs, true);
        if (!b) {
            while (this.mIsRunning) {
                int inputBufIndex = this.mAudioMediaCodec.dequeueInputBuffer(10000L);
                if (inputBufIndex < 0) continue;
                this.mAudioMediaCodec.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                break;
            }
            Object object = this.mSync;
            synchronized (object) {
                this.mAudioInputDone = true;
                this.mSync.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleOutputAudio(IFrameCallback frameCallback) {
        while (this.mIsRunning && !this.mAudioOutputDone) {
            Object object;
            int decoderStatus = this.mAudioMediaCodec.dequeueOutputBuffer(this.mAudioBufferInfo, 10000L);
            if (decoderStatus == -1) {
                return;
            }
            if (decoderStatus == -3) {
                this.mAudioOutputBuffers = this.mAudioMediaCodec.getOutputBuffers();
                continue;
            }
            if (decoderStatus == -2) {
                object = this.mAudioMediaCodec.getOutputFormat();
                continue;
            }
            if (decoderStatus < 0) {
                throw new RuntimeException("unexpected result from audio decoder.dequeueOutputBuffer: " + decoderStatus);
            }
            if (this.mAudioBufferInfo.size > 0) {
                this.internal_write_audio(this.mAudioOutputBuffers[decoderStatus], 0, this.mAudioBufferInfo.size, this.mAudioBufferInfo.presentationTimeUs);
                if (!frameCallback.onFrameAvailable(this.mAudioBufferInfo.presentationTimeUs)) {
                    this.mAudioStartTime = this.adjustPresentationTime(this.mAudioSync, this.mAudioStartTime, this.mAudioBufferInfo.presentationTimeUs);
                }
            }
            this.mAudioMediaCodec.releaseOutputBuffer(decoderStatus, false);
            if ((this.mAudioBufferInfo.flags & 4) == 0) continue;
            object = this.mSync;
            synchronized (object) {
                this.mAudioOutputDone = true;
                this.mSync.notifyAll();
            }
        }
    }

    protected boolean internal_write_audio(ByteBuffer buffer, int offset, int size, long presentationTimeUs) {
        if (this.mAudioOutTempBuf.length < size) {
            this.mAudioOutTempBuf = new byte[size];
        }
        buffer.position(offset);
        buffer.get(this.mAudioOutTempBuf, 0, size);
        buffer.clear();
        if (this.mAudioTrack != null) {
            this.mAudioTrack.write(this.mAudioOutTempBuf, 0, size);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long adjustPresentationTime(Object sync, long startTime, long presentationTimeUs) {
        if (startTime > 0L) {
            long t = presentationTimeUs - (System.nanoTime() / 1000L - startTime);
            while (t > 0L) {
                Object object = sync;
                synchronized (object) {
                    try {
                        sync.wait(t / 1000L, (int)(t % 1000L * 1000L));
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.mState == 4 || this.mState == 9) {
                        break;
                    }
                }
                t = presentationTimeUs - (System.nanoTime() / 1000L - startTime);
            }
            return startTime;
        }
        return System.nanoTime() / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleStop() {
        Object object = this.mVideoTask;
        synchronized (object) {
            this.internal_stop_video();
            this.mVideoTrackIndex = -1;
        }
        object = this.mAudioTask;
        synchronized (object) {
            this.internal_stop_audio();
            this.mAudioTrackIndex = -1;
        }
        if (this.mVideoMediaCodec != null) {
            this.mVideoMediaCodec.stop();
            this.mVideoMediaCodec.release();
            this.mVideoMediaCodec = null;
        }
        if (this.mAudioMediaCodec != null) {
            this.mAudioMediaCodec.stop();
            this.mAudioMediaCodec.release();
            this.mAudioMediaCodec = null;
        }
        if (this.mVideoMediaExtractor != null) {
            this.mVideoMediaExtractor.release();
            this.mVideoMediaExtractor = null;
        }
        if (this.mAudioMediaExtractor != null) {
            this.mAudioMediaExtractor.release();
            this.mAudioMediaExtractor = null;
        }
        this.mAudioBufferInfo = null;
        this.mVideoBufferInfo = null;
        this.mVideoOutputBuffers = null;
        this.mVideoInputBuffers = null;
        this.mAudioOutputBuffers = null;
        this.mAudioInputBuffers = null;
        if (this.mMetadata != null) {
            this.mMetadata.release();
            this.mMetadata = null;
        }
        object = this.mSync;
        synchronized (object) {
            this.mAudioInputDone = true;
            this.mAudioOutputDone = true;
            this.mVideoInputDone = true;
            this.mVideoOutputDone = true;
            this.mState = 0;
        }
        this.mCallback.onFinished();
    }

    protected void internal_stop_video() {
    }

    protected void internal_stop_audio() {
        if (this.mAudioTrack != null) {
            if (this.mAudioTrack.getState() != 0) {
                this.mAudioTrack.stop();
            }
            this.mAudioTrack.release();
            this.mAudioTrack = null;
        }
        this.mAudioOutTempBuf = null;
    }

    private final void handlePause() {
    }

    private final void handleResume() {
    }

    protected static final int selectTrack(MediaExtractor extractor, String mimeType) {
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (!mime.startsWith(mimeType)) continue;
            return i;
        }
        return -1;
    }
}

