/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.media.AudioRecord;
import android.os.Process;
import com.serenegiant.media.IAudioSampler;

public class AudioSampler
extends IAudioSampler {
    private AudioThread mAudioThread;
    private final int AUDIO_SOURCE;
    private final int SAMPLING_RATE;
    private final int CHANNEL_COUNT;
    private final int SAMPLES_PER_FRAME;
    private final int BUFFER_SIZE;
    private static final int AUDIO_FORMAT = 2;

    public AudioSampler(int audio_source, int channel_num, int sampling_rate, int samples_per_frame, int frames_per_buffer) {
        this.AUDIO_SOURCE = audio_source;
        this.CHANNEL_COUNT = channel_num;
        this.SAMPLING_RATE = sampling_rate;
        this.SAMPLES_PER_FRAME = samples_per_frame * channel_num;
        this.BUFFER_SIZE = AudioSampler.getAudioBufferSize(channel_num, sampling_rate, samples_per_frame, frames_per_buffer);
    }

    @Override
    public int getBufferSize() {
        return this.SAMPLES_PER_FRAME;
    }

    @Override
    public synchronized void start() {
        super.start();
        if (this.mAudioThread == null) {
            this.init_pool(this.SAMPLES_PER_FRAME);
            this.mAudioThread = new AudioThread();
            this.mAudioThread.start();
        }
    }

    @Override
    public synchronized void stop() {
        this.mIsCapturing = false;
        this.mAudioThread = null;
        super.stop();
    }

    @Override
    public int getAudioSource() {
        return this.AUDIO_SOURCE;
    }

    public static int getAudioBufferSize(int channel_num, int sampling_rate, int samples_per_frame, int frames_per_buffer) {
        int buffer_size = samples_per_frame * frames_per_buffer;
        int min_buffer_size = AudioRecord.getMinBufferSize((int)sampling_rate, (int)(channel_num == 1 ? 16 : 12), (int)2);
        if (buffer_size < min_buffer_size) {
            buffer_size = (min_buffer_size / samples_per_frame + 1) * samples_per_frame * 2 * channel_num;
        }
        return buffer_size;
    }

    public static AudioRecord createAudioRecord(int source, int sampling_rate, int channels, int format, int buffer_size) {
        int[] AUDIO_SOURCES = new int[]{0, 5, 1, 0, 7, 6};
        switch (source) {
            case 1: {
                AUDIO_SOURCES[0] = 1;
                break;
            }
            case 2: {
                AUDIO_SOURCES[0] = 5;
                break;
            }
            default: {
                AUDIO_SOURCES[0] = 1;
            }
        }
        AudioRecord audioRecord = null;
        for (int src : AUDIO_SOURCES) {
            try {
                audioRecord = new AudioRecord(src, sampling_rate, channels == 1 ? 16 : 12, format, buffer_size);
                if (audioRecord != null && audioRecord.getState() != 1) {
                    audioRecord.release();
                    audioRecord = null;
                }
            }
            catch (Exception e) {
                audioRecord = null;
            }
            if (audioRecord != null) break;
        }
        return audioRecord;
    }

    @Override
    public int getChannels() {
        return this.CHANNEL_COUNT;
    }

    @Override
    public int getSamplingFrequency() {
        return this.SAMPLING_RATE;
    }

    @Override
    public int getBitResolution() {
        return 16;
    }

    static /* synthetic */ int access$000(AudioSampler x0) {
        return x0.AUDIO_SOURCE;
    }

    static /* synthetic */ int access$100(AudioSampler x0) {
        return x0.SAMPLING_RATE;
    }

    static /* synthetic */ int access$200(AudioSampler x0) {
        return x0.CHANNEL_COUNT;
    }

    static /* synthetic */ int access$300(AudioSampler x0) {
        return x0.BUFFER_SIZE;
    }

    static /* synthetic */ int access$400(AudioSampler x0) {
        return x0.SAMPLES_PER_FRAME;
    }

    private final class AudioThread
    extends Thread {
        public AudioThread() {
            super("AudioThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public final void run() {
            Process.setThreadPriority((int)-16);
            audioRecord = AudioSampler.createAudioRecord(AudioSampler.access$000(AudioSampler.this), AudioSampler.access$100(AudioSampler.this), AudioSampler.access$200(AudioSampler.this), 2, AudioSampler.access$300(AudioSampler.this));
            err_count = 0;
            if (audioRecord != null) {
                try {
                    if (!AudioSampler.this.mIsCapturing) ** GOTO lbl51
                    audioRecord.startRecording();
                    try {
                        while (AudioSampler.this.mIsCapturing) {
                            data = AudioSampler.this.obtain();
                            if (data != null) {
                                buffer = data.mBuffer;
                                buffer.clear();
                                try {
                                    readBytes = audioRecord.read(buffer, AudioSampler.access$400(AudioSampler.this));
                                }
                                catch (Exception e) {
                                    AudioSampler.this.callOnError(e);
                                }
                                if (readBytes == -2) {
                                    ++err_count;
                                    AudioSampler.this.recycle(data);
                                } else if (readBytes == -3) {
                                    ++err_count;
                                    AudioSampler.this.recycle(data);
                                } else if (readBytes > 0) {
                                    err_count = 0;
                                    data.presentationTimeUs = AudioSampler.this.getInputPTSUs();
                                    data.size = readBytes;
                                    buffer.position(readBytes);
                                    buffer.flip();
                                    AudioSampler.this.addAudioData(data);
                                }
                            }
                            if (err_count <= 10) continue;
                        }
                    }
                    finally {
                        audioRecord.stop();
                    }
                }
                catch (Exception e) {
                    AudioSampler.this.callOnError(e);
                }
                finally {
                    audioRecord.release();
                }
            } else {
                AudioSampler.this.callOnError(new RuntimeException("AudioRecord failed to initialize"));
            }
lbl51:
            // 6 sources

            AudioSampler.this.stop();
        }
    }

    protected static final class AudioRecordRec {
        AudioRecord audioRecord;
        int bufferSize;

        protected AudioRecordRec() {
        }
    }
}

