/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.media;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import com.serenegiant.media.AbstractEncoder;
import com.serenegiant.media.EncoderListener;
import com.serenegiant.media.IRecorder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@TargetApi(value=16)
public abstract class AbstractAudioEncoder
extends AbstractEncoder {
    public static final String AUDIO_MIME_TYPE = "audio/mp4a-latm";
    public static final int DEFAULT_SAMPLE_RATE = 44100;
    public static final int DEFAULT_BIT_RATE = 64000;
    public static final int SAMPLES_PER_FRAME = 1024;
    public static final int FRAMES_PER_BUFFER = 25;
    protected int mAudioSource;
    protected int mChannelCount;
    protected int mSampleRate;
    protected int mBitRate;

    public AbstractAudioEncoder(IRecorder recorder, EncoderListener listener, int audio_source, int audio_channels) {
        this(recorder, listener, audio_source, audio_channels, 44100, 64000);
    }

    public AbstractAudioEncoder(IRecorder recorder, EncoderListener listener, int audio_source, int audio_channels, int sample_rate, int bit_rate) {
        super(AUDIO_MIME_TYPE, recorder, listener);
        this.mAudioSource = audio_source;
        this.mChannelCount = audio_channels;
        this.mSampleRate = sample_rate;
        this.mBitRate = bit_rate;
    }

    @Override
    public void prepare() throws Exception {
        this.mTrackIndex = -1;
        this.mIsEOS = false;
        this.mRecorderStarted = false;
        MediaCodecInfo audioCodecInfo = AbstractAudioEncoder.selectAudioCodec(this.MIME_TYPE);
        if (audioCodecInfo == null) {
            return;
        }
        MediaFormat audioFormat = MediaFormat.createAudioFormat((String)this.MIME_TYPE, (int)this.mSampleRate, (int)this.mChannelCount);
        audioFormat.setInteger("aac-profile", 2);
        audioFormat.setInteger("channel-mask", this.mChannelCount == 1 ? 16 : 12);
        audioFormat.setInteger("bitrate", this.mBitRate);
        audioFormat.setInteger("channel-count", this.mChannelCount);
        this.mMediaCodec = MediaCodec.createEncoderByType((String)this.MIME_TYPE);
        this.mMediaCodec.configure(audioFormat, null, null, 1);
        this.mMediaCodec.start();
        this.callOnStartEncode(null, -1, false);
    }

    private static final MediaCodecInfo selectAudioCodec(String mimeType) {
        MediaCodecInfo result = null;
        int numCodecs = AbstractAudioEncoder.getCodecCount();
        block0: for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = AbstractAudioEncoder.getCodecInfoAt(i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(mimeType)) continue;
                result = codecInfo;
                break block0;
            }
        }
        return result;
    }

    @Override
    public final boolean isAudio() {
        return true;
    }

    @Override
    protected MediaFormat createOutputFormat(byte[] csd, int size, int ix0, int ix1) {
        if (ix0 >= 0) {
            // empty if block
        }
        MediaFormat outFormat = MediaFormat.createAudioFormat((String)this.MIME_TYPE, (int)this.mSampleRate, (int)this.mChannelCount);
        ByteBuffer csd0 = ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
        csd0.put(csd, 0, size);
        csd0.flip();
        outFormat.setByteBuffer("csd-0", csd0);
        return outFormat;
    }
}

