/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.glutils;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.support.annotation.Nullable;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.serenegiant.glutils.EGLBase;
import com.serenegiant.glutils.EglTask;
import com.serenegiant.glutils.GLDrawer2D;
import com.serenegiant.glutils.GLHelper;
import com.serenegiant.glutils.IRendererHolder;
import com.serenegiant.glutils.RenderHolderCallback;
import com.serenegiant.glutils.RendererSurfaceRec;
import com.serenegiant.utils.BuildCheck;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class EffectRendererHolder
implements IRendererHolder {
    private static final String TAG = EffectRendererHolder.class.getSimpleName();
    private static final int MAX_PARAM_NUM = 18;
    public static final int EFFECT_NON = 0;
    public static final int EFFECT_GRAY = 1;
    public static final int EFFECT_GRAY_REVERSE = 2;
    public static final int EFFECT_BIN = 3;
    public static final int EFFECT_BIN_YELLOW = 4;
    public static final int EFFECT_BIN_GREEN = 5;
    public static final int EFFECT_BIN_REVERSE = 6;
    public static final int EFFECT_BIN_REVERSE_YELLOW = 7;
    public static final int EFFECT_BIN_REVERSE_GREEN = 8;
    public static final int EFFECT_EMPHASIZE_RED_YELLOW = 9;
    public static final int EFFECT_EMPHASIZE_RED_YELLOW_WHITE = 10;
    public static final int EFFECT_NUM = 11;
    private static final String FRAGMENT_SHADER_GRAY_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 cl3 = vec3(color, color, color);\n    gl_FragColor = vec4(cl3, 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_GRAY_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 cl3 = vec3(color, color, color);\n    gl_FragColor = vec4(cl3, 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private static final String FRAGMENT_SHADER_GRAY_REVERSE_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 cl3 = vec3(color, color, color);\n    gl_FragColor = vec4(clamp(vec3(1.0, 1.0, 1.0) - cl3, 0.0, 1.0), 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_GRAY_REVERSE_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 cl3 = vec3(color, color, color);\n    gl_FragColor = vec4(clamp(vec3(1.0, 1.0, 1.0) - cl3, 0.0, 1.0), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private static final String FRAGMENT_SHADER_BIN_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * bin, 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_BIN_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * bin, 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "1.0, 1.0, 1.0");
    private static final String FRAGMENT_SHADER_BIN_YELLOW_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * bin, 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "1.0, 1.0, 0.0");
    private static final String FRAGMENT_SHADER_BIN_GREEN_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * bin, 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "0.0, 1.0, 0.0");
    private static final String FRAGMENT_SHADER_BIN_REVERSE_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * (vec3(1.0, 1.0, 1.0) - bin), 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_BIN_REVERSE_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * (vec3(1.0, 1.0, 1.0) - bin), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "1.0, 1.0, 1.0");
    private static final String FRAGMENT_SHADER_BIN_REVERSE_YELLOW_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * (vec3(1.0, 1.0, 1.0) - bin), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "1.0, 1.0, 0.0");
    private static final String FRAGMENT_SHADER_BIN_REVERSE_GREEN_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nconst vec3 conv = vec3(0.3, 0.59, 0.11);\nconst vec3 cl = vec3(%s);\nvoid main() {\n    vec4 tc = texture2D(sTexture, vTextureCoord);\n    float color = dot(tc.rgb, conv);\n    vec3 bin = step(0.3, vec3(color, color, color));\n    gl_FragColor = vec4(cl * (vec3(1.0, 1.0, 1.0) - bin), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES", "0.0, 1.0, 0.0");
    private static final String FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform float uParams[18];\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 hsv = rgb2hsv(texture2D(sTexture, vTextureCoord).rgb);\n    if ( ((hsv.g >= uParams[2]) && (hsv.g <= uParams[3]))\n        && ((hsv.b >= uParams[4]) && (hsv.b <= uParams[5]))\n        && ((hsv.r <= uParams[0]) || (hsv.r >= uParams[1])) ) {\n        hsv = hsv * vec3(uParams[6], uParams[7], uParams[8]);\n    } else {\n        hsv = hsv * vec3(uParams[9], uParams[10], uParams[11]);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform float uParams[18];\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 hsv = rgb2hsv(texture2D(sTexture, vTextureCoord).rgb);\n    if ( ((hsv.g >= uParams[2]) && (hsv.g <= uParams[3]))\n        && ((hsv.b >= uParams[4]) && (hsv.b <= uParams[5]))\n        && ((hsv.r <= uParams[0]) || (hsv.r >= uParams[1])) ) {\n        hsv = hsv * vec3(uParams[6], uParams[7], uParams[8]);\n    } else {\n        hsv = hsv * vec3(uParams[9], uParams[10], uParams[11]);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private static final String FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_WHITE_BASE = "#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform float uParams[18];\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 hsv = rgb2hsv(texture2D(sTexture, vTextureCoord).rgb);\n    if ( ((hsv.g >= uParams[2]) && (hsv.g <= uParams[3]))\n        && ((hsv.b >= uParams[4]) && (hsv.b <= uParams[5]))\n        && ((hsv.r <= uParams[0]) || (hsv.r >= uParams[1])) ) {\n        hsv = hsv * vec3(uParams[6], uParams[7], uParams[8]);\n    } else if ((hsv.g < uParams[12]) && (hsv.b < uParams[13])) {\n        hsv = hsv * vec3(1.0, 0.0, 2.0);\n    } else {\n        hsv = hsv * vec3(uParams[9], uParams[10], uParams[11]);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n";
    private static final String FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_WHITE_OES = String.format("#version 100\n%sprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform %s sTexture;\nuniform float uParams[18];\nvec3 rgb2hsv(vec3 c) {\nvec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);\nvec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));\nvec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));\nfloat d = q.x - min(q.w, q.y);\nfloat e = 1.0e-10;\nreturn vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);\n}\nvec3 hsv2rgb(vec3 c) {\nvec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);\nvec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);\nreturn c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);\n}\nvoid main() {\n    vec3 hsv = rgb2hsv(texture2D(sTexture, vTextureCoord).rgb);\n    if ( ((hsv.g >= uParams[2]) && (hsv.g <= uParams[3]))\n        && ((hsv.b >= uParams[4]) && (hsv.b <= uParams[5]))\n        && ((hsv.r <= uParams[0]) || (hsv.r >= uParams[1])) ) {\n        hsv = hsv * vec3(uParams[6], uParams[7], uParams[8]);\n    } else if ((hsv.g < uParams[12]) && (hsv.b < uParams[13])) {\n        hsv = hsv * vec3(1.0, 0.0, 2.0);\n    } else {\n        hsv = hsv * vec3(uParams[9], uParams[10], uParams[11]);\n    }\n    gl_FragColor = vec4(hsv2rgb(clamp(hsv, 0.0, 1.0)), 1.0);\n}\n", "#extension GL_OES_EGL_image_external : require\n", "samplerExternalOES");
    private final Object mSync = new Object();
    private final RenderHolderCallback mCallback;
    private volatile boolean isRunning;
    private File mCaptureFile;
    private final RendererTask mRendererTask;
    private static final int REQUEST_DRAW = 1;
    private static final int REQUEST_UPDATE_SIZE = 2;
    private static final int REQUEST_ADD_SURFACE = 3;
    private static final int REQUEST_REMOVE_SURFACE = 4;
    private static final int REQUEST_RECREATE_MASTER_SURFACE = 5;
    private static final int REQUEST_MIRROR = 6;
    private static final int REQUEST_CHANGE_EFFECT = 7;
    private static final int REQUEST_SET_PARAMS = 8;
    private final Runnable mCaptureTask = new Runnable(){
        EGLBase egl;
        EGLBase.IEglSurface captureSurface;
        GLDrawer2D drawer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = EffectRendererHolder.this.mSync;
            synchronized (object) {
                if (!EffectRendererHolder.this.isRunning) {
                    try {
                        EffectRendererHolder.this.mSync.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.init();
            if (this.egl.getGlVersion() > 2) {
                this.captureLoopGLES3();
            } else {
                this.captureLoopGLES2();
            }
            this.release();
        }

        private final void init() {
            this.egl = EGLBase.createFrom(3, EffectRendererHolder.this.mRendererTask.getContext(), false, 0, false);
            this.captureSurface = this.egl.createOffscreen(EffectRendererHolder.this.mRendererTask.mVideoWidth, EffectRendererHolder.this.mRendererTask.mVideoHeight);
            this.drawer = new GLDrawer2D(true);
            float[] fArray = this.drawer.getMvpMatrix();
            fArray[5] = fArray[5] * -1.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void captureLoopGLES2() {
            int width = -1;
            int height = -1;
            ByteBuffer buf = null;
            File captureFile = null;
            while (EffectRendererHolder.this.isRunning) {
                Object object = EffectRendererHolder.this.mSync;
                synchronized (object) {
                    if (captureFile == null) {
                        if (EffectRendererHolder.this.mCaptureFile == null) {
                            try {
                                EffectRendererHolder.this.mSync.wait();
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                        if (EffectRendererHolder.this.mCaptureFile != null) {
                            captureFile = EffectRendererHolder.this.mCaptureFile;
                            EffectRendererHolder.this.mCaptureFile = null;
                        }
                        continue;
                    }
                    if (buf == null | width != EffectRendererHolder.this.mRendererTask.mVideoWidth || height != EffectRendererHolder.this.mRendererTask.mVideoHeight) {
                        width = EffectRendererHolder.this.mRendererTask.mVideoWidth;
                        height = EffectRendererHolder.this.mRendererTask.mVideoHeight;
                        buf = ByteBuffer.allocateDirect(width * height * 4);
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        if (this.captureSurface != null) {
                            this.captureSurface.release();
                            this.captureSurface = null;
                        }
                        this.captureSurface = this.egl.createOffscreen(width, height);
                    }
                    if (EffectRendererHolder.this.isRunning) {
                        this.captureSurface.makeCurrent();
                        this.drawer.draw(EffectRendererHolder.this.mRendererTask.mTexId, ((EffectRendererHolder)EffectRendererHolder.this).mRendererTask.mTexMatrix, 0);
                        this.captureSurface.swap();
                        buf.clear();
                        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
                        Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
                        if (captureFile.toString().endsWith(".jpg")) {
                            compressFormat = Bitmap.CompressFormat.JPEG;
                        }
                        FilterOutputStream os = null;
                        try {
                            try {
                                os = new BufferedOutputStream(new FileOutputStream(captureFile));
                                Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                buf.clear();
                                bmp.copyPixelsFromBuffer((Buffer)buf);
                                bmp.compress(compressFormat, 90, (OutputStream)os);
                                bmp.recycle();
                                ((BufferedOutputStream)os).flush();
                            }
                            finally {
                                if (os != null) {
                                    os.close();
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                        catch (IOException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                    }
                    captureFile = null;
                    EffectRendererHolder.this.mSync.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void captureLoopGLES3() {
            int width = -1;
            int height = -1;
            ByteBuffer buf = null;
            File captureFile = null;
            while (EffectRendererHolder.this.isRunning) {
                Object object = EffectRendererHolder.this.mSync;
                synchronized (object) {
                    if (captureFile == null) {
                        if (EffectRendererHolder.this.mCaptureFile == null) {
                            try {
                                EffectRendererHolder.this.mSync.wait();
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                        if (EffectRendererHolder.this.mCaptureFile != null) {
                            captureFile = EffectRendererHolder.this.mCaptureFile;
                            EffectRendererHolder.this.mCaptureFile = null;
                        }
                        continue;
                    }
                    if (buf == null | width != EffectRendererHolder.this.mRendererTask.mVideoWidth || height != EffectRendererHolder.this.mRendererTask.mVideoHeight) {
                        width = EffectRendererHolder.this.mRendererTask.mVideoWidth;
                        height = EffectRendererHolder.this.mRendererTask.mVideoHeight;
                        buf = ByteBuffer.allocateDirect(width * height * 4);
                        buf.order(ByteOrder.LITTLE_ENDIAN);
                        if (this.captureSurface != null) {
                            this.captureSurface.release();
                            this.captureSurface = null;
                        }
                        this.captureSurface = this.egl.createOffscreen(width, height);
                    }
                    if (EffectRendererHolder.this.isRunning) {
                        this.captureSurface.makeCurrent();
                        this.drawer.draw(EffectRendererHolder.this.mRendererTask.mTexId, ((EffectRendererHolder)EffectRendererHolder.this).mRendererTask.mTexMatrix, 0);
                        this.captureSurface.swap();
                        buf.clear();
                        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
                        Bitmap.CompressFormat compressFormat = Bitmap.CompressFormat.PNG;
                        if (captureFile.toString().endsWith(".jpg")) {
                            compressFormat = Bitmap.CompressFormat.JPEG;
                        }
                        FilterOutputStream os = null;
                        try {
                            try {
                                os = new BufferedOutputStream(new FileOutputStream(captureFile));
                                Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                                buf.clear();
                                bmp.copyPixelsFromBuffer((Buffer)buf);
                                bmp.compress(compressFormat, 90, (OutputStream)os);
                                bmp.recycle();
                                ((BufferedOutputStream)os).flush();
                            }
                            finally {
                                if (os != null) {
                                    os.close();
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                        catch (IOException e) {
                            Log.w((String)TAG, (String)"failed to save file", (Throwable)e);
                        }
                    }
                    captureFile = null;
                    EffectRendererHolder.this.mSync.notifyAll();
                }
            }
        }

        private final void release() {
            if (this.captureSurface != null) {
                this.captureSurface.makeCurrent();
                if (this.drawer != null) {
                    this.drawer.release();
                }
                this.captureSurface.release();
                this.captureSurface = null;
            }
            if (this.drawer != null) {
                this.drawer.release();
                this.drawer = null;
            }
            if (this.egl != null) {
                this.egl.release();
                this.egl = null;
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EffectRendererHolder(int width, int height, @Nullable RenderHolderCallback callback) {
        this.mCallback = callback;
        this.mRendererTask = new RendererTask(this, width, height);
        new Thread((Runnable)this.mRendererTask, TAG).start();
        if (!this.mRendererTask.waitReady()) {
            throw new RuntimeException("failed to start renderer thread");
        }
        new Thread(this.mCaptureTask, "CaptureTask").start();
        Object object = this.mSync;
        synchronized (object) {
            if (!this.isRunning) {
                try {
                    this.mSync.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.mRendererTask.release();
        Object object = this.mSync;
        synchronized (object) {
            this.isRunning = false;
            this.mSync.notifyAll();
        }
    }

    @Override
    public Surface getSurface() {
        return this.mRendererTask.getSurface();
    }

    @Override
    public SurfaceTexture getSurfaceTexture() {
        return this.mRendererTask.getSurfaceTexture();
    }

    @Override
    public void reset() {
        this.mRendererTask.checkMasterSurface();
    }

    @Override
    public void resize(int width, int height) {
        this.mRendererTask.resize(width, height);
    }

    @Override
    public void setMirror(int mirror) {
        this.mRendererTask.mirror(mirror % 4);
    }

    @Override
    public void addSurface(int id2, Object surface, boolean isRecordable) {
        this.mRendererTask.addSurface(id2, surface);
    }

    @Override
    public void addSurface(int id2, Object surface, boolean isRecordable, int maxFps) {
        this.mRendererTask.addSurface(id2, surface, maxFps);
    }

    @Override
    public void removeSurface(int id2) {
        this.mRendererTask.removeSurface(id2);
    }

    @Override
    public void requestFrame() {
        this.mRendererTask.removeRequest(1);
        this.mRendererTask.offer(1);
    }

    @Override
    public int getCount() {
        return this.mRendererTask.getCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void captureStillAsync(String path) {
        File file = new File(path);
        Object object = this.mSync;
        synchronized (object) {
            this.mCaptureFile = file;
            this.mSync.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void captureStill(String path) {
        File file = new File(path);
        Object object = this.mSync;
        synchronized (object) {
            this.mCaptureFile = file;
            this.mSync.notifyAll();
            try {
                this.mSync.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void changeEffect(int effect) {
        this.mRendererTask.changeEffect(effect % 11);
    }

    public int getCurrentEffect() {
        return this.mRendererTask.mEffect;
    }

    public void setParams(float[] params) {
        this.mRendererTask.setParams(-1, params);
    }

    public void setParams(int effect, float[] params) throws IllegalArgumentException {
        if (effect <= 0 || effect >= 11) {
            throw new IllegalArgumentException("invalid effect number:" + effect);
        }
        this.mRendererTask.setParams(effect, params);
    }

    private static final class RendererTask
    extends EglTask {
        private final Object mClientSync = new Object();
        private final SparseArray<RendererSurfaceRec> mClients = new SparseArray();
        private final EffectRendererHolder mParent;
        private final SparseArray<float[]> mParams = new SparseArray();
        private int muParamsLoc;
        private float[] mCurrentParams;
        private GLDrawer2D mDrawer;
        private int mTexId;
        private SurfaceTexture mMasterTexture;
        final float[] mTexMatrix = new float[16];
        private Surface mMasterSurface;
        private int mVideoWidth;
        private int mVideoHeight;
        private int mMirror = -1;
        private int mEffect;
        private final SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                RendererTask.this.offer(1);
            }
        };

        public RendererTask(EffectRendererHolder parent, int width, int height) {
            super(3, null, 2);
            this.mParent = parent;
            this.mVideoWidth = width;
            this.mVideoHeight = height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"NewApi"})
        protected void onStart() {
            this.mDrawer = new GLDrawer2D(true);
            this.handleReCreateMasterSurface();
            this.mParams.clear();
            this.mParams.put(9, (Object)new float[]{0.17f, 0.85f, 0.5f, 1.0f, 0.4f, 1.0f, 1.0f, 1.0f, 5.0f, 1.0f, 1.0f, 1.0f});
            this.mEffect = 0;
            this.handleChangeEffect(0);
            Object object = this.mParent.mSync;
            synchronized (object) {
                this.mParent.isRunning = true;
                this.mParent.mSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onStop() {
            Object object = this.mParent.mSync;
            synchronized (object) {
                this.mParent.isRunning = false;
                this.mParent.mSync.notifyAll();
            }
            this.makeCurrent();
            if (this.mDrawer != null) {
                this.mDrawer.release();
                this.mDrawer = null;
            }
            this.handleReleaseMasterSurface();
            this.handleRemoveAll();
        }

        @Override
        protected boolean onError(Exception e) {
            return false;
        }

        @Override
        protected Object processRequest(int request, int arg1, int arg2, Object obj) {
            switch (request) {
                case 1: {
                    this.handleDraw();
                    break;
                }
                case 2: {
                    this.handleResize(arg1, arg2);
                    break;
                }
                case 3: {
                    this.handleAddSurface(arg1, obj, arg2);
                    break;
                }
                case 4: {
                    this.handleRemoveSurface(arg1);
                    break;
                }
                case 5: {
                    this.handleReCreateMasterSurface();
                    break;
                }
                case 7: {
                    this.handleChangeEffect(arg1);
                    break;
                }
                case 6: {
                    this.handleMirror(arg1);
                    break;
                }
                case 8: {
                    this.handleSetParam(arg1, (float[])obj);
                }
            }
            return null;
        }

        public Surface getSurface() {
            this.checkMasterSurface();
            return this.mMasterSurface;
        }

        public SurfaceTexture getSurfaceTexture() {
            this.checkMasterSurface();
            return this.mMasterTexture;
        }

        public void addSurface(int id2, Object surface) {
            this.addSurface(id2, surface, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSurface(int id2, Object surface, int maxFps) {
            this.checkFinished();
            if (!(surface instanceof SurfaceTexture || surface instanceof Surface || surface instanceof SurfaceHolder)) {
                throw new IllegalArgumentException("Surface should be one of Surface, SurfaceTexture or SurfaceHolder");
            }
            Object object = this.mClientSync;
            synchronized (object) {
                if (this.mClients.get(id2) == null) {
                    while (true) {
                        if (this.offer(3, id2, maxFps, surface)) {
                            try {
                                this.mClientSync.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        try {
                            this.mClientSync.wait(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSurface(int id2) {
            Object object = this.mClientSync;
            synchronized (object) {
                if (this.mClients.get(id2) != null) {
                    while (true) {
                        if (this.offer(4, id2)) {
                            try {
                                this.mClientSync.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        try {
                            this.mClientSync.wait(10L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }

        public void changeEffect(int effect) {
            this.checkFinished();
            if (this.mEffect != effect) {
                this.offer(7, effect);
            }
        }

        public void setParams(int effect, float[] params) {
            this.checkFinished();
            this.offer(8, effect, 0, params);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getCount() {
            Object object = this.mClientSync;
            synchronized (object) {
                return this.mClients.size();
            }
        }

        public void resize(int width, int height) {
            this.checkFinished();
            if (this.mVideoWidth != width || this.mVideoHeight != height) {
                this.offer(2, width, height);
            }
        }

        public void mirror(int mirror) {
            this.checkFinished();
            if (this.mMirror != mirror) {
                this.offer(6, mirror);
            }
        }

        public void checkMasterSurface() {
            this.checkFinished();
            if (this.mMasterSurface == null || !this.mMasterSurface.isValid()) {
                Log.d((String)TAG, (String)"checkMasterSurface:invalid master surface");
                this.offerAndWait(5, 0, 0, null);
            }
        }

        private void checkFinished() {
            if (this.isFinished()) {
                throw new RuntimeException("already finished");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleDraw() {
            if (this.mMasterSurface == null || !this.mMasterSurface.isValid()) {
                Log.e((String)TAG, (String)"checkMasterSurface:invalid master surface");
                this.offer(5);
                return;
            }
            try {
                this.makeCurrent();
                this.mMasterTexture.updateTexImage();
                this.mMasterTexture.getTransformMatrix(this.mTexMatrix);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("draw:thread id =" + Thread.currentThread().getId()), (Throwable)e);
                this.offer(5);
                return;
            }
            Object e = this.mParent.mCaptureTask;
            synchronized (e) {
                this.mParent.mCaptureTask.notify();
            }
            e = this.mClientSync;
            synchronized (e) {
                int n = this.mClients.size();
                for (int i = n - 1; i >= 0; --i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null || !client.canDraw()) continue;
                    try {
                        client.draw(this.mDrawer, this.mTexId, this.mTexMatrix);
                        continue;
                    }
                    catch (Exception e2) {
                        Log.w((String)TAG, (Throwable)e2);
                        this.mClients.removeAt(i);
                        client.release();
                    }
                }
            }
            if (this.mParent.mCallback != null) {
                try {
                    this.mParent.mCallback.onFrameAvailable();
                }
                catch (Exception e3) {
                    Log.w((String)TAG, (Throwable)e3);
                }
            }
            GLES20.glClear((int)16384);
            GLES20.glFlush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleAddSurface(int id2, Object surface, int maxFps) {
            this.checkSurface();
            Object object = this.mClientSync;
            synchronized (object) {
                RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.get(id2);
                if (client == null) {
                    try {
                        client = RendererSurfaceRec.newInstance(this.getEgl(), surface, maxFps);
                        this.setMirror(client, this.mMirror);
                        this.mClients.append(id2, (Object)client);
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (String)("invalid surface: surface=" + surface), (Throwable)e);
                    }
                } else {
                    Log.w((String)TAG, (String)("surface is already added: id=" + id2));
                }
                this.mClientSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRemoveSurface(int id2) {
            Object object = this.mClientSync;
            synchronized (object) {
                RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.get(id2);
                if (client != null) {
                    this.mClients.remove(id2);
                    client.release();
                }
                this.checkSurface();
                this.mClientSync.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRemoveAll() {
            Object object = this.mClientSync;
            synchronized (object) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null) continue;
                    this.makeCurrent();
                    client.release();
                }
                this.mClients.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkSurface() {
            Object object = this.mClientSync;
            synchronized (object) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null || client.isValid()) continue;
                    int id2 = this.mClients.keyAt(i);
                    ((RendererSurfaceRec)this.mClients.valueAt(i)).release();
                    this.mClients.remove(id2);
                }
            }
        }

        @SuppressLint(value={"NewApi"})
        private void handleReCreateMasterSurface() {
            this.makeCurrent();
            this.handleReleaseMasterSurface();
            this.makeCurrent();
            this.mTexId = GLHelper.initTex(36197, 9728);
            this.mMasterTexture = new SurfaceTexture(this.mTexId);
            this.mMasterSurface = new Surface(this.mMasterTexture);
            if (BuildCheck.isAndroid4_1()) {
                this.mMasterTexture.setDefaultBufferSize(this.mVideoWidth, this.mVideoHeight);
            }
            this.mMasterTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
            try {
                if (this.mParent.mCallback != null) {
                    this.mParent.mCallback.onCreate(this.mMasterSurface);
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }

        private void handleReleaseMasterSurface() {
            try {
                if (this.mParent.mCallback != null) {
                    this.mParent.mCallback.onDestroy();
                }
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
            this.mMasterSurface = null;
            if (this.mMasterTexture != null) {
                this.mMasterTexture.release();
                this.mMasterTexture = null;
            }
            if (this.mTexId != 0) {
                GLHelper.deleteTex(this.mTexId);
                this.mTexId = 0;
            }
        }

        @SuppressLint(value={"NewApi"})
        private void handleResize(int width, int height) {
            this.mVideoWidth = width;
            this.mVideoHeight = height;
            if (BuildCheck.isAndroid4_1()) {
                this.mMasterTexture.setDefaultBufferSize(this.mVideoWidth, this.mVideoHeight);
            }
        }

        private void handleChangeEffect(int effect) {
            this.mEffect = effect;
            switch (effect) {
                case 0: {
                    this.mDrawer.updateShader("#version 100\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES sTexture;\nvarying highp vec2 vTextureCoord;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, vTextureCoord);\n}");
                    break;
                }
                case 1: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_GRAY_OES);
                    break;
                }
                case 2: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_GRAY_REVERSE_OES);
                    break;
                }
                case 3: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_OES);
                    break;
                }
                case 4: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_YELLOW_OES);
                    break;
                }
                case 5: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_GREEN_OES);
                    break;
                }
                case 6: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_REVERSE_OES);
                    break;
                }
                case 7: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_REVERSE_YELLOW_OES);
                    break;
                }
                case 8: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_BIN_REVERSE_GREEN_OES);
                    break;
                }
                case 9: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_OES);
                    break;
                }
                case 10: {
                    this.mDrawer.updateShader(FRAGMENT_SHADER_EMPHASIZE_RED_YELLOW_WHITE_OES);
                }
            }
            this.muParamsLoc = this.mDrawer.glGetUniformLocation("uParams");
            this.mCurrentParams = (float[])this.mParams.get(effect);
            this.updateParams();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMirror(int mirror) {
            this.mMirror = mirror;
            Object object = this.mClientSync;
            synchronized (object) {
                int n = this.mClients.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurfaceRec client = (RendererSurfaceRec)this.mClients.valueAt(i);
                    if (client == null) continue;
                    this.setMirror(client, mirror);
                }
            }
        }

        private void setMirror(RendererSurfaceRec client, int mirror) {
            float[] mvp = client.mMvpMatrix;
            switch (mirror) {
                case 0: {
                    mvp[0] = Math.abs(mvp[0]);
                    mvp[5] = Math.abs(mvp[5]);
                    break;
                }
                case 1: {
                    mvp[0] = -Math.abs(mvp[0]);
                    mvp[5] = Math.abs(mvp[5]);
                    break;
                }
                case 2: {
                    mvp[0] = Math.abs(mvp[0]);
                    mvp[5] = -Math.abs(mvp[5]);
                    break;
                }
                case 3: {
                    mvp[0] = -Math.abs(mvp[0]);
                    mvp[5] = -Math.abs(mvp[5]);
                }
            }
        }

        private void handleSetParam(int effect, float[] params) {
            if (effect < 0 || this.mEffect == effect) {
                this.mCurrentParams = params;
                this.mParams.put(this.mEffect, (Object)params);
                this.updateParams();
            } else {
                this.mParams.put(effect, (Object)params);
            }
        }

        private void updateParams() {
            int n = Math.min(this.mCurrentParams != null ? this.mCurrentParams.length : 0, 18);
            if (this.muParamsLoc >= 0 && n > 0) {
                this.mDrawer.glUseProgram();
                GLES20.glUniform1fv((int)this.muParamsLoc, (int)n, (float[])this.mCurrentParams, (int)0);
            }
        }
    }
}

