/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.g2.engine.plugin;

import com.senzing.g2.engine.plugin.ArrayMap;
import com.senzing.g2.engine.plugin.ArraySet;
import com.senzing.g2.engine.plugin.FeatureInfo;
import com.senzing.g2.engine.plugin.G2PluginInterface;
import java.util.Map;
import java.util.Set;

public interface G2ScoringPlugin
extends G2PluginInterface {
    public int score(ScoringContext var1);

    default public int getScoreNames(StringBuilder scoreNames) {
        ArraySet<String> scoreSet = new ArraySet<String>();
        int returnCode = this.getScoreNames(scoreSet);
        if (returnCode < 0) {
            return returnCode;
        }
        scoreNames.append("[");
        boolean firstAdded = false;
        for (String scoreName : scoreSet) {
            if (firstAdded) {
                scoreNames.append(",");
            }
            firstAdded = true;
            scoreNames.append("\"").append(scoreName).append("\"");
        }
        scoreNames.append("]");
        return returnCode;
    }

    public int getScoreNames(Set<String> var1);

    public static class ScoringContext {
        private FeatureInfo feat1 = null;
        private FeatureInfo feat2 = null;
        private Map<String, String> results = null;
        private String errorMessage = null;

        public ScoringContext(FeatureInfo feature1, FeatureInfo feature2) {
            this.feat1 = feature1;
            this.feat2 = feature2;
            this.results = new ArrayMap<String, String>();
        }

        public FeatureInfo getFeature1() {
            return this.feat1;
        }

        public FeatureInfo getFeature2() {
            return this.feat2;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String message) {
            this.errorMessage = message;
        }

        public Map<String, String> getResults() {
            return this.results;
        }
    }
}

