/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.g2.engine.plugin;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ArrayMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private ArrayList<Map.Entry<K, V>> entries;

    public ArrayMap() {
        this.entries = new ArrayList();
    }

    public ArrayMap(int initialCapacity) {
        this.entries = new ArrayList(initialCapacity);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    private Map.Entry<K, V> findEntry(Object key) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (!Objects.equals(entry.getKey(), key)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        Map.Entry<K, V> entry = this.findEntry(key);
        if (entry == null) {
            entry = new AbstractMap.SimpleEntry<K, V>(key, value);
            this.entries.add(entry);
            return null;
        }
        return entry.setValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, V> entry : this.entries) {
            if (!Objects.equals(entry.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public V remove(Object key) {
        Iterator<Map.Entry<K, V>> iter = this.entries.iterator();
        while (iter.hasNext()) {
            Map.Entry<K, V> entry = iter.next();
            if (!Objects.equals(entry.getKey(), key)) continue;
            iter.remove();
            return entry.getValue();
        }
        return null;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return ArrayMap.this.entries.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return ArrayMap.this.entries.iterator();
        }
    }
}

