/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.network.HttpCallback;
import com.sensorsdata.analytics.android.sdk.network.HttpMethod;
import com.sensorsdata.analytics.android.sdk.network.RequestHelper;
import com.sensorsdata.analytics.android.sdk.util.SensorsDataUtils;
import java.util.HashMap;
import org.json.JSONObject;

public class PairingCodeRequestHelper {
    private static final String TAG = "SA.ParingCodeHttpRequest";
    private static final String URL_VERIFY_SUFFIX = "api/sdk/heat_maps/scanning/pairing_code";

    public void verifyPairingCodeRequest(final Context context, String paringCode, final IApiCallback callback) {
        try {
            String serverUrl = SensorsDataAPI.sharedInstance().getServerUrl();
            if (TextUtils.isEmpty((CharSequence)serverUrl)) {
                SALog.i((String)TAG, (String)"verifyParingCodeRequest | server url is null and return");
                return;
            }
            Uri uri = Uri.parse((String)SensorsDataAPI.sharedInstance().getServerUrl());
            Uri.Builder builder = new Uri.Builder();
            builder.scheme(uri.getScheme()).encodedAuthority(uri.getAuthority());
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("pairing_code", paringCode);
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("sensorsdata-project", uri.getQueryParameter("project"));
            new RequestHelper.Builder(HttpMethod.GET, builder.appendEncodedPath(URL_VERIFY_SUFFIX).toString()).params(params).header(header).callback((HttpCallback)new HttpCallback.JsonCallback(){

                public void onFailure(int code, String errorMessage) {
                    if (callback != null) {
                        callback.onFailure(errorMessage);
                    }
                }

                public void onResponse(JSONObject response) {
                    if (response == null) {
                        return;
                    }
                    SALog.i((String)PairingCodeRequestHelper.TAG, (String)("verifyParingCodeRequest onResponse | response: " + response.toString()));
                    boolean isSuccess = response.optBoolean("is_success");
                    if (isSuccess) {
                        String urlString = response.optString("url");
                        SALog.i((String)PairingCodeRequestHelper.TAG, (String)("verifyParingCodeRequest onResponse | url: " + urlString));
                        if (!TextUtils.isEmpty((CharSequence)urlString)) {
                            SensorsDataUtils.handleSchemeUrl((Activity)((Activity)context), (Intent)new Intent().setData(Uri.parse((String)urlString)));
                        }
                        if (callback != null) {
                            callback.onSuccess();
                        }
                    } else if (callback != null) {
                        callback.onFailure(response.optString("error_msg"));
                    }
                }

                public void onAfter() {
                }
            }).execute();
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public static interface IApiCallback {
        public void onSuccess();

        public void onFailure(String var1);
    }
}

