/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.impl;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.jsbridge.H5Helper;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataActivityLifecycleCallbacks;
import com.sensorsdata.analytics.android.sdk.monitor.SensorsDataLifecycleMonitorManager;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import com.sensorsdata.analytics.android.sdk.util.visual.ViewNode;
import com.sensorsdata.analytics.android.sdk.visual.HeatMapService;
import com.sensorsdata.analytics.android.sdk.visual.NodesProcess;
import com.sensorsdata.analytics.android.sdk.visual.R;
import com.sensorsdata.analytics.android.sdk.visual.VisualizedAutoTrackService;
import com.sensorsdata.analytics.android.sdk.visual.WebViewVisualInterface;
import com.sensorsdata.analytics.android.sdk.visual.property.VisualPropertiesManager;
import com.sensorsdata.analytics.android.sdk.visual.utils.AppStateManager;
import com.sensorsdata.analytics.android.sdk.visual.utils.VisualUtil;
import com.sensorsdata.analytics.android.sdk.visual.view.PairingCodeEditDialog;
import com.sensorsdata.analytics.android.sdk.visual.view.VisualDialog;
import org.json.JSONObject;

public class VisualProtocolImpl {
    private static final String TAG = "SA.SAVisualProtocolImpl";
    private final SAContextManager mSAContextManager;

    public VisualProtocolImpl(SAContextManager contextManager) {
        this.mSAContextManager = contextManager;
        SensorsDataLifecycleMonitorManager.getInstance().addActivityLifeCallback((SensorsDataActivityLifecycleCallbacks.SAActivityLifecycleCallbacks)new AppStateManager());
    }

    public <T> T invokeModuleFunction(String methodName, Object ... argv) {
        try {
            switch (methodName) {
                case "addVisualJavascriptInterface": {
                    this.addVisualJavascriptInterface((View)argv[0]);
                    break;
                }
                case "requestVisualConfig": {
                    VisualPropertiesManager.getInstance().requestVisualConfig(this.mSAContextManager);
                    break;
                }
                case "mergeVisualProperties": {
                    this.mergeVisualProperties((JSONObject)argv[0], (View)argv[1]);
                    break;
                }
                case "resumeVisualService": {
                    VisualizedAutoTrackService.getInstance().resume();
                    break;
                }
                case "stopVisualService": {
                    VisualizedAutoTrackService.getInstance().stop();
                    break;
                }
                case "resumeHeatMapService": {
                    HeatMapService.getInstance().resume();
                    break;
                }
                case "stopHeatMapService": {
                    HeatMapService.getInstance().stop();
                    break;
                }
                case "showPairingCodeInputDialog": {
                    this.showPairingCodeInputDialog((Context)argv[0]);
                    break;
                }
                case "showOpenHeatMapDialog": {
                    VisualDialog.showOpenHeatMapDialog((Activity)argv[0], (String)argv[1], (String)argv[2]);
                    break;
                }
                case "showOpenVisualizedAutoTrackDialog": {
                    VisualDialog.showOpenVisualizedAutoTrackDialog((Activity)argv[0], (String)argv[1], (String)argv[2]);
                    break;
                }
                case "h5GetAppVisualConfig": {
                    return (T)this.h5GetAppVisualConfig();
                }
                case "flutterGetAppVisualConfig": {
                    return (T)this.flutterGetAppVisualConfig();
                }
                case "getVisualState": {
                    return (T)this.getVisualState();
                }
                case "sendVisualizedMessage": {
                    this.sendVisualizedMessage((String)argv[0]);
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
        return null;
    }

    private void mergeVisualProperties(JSONObject srcObject, View view) {
        try {
            if (view == null) {
                return;
            }
            Activity activity = SAViewUtils.getActivityOfView((Context)view.getContext(), (View)view);
            ViewNode viewNode = VisualUtil.addViewPathProperties(activity, view, srcObject);
            if (this.mSAContextManager.getInternalConfigs().saConfigOptions.isVisualizedPropertiesEnabled()) {
                VisualPropertiesManager.getInstance().mergeVisualProperties(VisualPropertiesManager.VisualEventType.APP_CLICK, srcObject, viewNode);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    public String h5GetAppVisualConfig() {
        String visualCache = this.appVisualConfig();
        if (!TextUtils.isEmpty((CharSequence)visualCache)) {
            return Base64.encodeToString((byte[])visualCache.getBytes(), (int)0);
        }
        return null;
    }

    private String appVisualConfig() {
        try {
            if (this.mSAContextManager.getInternalConfigs().saConfigOptions == null || !this.mSAContextManager.getInternalConfigs().saConfigOptions.isVisualizedPropertiesEnabled()) {
                return null;
            }
            VisualPropertiesManager.getInstance().getVisualPropertiesH5Helper().registerListeners();
            String visualCache = VisualPropertiesManager.getInstance().getVisualPropertiesCache().getVisualCache();
            return visualCache;
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
            return null;
        }
    }

    private void addVisualJavascriptInterface(View webView) {
        if (webView != null && webView.getTag(R.id.sensors_analytics_tag_view_webview_visual) == null) {
            webView.setTag(R.id.sensors_analytics_tag_view_webview_visual, new Object());
            H5Helper.addJavascriptInterface((View)webView, (Object)new WebViewVisualInterface(webView), (String)"SensorsData_App_Visual_Bridge");
        }
    }

    private void showPairingCodeInputDialog(final Context context) {
        if (this.mSAContextManager.getContext() == null) {
            SALog.i((String)TAG, (String)"The argument context can't be null");
            return;
        }
        if (!(context instanceof Activity)) {
            SALog.i((String)TAG, (String)"The static method showPairingCodeEditDialog(Context context) only accepts Activity as a parameter");
            return;
        }
        Activity activity = (Activity)context;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                PairingCodeEditDialog dialog = new PairingCodeEditDialog(context);
                dialog.show();
            }
        });
    }

    public String flutterGetAppVisualConfig() {
        String visualCache = this.appVisualConfig();
        if (!TextUtils.isEmpty((CharSequence)visualCache)) {
            return Base64.encodeToString((byte[])visualCache.getBytes(), (int)2);
        }
        return null;
    }

    public Boolean getVisualState() {
        return VisualizedAutoTrackService.getInstance().isServiceRunning() || HeatMapService.getInstance().isServiceRunning();
    }

    public void sendVisualizedMessage(String msg) {
        NodesProcess.getInstance().getFlutterNodesManager().handlerMessage(msg);
    }
}

