/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.visual.bridge;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.listener.SAJSListener;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.visual.bridge.JSRequest;
import com.sensorsdata.analytics.android.sdk.visual.bridge.OnBridgeCallback;
import com.sensorsdata.analytics.android.sdk.visual.bridge.WebViewJavascriptBridge;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class JSBridgeHelper
implements WebViewJavascriptBridge {
    private static final String CALLBACK_ID_FORMAT = "JAVA_CB_%s";
    private static final String CALL_TYPE_GET_VISUAL_PROPERTIES = "getJSVisualProperties";
    private Map<String, OnBridgeCallback> mCallbacks = new HashMap<String, OnBridgeCallback>();
    private SAJSListener mSAJSListener;

    public void addSAJSListener() {
        if (this.mSAJSListener == null) {
            this.mSAJSListener = new SAJSListener(){

                public void onReceiveJSMessage(WeakReference<View> view, String message) {
                    try {
                        JSONObject dataObj;
                        OnBridgeCallback function;
                        String messageId;
                        JSONObject obj = new JSONObject(message);
                        String callType = obj.optString("callType");
                        if (TextUtils.equals((CharSequence)JSBridgeHelper.CALL_TYPE_GET_VISUAL_PROPERTIES, (CharSequence)callType) && !TextUtils.isEmpty((CharSequence)(messageId = obj.optString("message_id"))) && (function = (OnBridgeCallback)JSBridgeHelper.this.mCallbacks.remove(messageId)) != null && (dataObj = obj.optJSONObject("data")) != null) {
                            function.onCallBack(dataObj.toString());
                        }
                    }
                    catch (Exception e) {
                        SALog.printStackTrace((Exception)e);
                    }
                }
            };
            SensorsDataAPI.sharedInstance().addSAJSListener(this.mSAJSListener);
        }
    }

    @Override
    public synchronized void sendToWeb(final View webView, final String methodName, Object data, OnBridgeCallback responseCallback) {
        try {
            JSONObject obj;
            if (TextUtils.isEmpty((CharSequence)methodName)) {
                return;
            }
            JSRequest request = new JSRequest();
            request.methodName = methodName;
            if (responseCallback != null) {
                String messageId = String.format(CALLBACK_ID_FORMAT, SystemClock.currentThreadTimeMillis());
                this.mCallbacks.put(messageId, responseCallback);
                request.messageId = messageId;
            }
            JSONObject object = null;
            if (data instanceof String) {
                if (!TextUtils.isEmpty((CharSequence)((String)data))) {
                    object = new JSONObject((String)data);
                }
            } else if (data instanceof JSONObject) {
                object = new JSONObject();
                object.put("message_id", (Object)request.messageId);
                object.put("platform", (Object)"Android");
                JSONUtils.mergeJSONObject((JSONObject)((JSONObject)data), (JSONObject)object);
            }
            if ((obj = object) == null) {
                return;
            }
            if (webView != null) {
                webView.post(new Runnable(){

                    @Override
                    public void run() {
                        String result = "'" + methodName + "','" + Base64.encodeToString((byte[])obj.toString().getBytes(), (int)0) + "'";
                        JSBridgeHelper.invokeWebViewLoad(webView, "loadUrl", new Object[]{"javascript:window.sensorsdata_app_call_js(" + result + ")"}, new Class[]{String.class});
                    }
                });
            }
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }

    @Override
    public void sendToWeb(View webView, String methodName, Object data) {
        this.sendToWeb(webView, methodName, data, null);
    }

    private static void invokeWebViewLoad(View webView, String methodName, Object[] params, Class[] paramTypes) {
        try {
            Class<?> clazz = webView.getClass();
            Method loadMethod = clazz.getMethod(methodName, paramTypes);
            loadMethod.invoke((Object)webView, params);
        }
        catch (Exception e) {
            SALog.printStackTrace((Exception)e);
        }
    }
}

