/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.exposure;

import android.os.Build;
import android.view.View;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.business.exposure.SAExposureConfig;
import com.sensorsdata.analytics.android.sdk.core.business.exposure.SAExposureData;
import com.sensorsdata.analytics.android.sdk.core.mediator.protocol.SAModuleProtocol;
import com.sensorsdata.analytics.android.sdk.exposure.SAExposedProcess;
import org.json.JSONObject;

public class SAExposureProtocolImpl
implements SAModuleProtocol {
    private boolean mEnable = false;
    private SAExposedProcess mExposedProcess;

    public void install(SAContextManager contextManager) {
        if (Build.VERSION.SDK_INT < 16) {
            this.setModuleState(false);
            return;
        }
        if (!contextManager.getInternalConfigs().saConfigOptions.isDisableSDK()) {
            this.setModuleState(true);
        }
        this.init(contextManager.getInternalConfigs().saConfigOptions.getExposureConfig());
    }

    public void setModuleState(boolean enable) {
        if (this.mEnable != enable) {
            this.mEnable = enable;
        }
    }

    public String getModuleName() {
        return "sensors_analytics_module_exposure";
    }

    public boolean isEnable() {
        return this.mEnable;
    }

    public int getPriority() {
        return 5;
    }

    public <T> T invokeModuleFunction(String methodName, Object ... argv) {
        switch (methodName) {
            case "addExposureView": {
                this.addExposureView((View)argv[0], (SAExposureData)argv[1]);
                break;
            }
            case "setExposureIdentifier": {
                this.setExposureIdentifier((View)argv[0], (String)argv[1]);
                break;
            }
            case "removeExposureView": {
                if (argv.length == 2) {
                    this.removeExposureView((View)argv[0], (String)argv[1]);
                    break;
                }
                this.removeExposureView((View)argv[0], null);
                break;
            }
            case "updateExposureProperties": {
                this.mExposedProcess.updateExposureView((View)argv[0], (JSONObject)argv[1]);
            }
        }
        return null;
    }

    private void init(SAExposureConfig exposureConfig) {
        if (exposureConfig == null) {
            exposureConfig = new SAExposureConfig(0.0f, 0.0, true);
        }
        this.mExposedProcess = new SAExposedProcess(exposureConfig);
    }

    private void setExposureIdentifier(View view, String exposureIdentifier) {
        if (this.mExposedProcess != null) {
            this.mExposedProcess.setExposureIdentifier(view, exposureIdentifier);
        }
    }

    private void addExposureView(View view, SAExposureData exposureData) {
        if (this.mExposedProcess != null) {
            this.mExposedProcess.addExposureView(view, exposureData);
        }
    }

    private void removeExposureView(View view, String identifier) {
        if (this.mExposedProcess != null) {
            this.mExposedProcess.removeExposureView(view, identifier);
        }
    }
}

