/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class TimeUtils {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static Locale SDK_LOCALE = Locale.CHINA;
    private static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    private static Map<String, ThreadLocal<SimpleDateFormat>> formatMaps = new HashMap<String, ThreadLocal<SimpleDateFormat>>();

    public static String formatTime(long timeMillis) {
        return TimeUtils.formatTime(timeMillis, SDK_LOCALE);
    }

    public static String formatTime(long timeMillis, String patten) {
        return TimeUtils.formatTime(timeMillis, patten, SDK_LOCALE);
    }

    public static String formatTime(long timeMillis, Locale locale) {
        return TimeUtils.formatTime(timeMillis, null, locale);
    }

    public static String formatTime(long timeMillis, String patten, Locale locale) {
        SimpleDateFormat simpleDateFormat;
        String formatString = "";
        if (TextUtils.isEmpty((CharSequence)patten)) {
            patten = YYYY_MM_DD_HH_MM_SS_SSS;
        }
        if (null == (simpleDateFormat = TimeUtils.getDateFormat(patten, locale))) {
            return formatString;
        }
        try {
            formatString = simpleDateFormat.format(timeMillis);
        }
        catch (IllegalArgumentException e) {
            SALog.printStackTrace(e);
        }
        return formatString;
    }

    public static String formatDate(Date date) {
        return TimeUtils.formatDate(date, YYYY_MM_DD_HH_MM_SS_SSS);
    }

    public static String formatDate(Date date, String patten) {
        return TimeUtils.formatDate(date, patten, SDK_LOCALE);
    }

    public static String formatDate(Date date, Locale locale) {
        return TimeUtils.formatDate(date, YYYY_MM_DD_HH_MM_SS_SSS, locale);
    }

    public static String formatDate(Date date, String patten, Locale locale) {
        if (TextUtils.isEmpty((CharSequence)patten)) {
            patten = YYYY_MM_DD_HH_MM_SS_SSS;
        }
        String formatString = "";
        SimpleDateFormat simpleDateFormat = TimeUtils.getDateFormat(patten, locale);
        if (null == simpleDateFormat) {
            return formatString;
        }
        try {
            formatString = simpleDateFormat.format(date);
        }
        catch (IllegalArgumentException e) {
            SALog.printStackTrace(e);
        }
        return formatString;
    }

    public static boolean isDateValid(Date date) {
        try {
            SimpleDateFormat simpleDateFormat = TimeUtils.getDateFormat(YYYY_MM_DD_HH_MM_SS_SSS, SDK_LOCALE);
            Date baseDate = simpleDateFormat.parse("2015-05-15 10:24:00.000");
            return date.after(baseDate);
        }
        catch (ParseException e) {
            SALog.printStackTrace(e);
            return false;
        }
    }

    public static boolean isDateValid(long time) {
        try {
            SimpleDateFormat simpleDateFormat = TimeUtils.getDateFormat(YYYY_MM_DD_HH_MM_SS_SSS, SDK_LOCALE);
            Date baseDate = simpleDateFormat.parse("2015-05-15 10:24:00.000");
            if (baseDate == null) {
                return false;
            }
            return baseDate.getTime() < time;
        }
        catch (ParseException e) {
            SALog.printStackTrace(e);
            return false;
        }
    }

    public static JSONObject formatDate(JSONObject jsonObject) {
        if (jsonObject == null) {
            return new JSONObject();
        }
        try {
            Iterator iterator = jsonObject.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = jsonObject.get(key);
                if (!(value instanceof Date)) continue;
                jsonObject.put(key, (Object)TimeUtils.formatDate((Date)value, SDK_LOCALE));
            }
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
        return jsonObject;
    }

    public static Integer getZoneOffset() {
        try {
            Calendar cal = Calendar.getInstance(Locale.getDefault());
            int zoneOffset = cal.get(15) + cal.get(16);
            return -zoneOffset / 60000;
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return null;
        }
    }

    public static Float duration(long startTime, long endTime) {
        long duration = endTime - startTime;
        try {
            if (duration < 0L || duration > 86400000L) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf((float)Math.round(duration) / 1000.0f);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return Float.valueOf(0.0f);
        }
    }

    public static Float duration(float duration) {
        return Float.valueOf((float)Math.round(duration) / 1000.0f);
    }

    private static synchronized SimpleDateFormat getDateFormat(final String patten, final Locale locale) {
        ThreadLocal<SimpleDateFormat> dateFormatThreadLocal = formatMaps.get(patten + "_" + (locale == null ? SDK_LOCALE.getCountry() : locale.getCountry()));
        if (null == dateFormatThreadLocal && null != (dateFormatThreadLocal = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat simpleDateFormat = null;
                try {
                    simpleDateFormat = locale == null ? new SimpleDateFormat(patten, SDK_LOCALE) : new SimpleDateFormat(patten, locale);
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
                return simpleDateFormat;
            }
        }).get()) {
            formatMaps.put(patten + "_" + (locale == null ? SDK_LOCALE.getCountry() : locale.getCountry()), dateFormatThreadLocal);
        }
        return dateFormatThreadLocal.get();
    }
}

