/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.network;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.network.HttpCallback;
import com.sensorsdata.analytics.android.sdk.network.HttpConfig;
import com.sensorsdata.analytics.android.sdk.network.HttpMethod;
import com.sensorsdata.analytics.android.sdk.network.HttpTaskManager;
import com.sensorsdata.analytics.android.sdk.network.HttpUtils;
import com.sensorsdata.analytics.android.sdk.network.RealRequest;
import com.sensorsdata.analytics.android.sdk.network.RealResponse;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class RequestHelper {
    private boolean isRedirected = false;

    private RequestHelper(HttpMethod method, String url, HttpConfig httpConfig, Map<String, String> paramsMap, Map<String, String> headerMap, int retryCount, HttpCallback callBack) {
        switch (method) {
            case GET: {
                this.urlHttpGet(url, httpConfig, paramsMap, headerMap, retryCount, callBack);
                break;
            }
            case POST: {
                this.urlHttpPost(url, httpConfig, paramsMap, "", headerMap, retryCount, callBack);
            }
        }
    }

    private RequestHelper(String url, HttpConfig httpConfig, String jsonData, Map<String, String> headerMap, int retryCount, HttpCallback callBack) {
        this.urlHttpPost(url, httpConfig, null, jsonData, headerMap, retryCount, callBack);
    }

    private void urlHttpGet(final String url, final HttpConfig httpConfig, final Map<String, String> paramsMap, final Map<String, String> headerMap, final int retryCount, final HttpCallback callBack) {
        final int requestCount = retryCount - 1;
        HttpTaskManager.execute(new Runnable(){

            @Override
            public void run() {
                RealResponse response = new RealRequest().setHttpConfig(httpConfig).getData(RequestHelper.this.getUrl(url, paramsMap), headerMap);
                if (response.code == 200 || response.code == 204) {
                    if (callBack != null) {
                        callBack.onSuccess(response);
                    }
                } else if (!RequestHelper.this.isRedirected && HttpUtils.needRedirects(response.code)) {
                    RequestHelper.this.isRedirected = true;
                    RequestHelper.this.urlHttpGet(response.location, httpConfig, paramsMap, headerMap, retryCount, callBack);
                } else if (requestCount != 0) {
                    RequestHelper.this.urlHttpGet(url, httpConfig, paramsMap, headerMap, requestCount, callBack);
                } else if (callBack != null) {
                    callBack.onError(response);
                }
            }
        });
    }

    private void urlHttpPost(final String url, final HttpConfig httpConfig, final Map<String, String> paramsMap, final String jsonData, final Map<String, String> headerMap, final int retryCount, final HttpCallback callBack) {
        final int requestCount = retryCount - 1;
        HttpTaskManager.execute(new Runnable(){

            @Override
            public void run() {
                RealResponse response = new RealRequest().setHttpConfig(httpConfig).postData(url, RequestHelper.this.getPostBody(paramsMap, jsonData), RequestHelper.this.getPostBodyType(paramsMap, jsonData), headerMap);
                if (response.code == 200 || response.code == 204) {
                    if (callBack != null) {
                        callBack.onSuccess(response);
                    }
                } else if (!RequestHelper.this.isRedirected && HttpUtils.needRedirects(response.code)) {
                    RequestHelper.this.isRedirected = true;
                    RequestHelper.this.urlHttpPost(response.location, httpConfig, paramsMap, jsonData, headerMap, retryCount, callBack);
                } else if (requestCount != 0) {
                    RequestHelper.this.urlHttpPost(url, httpConfig, paramsMap, jsonData, headerMap, requestCount, callBack);
                } else if (callBack != null) {
                    callBack.onError(response);
                }
            }
        });
    }

    private String getUrl(String path, Map<String, String> paramsMap) {
        if (path != null && paramsMap != null) {
            path = !path.contains("?") ? path + "?" : path + "&";
            for (String key : paramsMap.keySet()) {
                path = path + key + "=" + paramsMap.get(key) + "&";
            }
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private String getPostBody(Map<String, String> params, String jsonStr) {
        if (params != null) {
            return this.getPostBodyFormParamsMap(params);
        }
        if (!TextUtils.isEmpty((CharSequence)jsonStr)) {
            return jsonStr;
        }
        return null;
    }

    private String getPostBodyFormParamsMap(Map<String, String> params) {
        if (params != null) {
            StringBuilder result = new StringBuilder();
            boolean first = true;
            try {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        result.append("&");
                    }
                    result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                    result.append("=");
                    result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                }
                return result.toString();
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    private String getPostBodyType(Map<String, String> paramsMap, String jsonStr) {
        if (paramsMap != null) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)jsonStr)) {
            return "application/json;charset=utf-8";
        }
        return null;
    }

    public static class Builder {
        private HttpMethod httpMethod;
        private String httpUrl;
        private Map<String, String> paramsMap;
        private String jsonData;
        private Map<String, String> headerMap;
        private HttpCallback callBack;
        private int retryCount = 1;
        private HttpConfig httpConfig;

        public Builder(HttpMethod method, String url) {
            this.httpMethod = method;
            this.httpUrl = url;
        }

        public Builder params(Map<String, String> paramsMap) {
            this.paramsMap = paramsMap;
            return this;
        }

        public Builder jsonData(String data) {
            this.jsonData = data;
            return this;
        }

        public Builder header(Map<String, String> headerMap) {
            this.headerMap = headerMap;
            return this;
        }

        public Builder callback(HttpCallback callBack) {
            this.callBack = callBack;
            return this;
        }

        public Builder retryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout) {
            if (this.httpConfig == null) {
                this.httpConfig = new HttpConfig();
            }
            this.httpConfig.setConnectionTimeout(connectionTimeout);
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            if (this.httpConfig == null) {
                this.httpConfig = new HttpConfig();
            }
            this.httpConfig.setReadTimeout(readTimeout);
            return this;
        }

        public void execute() {
            if (this.httpMethod == HttpMethod.POST && this.paramsMap == null) {
                new RequestHelper(this.httpUrl, this.httpConfig, this.jsonData, this.headerMap, this.retryCount, this.callBack);
            } else {
                new RequestHelper(this.httpMethod, this.httpUrl, this.httpConfig, this.paramsMap, this.headerMap, this.retryCount, this.callBack);
            }
        }
    }
}

