/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data.adapter;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.data.adapter.DataOperation;
import org.json.JSONObject;

class PersistentDataOperation
extends DataOperation {
    PersistentDataOperation(Context context) {
        super(context);
    }

    @Override
    String[] queryData(Uri uri, int limit) {
        return this.handleQueryUri(uri);
    }

    @Override
    String[] queryData(Uri uri, boolean is_instant_event, int limit) {
        return this.handleQueryUri(uri);
    }

    @Override
    int insertData(Uri uri, JSONObject jsonObject) {
        return this.handleInsertUri(uri, jsonObject);
    }

    @Override
    int insertData(Uri uri, ContentValues contentValues) {
        this.contentResolver.insert(uri, contentValues);
        return 0;
    }

    private int handleInsertUri(Uri uri, JSONObject jsonObject) {
        if (uri == null) {
            return -1;
        }
        try {
            ContentValues contentValues = new ContentValues();
            String path = uri.getPath();
            if (!TextUtils.isEmpty((CharSequence)path)) {
                switch (path = path.substring(1)) {
                    case "activity_started_count": {
                        contentValues.put("activity_started_count", Integer.valueOf(jsonObject.optInt("value")));
                        break;
                    }
                    case "app_exit_data": {
                        contentValues.put("app_exit_data", jsonObject.optString("value"));
                        break;
                    }
                    case "app_start_time": {
                        contentValues.put("app_start_time", Long.valueOf(jsonObject.optLong("value")));
                        break;
                    }
                    case "session_interval_time": {
                        contentValues.put("session_interval_time", Long.valueOf(jsonObject.optLong("value")));
                        break;
                    }
                    case "events_login_id": {
                        contentValues.put("events_login_id", jsonObject.optString("value"));
                        break;
                    }
                    case "sub_process_flush_data": {
                        contentValues.put("sub_process_flush_data", Boolean.valueOf(jsonObject.optBoolean("value")));
                        break;
                    }
                    case "first_process_start": {
                        contentValues.put("first_process_start", Boolean.valueOf(jsonObject.optBoolean("value")));
                        break;
                    }
                    case "sensorsdata_sdk_configuration": {
                        contentValues.put("sensorsdata_sdk_configuration", jsonObject.optString("value"));
                        break;
                    }
                    case "user_ids": {
                        contentValues.put("user_ids", jsonObject.optString("value"));
                        break;
                    }
                    case "login_id_key": {
                        contentValues.put("login_id_key", jsonObject.optString("value"));
                        break;
                    }
                    case "push_key": {
                        contentValues.put("push_key", jsonObject.optString("push_key"));
                        contentValues.put("push_value", jsonObject.optString("push_value"));
                        break;
                    }
                    default: {
                        return -1;
                    }
                }
                this.contentResolver.insert(uri, contentValues);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] handleQueryUri(Uri uri) {
        if (uri == null) {
            return null;
        }
        String path = uri.getPath();
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        try (Cursor cursor = null;){
            path = path.substring(1);
            cursor = this.contentResolver.query(uri, null, null, null, null);
            if (cursor != null && cursor.getCount() > 0) {
                cursor.moveToNext();
                switch (path) {
                    case "activity_started_count": 
                    case "sub_process_flush_data": 
                    case "first_process_start": {
                        String[] stringArray = new String[]{String.valueOf(cursor.getInt(0))};
                        return stringArray;
                    }
                    case "app_exit_data": 
                    case "events_login_id": 
                    case "sensorsdata_sdk_configuration": 
                    case "user_ids": 
                    case "login_id_key": 
                    case "push_key": {
                        String[] stringArray = new String[]{cursor.getString(0)};
                        return stringArray;
                    }
                    case "session_interval_time": 
                    case "app_start_time": {
                        String[] stringArray = new String[]{String.valueOf(cursor.getLong(0))};
                        return stringArray;
                    }
                }
                String[] stringArray = null;
                return stringArray;
            }
        }
        return null;
    }

    @Override
    void deleteData(Uri uri, String key) {
        this.contentResolver.delete(uri.buildUpon().appendQueryParameter("remove_key", key).build(), null, null);
    }
}

