/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data.adapter;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.data.adapter.DataOperation;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbParams;
import com.sensorsdata.analytics.android.sdk.data.adapter.EventDataOperation;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class DataManagerOperation
extends DataOperation {
    private final Uri uriDataManager = Uri.parse((String)"content://com.sensorsdata.manager.SensorsDataContentProvider/events");
    private EventDataOperation mEventDataOperation;
    private boolean isEncrypt;

    DataManagerOperation(Context context, boolean isEncrypt) {
        super(context);
        this.isEncrypt = isEncrypt;
        this.mEventDataOperation = new EventDataOperation(context);
    }

    @Override
    int insertData(Uri uri, JSONObject jsonObject) {
        try {
            if (this.deleteDataLowMemory(this.uriDataManager) != 0) {
                return -2;
            }
            if (this.isEncrypt) {
                jsonObject = (JSONObject)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_encrypt", "encryptEventData", jsonObject);
            }
            ContentValues cv = new ContentValues();
            cv.put("data", jsonObject.toString() + "\t" + jsonObject.toString().hashCode());
            cv.put("created_at", Long.valueOf(System.currentTimeMillis()));
            try {
                this.contentResolver.insert(this.uriDataManager, cv);
                this.sendCacheData();
            }
            catch (Exception exception) {
                SALog.printStackTrace(exception);
                this.mEventDataOperation.insertData(DbParams.getInstance().getEventCacheUri(), cv);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return 0;
    }

    @Override
    int insertData(Uri uri, ContentValues contentValues) {
        return 0;
    }

    @Override
    String[] queryData(Uri uri, int limit) {
        return null;
    }

    @Override
    String[] queryData(Uri uri, boolean is_instant_event, int limit) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void sendCacheData() {
        block18: {
            JSONArray idArray;
            Uri eventCache;
            Cursor cursor;
            block17: {
                cursor = null;
                eventCache = DbParams.getInstance().getEventCacheUri();
                idArray = null;
                cursor = this.contentResolver.query(eventCache, null, null, null, "created_at ASC");
                if (cursor == null || cursor.getCount() <= 0) break block17;
                idArray = new JSONArray();
                while (cursor.moveToNext()) {
                    String keyData = cursor.getString(cursor.getColumnIndexOrThrow("data"));
                    String KEY_CREATED_AT = cursor.getString(cursor.getColumnIndexOrThrow("data"));
                    ContentValues cv = new ContentValues();
                    cv.put("data", keyData);
                    cv.put("created_at", KEY_CREATED_AT);
                    this.contentResolver.insert(this.uriDataManager, cv);
                    idArray.put((Object)cursor.getString(cursor.getColumnIndexOrThrow("_id")));
                }
            }
            try {
                if (idArray != null) {
                    String whereCause = String.format("DELETE FROM %s WHERE _id in %s", "events_cache", this.buildIds(idArray));
                    this.contentResolver.delete(eventCache, whereCause, null);
                }
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
            if (cursor != null) {
                cursor.close();
            }
            break block18;
            catch (Exception exception) {
                try {
                    SALog.printStackTrace(exception);
                }
                catch (Throwable throwable) {
                    try {
                        if (idArray != null) {
                            String whereCause = String.format("DELETE FROM %s WHERE _id in %s", "events_cache", this.buildIds(idArray));
                            this.contentResolver.delete(eventCache, whereCause, null);
                        }
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable;
                }
                try {
                    if (idArray != null) {
                        String whereCause = String.format("DELETE FROM %s WHERE _id in %s", "events_cache", this.buildIds(idArray));
                        this.contentResolver.delete(eventCache, whereCause, null);
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    private String buildIds(JSONArray idArray) throws JSONException {
        StringBuilder idArgs = new StringBuilder();
        idArgs.append("(");
        if (idArray != null && idArray.length() > 0) {
            for (int index = 0; index < idArray.length(); ++index) {
                idArgs.append(idArray.get(index)).append(",");
            }
            idArgs.replace(idArgs.length() - 1, idArgs.length(), "");
        }
        idArgs.append(")");
        return idArgs.toString();
    }
}

