/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.data.OldBDatabaseHelper;
import com.sensorsdata.analytics.android.sdk.data.SensorsDataDBHelper;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.SAStoreManager;
import com.sensorsdata.analytics.android.sdk.util.AppInfoUtils;
import java.io.File;

public class SAProviderHelper {
    private static final String TAG = "SA.ProviderHelper";
    private static SAProviderHelper INSTANCE;
    private ContentResolver contentResolver;
    private SQLiteOpenHelper mDbHelper;
    private Context mContext;
    private boolean isDbWritable = true;
    private boolean mIsFlushDataState = false;
    private int startActivityCount = 0;
    private long mAppStartTime = 0L;
    private int mSessionTime = 30000;

    private SAProviderHelper(Context context) {
        try {
            this.mDbHelper = new SensorsDataDBHelper(context);
            this.mContext = context.getApplicationContext();
            this.contentResolver = context.getContentResolver();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static synchronized SAProviderHelper getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new SAProviderHelper(context);
        }
        return INSTANCE;
    }

    public void migratingDB(final Context context) {
        try {
            boolean isMigrating = AppInfoUtils.getAppInfoBundle(context).getBoolean("com.sensorsdata.analytics.android.EnableMigratingDB", true);
            if (!isMigrating) {
                SALog.i(TAG, "The migrating DB operation is false");
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String packageName = context.getPackageName();
                        File oldDatabase = context.getDatabasePath(packageName);
                        if (oldDatabase.exists()) {
                            SALog.i(SAProviderHelper.TAG, "start migratingDB");
                            OldBDatabaseHelper oldBDatabaseHelper = new OldBDatabaseHelper(context, packageName);
                            final SQLiteDatabase database = SAProviderHelper.this.getWritableDatabase();
                            if (database != null) {
                                final ContentValues cv = new ContentValues();
                                oldBDatabaseHelper.getAllEvents(database, new QueryEventsListener(){

                                    @Override
                                    public void insert(String data, String keyCreated) {
                                        cv.put("data", data);
                                        cv.put("created_at", keyCreated);
                                        database.insert("events", "_id", cv);
                                        cv.clear();
                                    }
                                });
                            }
                        }
                        if (SAProviderHelper.this.isDbWritable) {
                            context.deleteDatabase(packageName);
                        }
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            }).start();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public void appendUri(UriMatcher uriMatcher, String authority) {
        try {
            uriMatcher.addURI(authority, "events", 1);
            uriMatcher.addURI(authority, "activity_started_count", 2);
            uriMatcher.addURI(authority, "app_start_time", 3);
            uriMatcher.addURI(authority, "app_exit_data", 4);
            uriMatcher.addURI(authority, "session_interval_time", 6);
            uriMatcher.addURI(authority, "events_login_id", 7);
            uriMatcher.addURI(authority, "t_channel", 8);
            uriMatcher.addURI(authority, "sub_process_flush_data", 9);
            uriMatcher.addURI(authority, "first_process_start", 10);
            uriMatcher.addURI(authority, "disable_SDK", 11);
            uriMatcher.addURI(authority, "sensorsdata_sdk_configuration", 12);
            uriMatcher.addURI(authority, "user_ids", 13);
            uriMatcher.addURI(authority, "login_id_key", 14);
            uriMatcher.addURI(authority, "push_key", 15);
            uriMatcher.addURI(authority, "events_cache", 16);
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public Uri insertEvent(Uri uri, ContentValues values) {
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            if (database == null || !values.containsKey("data") || !values.containsKey("created_at")) {
                return uri;
            }
            long d = database.insert("events", "_id", values);
            return ContentUris.withAppendedId((Uri)uri, (long)d);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return uri;
        }
    }

    public Uri insertEventsCache(Uri uri, ContentValues values) {
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            if (database == null || !values.containsKey("data") || !values.containsKey("created_at")) {
                return uri;
            }
            long d = database.insert("events_cache", "_id", values);
            return ContentUris.withAppendedId((Uri)uri, (long)d);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return uri;
        }
    }

    public int deleteEvents(String selection, String[] selectionArgs) {
        if (!this.isDbWritable) {
            return 0;
        }
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            if (database != null) {
                return database.delete("events", selection, selectionArgs);
            }
        }
        catch (SQLiteException e) {
            this.isDbWritable = false;
            SALog.printStackTrace((Exception)((Object)e));
        }
        return 0;
    }

    public int deleteEventsCache(String selection, String[] selectionArgs) {
        if (!this.isDbWritable) {
            return 0;
        }
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            if (database != null) {
                database.execSQL(selection);
            }
        }
        catch (SQLiteException e) {
            this.isDbWritable = false;
            SALog.printStackTrace((Exception)((Object)e));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(Uri uri, ContentValues[] values) {
        int numValues;
        SQLiteDatabase database = null;
        try {
            try {
                database = this.mDbHelper.getWritableDatabase();
            }
            catch (SQLiteException e) {
                SALog.printStackTrace((Exception)((Object)e));
                int n = 0;
                if (database != null) {
                    database.endTransaction();
                }
                return n;
            }
            database.beginTransaction();
            numValues = values.length;
            for (int i = 0; i < numValues; ++i) {
                this.insertEvent(uri, values[i]);
            }
            database.setTransactionSuccessful();
        }
        finally {
            if (database != null) {
                database.endTransaction();
            }
        }
        return numValues;
    }

    public Uri insertChannelPersistent(Uri uri, ContentValues values) {
        try {
            SQLiteDatabase database = this.getWritableDatabase();
            if (database == null || !values.containsKey("event_name")) {
                return uri;
            }
            long d = database.insertWithOnConflict("t_channel", null, values, 5);
            return ContentUris.withAppendedId((Uri)uri, (long)d);
        }
        catch (Exception exception) {
            SALog.printStackTrace(exception);
            return uri;
        }
    }

    public void insertPersistent(int code, Uri uri, ContentValues values) {
        try {
            switch (code) {
                case 2: {
                    this.startActivityCount = values.getAsInteger("activity_started_count");
                    break;
                }
                case 3: {
                    this.mAppStartTime = values.getAsLong("app_start_time");
                    break;
                }
                case 4: {
                    PersistentLoader.getInstance().getAppExitDataPst().commit(values.getAsString("app_exit_data"));
                    break;
                }
                case 6: {
                    this.mSessionTime = values.getAsInteger("session_interval_time");
                    this.contentResolver.notifyChange(uri, null);
                    break;
                }
                case 7: {
                    PersistentLoader.getInstance().getLoginIdPst().commit(values.getAsString("events_login_id"));
                    this.contentResolver.notifyChange(uri, null);
                    break;
                }
                case 9: {
                    this.mIsFlushDataState = values.getAsBoolean("sub_process_flush_data");
                    break;
                }
                case 12: {
                    PersistentLoader.getInstance().getRemoteSDKConfig().commit(values.getAsString("sensorsdata_sdk_configuration"));
                    break;
                }
                case 13: {
                    PersistentLoader.getInstance().getUserIdsPst().commit(values.getAsString("user_ids"));
                    this.contentResolver.notifyChange(uri, null);
                    break;
                }
                case 14: {
                    PersistentLoader.getInstance().getLoginIdKeyPst().commit(values.getAsString("login_id_key"));
                    break;
                }
                case 15: {
                    SAStoreManager.getInstance().setString(values.getAsString("push_key"), values.getAsString("push_value"));
                    break;
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public Cursor queryByTable(String tableName, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        if (!this.isDbWritable) {
            return null;
        }
        Cursor cursor = null;
        try {
            SQLiteDatabase liteDatabase = this.getWritableDatabase();
            if (liteDatabase != null) {
                cursor = liteDatabase.query(tableName, projection, selection, selectionArgs, null, null, sortOrder);
            }
        }
        catch (SQLiteException e) {
            this.isDbWritable = false;
            SALog.printStackTrace((Exception)((Object)e));
        }
        return cursor;
    }

    public Cursor queryPersistent(int code, Uri uri) {
        try {
            String column = null;
            Object data = null;
            switch (code) {
                case 2: {
                    data = this.startActivityCount;
                    column = "activity_started_count";
                    break;
                }
                case 3: {
                    data = this.mAppStartTime;
                    column = "app_start_time";
                    break;
                }
                case 4: {
                    String exitData = (String)PersistentLoader.getInstance().getAppExitDataPst().get();
                    if (TextUtils.isEmpty((CharSequence)exitData)) {
                        exitData = (String)PersistentLoader.getInstance().getAppEndDataPst().get();
                        PersistentLoader.getInstance().getAppEndDataPst().remove();
                    }
                    data = exitData;
                    column = "app_exit_data";
                    break;
                }
                case 6: {
                    data = this.mSessionTime;
                    column = "session_interval_time";
                    break;
                }
                case 7: {
                    data = PersistentLoader.getInstance().getLoginIdPst().get();
                    column = "events_login_id";
                    break;
                }
                case 9: {
                    data = this.mIsFlushDataState ? 1 : 0;
                    column = "sub_process_flush_data";
                    break;
                }
                case 12: {
                    data = PersistentLoader.getInstance().getRemoteSDKConfig().get();
                    break;
                }
                case 13: {
                    data = PersistentLoader.getInstance().getUserIdsPst().get();
                    column = "user_ids";
                    break;
                }
                case 14: {
                    data = PersistentLoader.getInstance().getLoginIdKeyPst().get();
                    column = "login_id_key";
                    break;
                }
                case 15: {
                    data = SAStoreManager.getInstance().getString(uri.getQueryParameter("push_key"), "");
                    column = "push_key";
                    break;
                }
            }
            MatrixCursor matrixCursor = new MatrixCursor(new String[]{column});
            matrixCursor.addRow(new Object[]{data});
            return matrixCursor;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }

    private SQLiteDatabase getWritableDatabase() {
        SQLiteDatabase database = null;
        try {
            if (!this.isDBExist()) {
                this.mDbHelper.close();
                this.isDbWritable = true;
            }
            database = this.mDbHelper.getWritableDatabase();
        }
        catch (SQLiteException e) {
            SALog.printStackTrace((Exception)((Object)e));
            this.isDbWritable = false;
        }
        return database;
    }

    private boolean isDBExist() {
        return this.mContext.getDatabasePath("sensorsdata").exists();
    }

    public int removeSP(String key) {
        SAStoreManager.getInstance().remove(key);
        return 1;
    }

    public static interface URI_CODE {
        public static final int EVENTS = 1;
        public static final int ACTIVITY_START_COUNT = 2;
        public static final int APP_START_TIME = 3;
        public static final int APP_EXIT_DATA = 4;
        public static final int APP_PAUSED_TIME = 5;
        public static final int SESSION_INTERVAL_TIME = 6;
        public static final int LOGIN_ID = 7;
        public static final int CHANNEL_PERSISTENT = 8;
        public static final int FLUSH_DATA = 9;
        public static final int FIRST_PROCESS_START = 10;
        public static final int DISABLE_SDK = 11;
        public static final int REMOTE_CONFIG = 12;
        public static final int USER_IDENTITY_ID = 13;
        public static final int LOGIN_ID_KEY = 14;
        public static final int PUSH_ID_KEY = 15;
        public static final int EVENTS_CACHE = 16;
    }

    static interface QueryEventsListener {
        public void insert(String var1, String var2);
    }
}

