/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.event.imp;

import android.content.Context;
import com.sensorsdata.analytics.android.sdk.AnalyticsMessages;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.SAContextManager;
import com.sensorsdata.analytics.android.sdk.core.business.instantevent.InstantEventUtils;
import com.sensorsdata.analytics.android.sdk.core.event.EventProcessor;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.internal.beans.InternalConfigOptions;

public class SendDataImpl
implements EventProcessor.ISendData {
    private final InternalConfigOptions mInternalConfigs;
    private final Context mContext;

    public SendDataImpl(SAContextManager saContextManager) {
        this.mInternalConfigs = saContextManager.getInternalConfigs();
        this.mContext = saContextManager.getContext();
    }

    @Override
    public void sendData(InputData inputData, int code) {
        try {
            if (this.mInternalConfigs.saConfigOptions.isDataManagerServiceEnable()) {
                return;
            }
            if (InstantEventUtils.isInstantEvent(inputData)) {
                AnalyticsMessages.getInstance(this.mContext.getApplicationContext()).flushInstanceEvent();
            } else {
                AnalyticsMessages.getInstance(this.mContext.getApplicationContext()).flushEventMessage(code < 0 || code > this.mInternalConfigs.saConfigOptions.getFlushBulkSize() || this.mInternalConfigs.debugMode.isDebugMode() || inputData.getEventType() == EventType.TRACK_SIGNUP);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }
}

