/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.core.business.exposure;

import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.business.exposure.SAExposureConfig;
import com.sensorsdata.analytics.android.sdk.core.business.exposure.SAExposureListener;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import org.json.JSONObject;

public class SAExposureData {
    private SAExposureConfig exposureConfig;
    private JSONObject properties;
    private String event;
    private final String exposureIdentifier;
    private SAExposureListener exposureListener;

    public SAExposureData(String event) {
        this(event, null, null, null);
    }

    public SAExposureData(String event, JSONObject properties) {
        this(event, properties, null, null);
    }

    public SAExposureData(String event, String exposureIdentifier) {
        this(event, null, exposureIdentifier, null);
    }

    public SAExposureData(String event, JSONObject properties, String exposureIdentifier) {
        this(event, properties, exposureIdentifier, null);
    }

    public SAExposureData(String event, JSONObject properties, SAExposureConfig exposureConfig) {
        this(event, properties, null, exposureConfig);
    }

    public SAExposureData(String event, JSONObject properties, String exposureIdentifier, SAExposureConfig exposureConfig) {
        this.event = event;
        try {
            this.properties = JSONUtils.cloneJsonObject(properties);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        this.exposureIdentifier = exposureIdentifier;
        this.exposureConfig = exposureConfig;
    }

    public SAExposureConfig getExposureConfig() {
        return this.exposureConfig;
    }

    public void setExposureConfig(SAExposureConfig exposureConfig) {
        this.exposureConfig = exposureConfig;
    }

    public JSONObject getProperties() {
        return this.properties;
    }

    public void setProperties(JSONObject properties) {
        try {
            this.properties = JSONUtils.cloneJsonObject(properties);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getIdentifier() {
        return this.exposureIdentifier;
    }

    public SAExposureListener getExposureListener() {
        return this.exposureListener;
    }

    public void setExposureListener(SAExposureListener saExposureListener) {
        this.exposureListener = saExposureListener;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAExposureData that = (SAExposureData)o;
        return this.exposureConfig.equals(that.exposureConfig) && this.properties.toString().equals(that.properties.toString()) && this.event.equals(that.event) && this.exposureIdentifier.equals(that.exposureIdentifier);
    }

    public String toString() {
        return "SAExposureData{exposureConfig=" + this.exposureConfig + ", properties=" + this.properties + ", event='" + this.event + '\'' + ", exposureIdentifier='" + this.exposureIdentifier + '\'' + '}';
    }
}

