/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.net.Uri;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.View;
import android.webkit.WebView;
import com.sensorsdata.analytics.android.sdk.AbstractSensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.SAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPIEmptyImplementation;
import com.sensorsdata.analytics.android.sdk.SensorsDataDynamicSuperProperties;
import com.sensorsdata.analytics.android.sdk.SensorsDataGPSLocation;
import com.sensorsdata.analytics.android.sdk.SensorsDataScreenOrientationDetector;
import com.sensorsdata.analytics.android.sdk.SensorsDataTrackEventCallBack;
import com.sensorsdata.analytics.android.sdk.core.business.SAPropertyManager;
import com.sensorsdata.analytics.android.sdk.core.business.exposure.SAExposureData;
import com.sensorsdata.analytics.android.sdk.core.business.timer.EventTimer;
import com.sensorsdata.analytics.android.sdk.core.business.timer.EventTimerManager;
import com.sensorsdata.analytics.android.sdk.core.event.InputData;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.core.rpc.SensorsDataContentObserver;
import com.sensorsdata.analytics.android.sdk.core.tasks.TrackTaskManagerThread;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbAdapter;
import com.sensorsdata.analytics.android.sdk.data.adapter.DbParams;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentLoader;
import com.sensorsdata.analytics.android.sdk.data.persistent.PersistentSuperProperties;
import com.sensorsdata.analytics.android.sdk.deeplink.SensorsDataDeepLinkCallback;
import com.sensorsdata.analytics.android.sdk.deeplink.SensorsDataDeferredDeepLinkCallback;
import com.sensorsdata.analytics.android.sdk.internal.beans.EventType;
import com.sensorsdata.analytics.android.sdk.monitor.TrackMonitor;
import com.sensorsdata.analytics.android.sdk.plugin.property.SAPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.impl.SAPresetPropertyPlugin;
import com.sensorsdata.analytics.android.sdk.remote.BaseSensorsDataSDKRemoteManager;
import com.sensorsdata.analytics.android.sdk.useridentity.LoginIDAndKey;
import com.sensorsdata.analytics.android.sdk.util.JSONUtils;
import com.sensorsdata.analytics.android.sdk.util.SADataHelper;
import com.sensorsdata.analytics.android.sdk.util.TimeUtils;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SensorsDataAPI
extends AbstractSensorsDataAPI {
    public static final int VTRACK_SUPPORTED_MIN_API = 16;
    static final String VERSION = "6.8.8";
    static final String MIN_PLUGIN_VERSION = "3.5.2";
    public static String ANDROID_PLUGIN_VERSION = "";

    SensorsDataAPI() {
    }

    SensorsDataAPI(Context context, SAConfigOptions configOptions, DebugMode debugMode) {
        super(context, configOptions, debugMode);
    }

    public static SensorsDataAPI sharedInstance(Context context) {
        try {
            if (SensorsDataAPI.isSDKDisabled()) {
                return new SensorsDataAPIEmptyImplementation();
            }
            if (null == context) {
                return new SensorsDataAPIEmptyImplementation();
            }
            Context appContext = context.getApplicationContext();
            SensorsDataAPI instance = (SensorsDataAPI)sInstanceMap.get(appContext);
            if (null == instance) {
                SALog.i("SA.SensorsDataAPI", "The static method sharedInstance(context, serverURL, debugMode) should be called before calling sharedInstance()");
                return new SensorsDataAPIEmptyImplementation();
            }
            return instance;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return new SensorsDataAPIEmptyImplementation();
        }
    }

    public static void startWithConfigOptions(Context context, SAConfigOptions saConfigOptions) {
        try {
            if (context == null || saConfigOptions == null) {
                throw new NullPointerException("Context\u3001SAConfigOptions can not be null");
            }
            SensorsDataAPI sensorsDataAPI = SensorsDataAPI.getInstance(context, DebugMode.DEBUG_OFF, saConfigOptions);
            if (!sensorsDataAPI.mSDKConfigInit) {
                sensorsDataAPI.applySAConfigOptions();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    private static synchronized SensorsDataAPI getInstance(Context context, DebugMode debugMode, SAConfigOptions saConfigOptions) {
        if (null == context) {
            return new SensorsDataAPIEmptyImplementation();
        }
        Context appContext = context.getApplicationContext();
        SensorsDataAPI instance = (SensorsDataAPI)sInstanceMap.get(appContext);
        if (null == instance) {
            instance = new SensorsDataAPI(context, saConfigOptions, debugMode);
            sInstanceMap.put(appContext, instance);
        }
        return instance;
    }

    private static SensorsDataAPI getSDKInstance() {
        Iterator iterator;
        if (sInstanceMap.size() > 0 && (iterator = sInstanceMap.values().iterator()).hasNext()) {
            return (SensorsDataAPI)iterator.next();
        }
        return new SensorsDataAPIEmptyImplementation();
    }

    public static SensorsDataAPI sharedInstance() {
        try {
            if (SensorsDataAPI.isSDKDisabled()) {
                return new SensorsDataAPIEmptyImplementation();
            }
            return SensorsDataAPI.getSDKInstance();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return new SensorsDataAPIEmptyImplementation();
        }
    }

    public static void disableSDK() {
        SALog.i("SA.SensorsDataAPI", "call static function disableSDK");
        try {
            SensorsDataAPI sensorsDataAPI = SensorsDataAPI.getSDKInstance();
            if (sensorsDataAPI instanceof SensorsDataAPIEmptyImplementation || SensorsDataAPI.getConfigOptions() == null) {
                return;
            }
            if (!SensorsDataContentObserver.State.DISABLE_SDK.isObserverCalled) {
                sensorsDataAPI.track("$AppDataTrackingClose");
                sensorsDataAPI.flush();
            }
            sensorsDataAPI.unregisterNetworkListener(sensorsDataAPI.getSAContextManager().getContext());
            sensorsDataAPI.clearTrackTimer();
            SAModuleManager.getInstance().setModuleState(false);
            DbAdapter.getInstance().commitAppStartTime(0L);
            SensorsDataAPI.getConfigOptions().disableSDK(true);
            SALog.setDisableSDK(true);
            if (!SensorsDataContentObserver.State.DISABLE_SDK.isObserverCalled) {
                sensorsDataAPI.getSAContextManager().getContext().getContentResolver().notifyChange(DbParams.getInstance().getDisableSDKUri(), null);
            }
            SensorsDataContentObserver.State.DISABLE_SDK.isObserverCalled = false;
            SensorsDataContentObserver.State.DISABLE_SDK.isDid = true;
            SensorsDataContentObserver.State.ENABLE_SDK.isDid = false;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public static void enableSDK() {
        SALog.i("SA.SensorsDataAPI", "call static function enableSDK");
        try {
            SensorsDataAPI sensorsDataAPI = SensorsDataAPI.getSDKInstance();
            if (sensorsDataAPI instanceof SensorsDataAPIEmptyImplementation || SensorsDataAPI.getConfigOptions() == null) {
                return;
            }
            SensorsDataAPI.getConfigOptions().disableSDK(false);
            SAModuleManager.getInstance().setModuleState(true);
            try {
                SALog.setDisableSDK(false);
                sensorsDataAPI.enableLog(SALog.isLogEnabled());
                SALog.i("SA.SensorsDataAPI", "enableSDK, enable log");
                if (PersistentLoader.getInstance().getFirstDayPst().get() == null) {
                    PersistentLoader.getInstance().getFirstDayPst().commit(TimeUtils.formatTime(System.currentTimeMillis(), "yyyy-MM-dd"));
                }
                sensorsDataAPI.mSAContextManager.getRemoteManager().pullSDKConfigFromServer();
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
            }
            if (!SensorsDataContentObserver.State.ENABLE_SDK.isObserverCalled) {
                sensorsDataAPI.getSAContextManager().getContext().getContentResolver().notifyChange(DbParams.getInstance().getEnableSDKUri(), null);
            }
            SensorsDataContentObserver.State.ENABLE_SDK.isObserverCalled = false;
            SensorsDataContentObserver.State.ENABLE_SDK.isDid = true;
            SensorsDataContentObserver.State.DISABLE_SDK.isDid = false;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public JSONObject getPresetProperties() {
        JSONObject properties = new JSONObject();
        try {
            SAPropertyPlugin presetPlugin = this.mSAContextManager.getPluginManager().getPropertyPlugin(SAPresetPropertyPlugin.class.getName());
            if (presetPlugin instanceof SAPresetPropertyPlugin) {
                properties = ((SAPresetPropertyPlugin)presetPlugin).getPresetProperties();
            }
            properties.put("$is_first_day", this.getSAContextManager().isFirstDay(System.currentTimeMillis()));
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
        return properties;
    }

    @Override
    public JSONObject getIdentities() {
        try {
            JSONObject identities = this.mSAContextManager.getUserIdentityAPI().getIdentities();
            if (identities != null) {
                return new JSONObject(identities.toString());
            }
            return null;
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
            return null;
        }
    }

    @Override
    public void enableLog(boolean enable) {
        SALog.setEnableLog(enable);
    }

    @Override
    public long getMaxCacheSize() {
        return SensorsDataAPI.mSAConfigOptions.mMaxCacheSize;
    }

    @Override
    public void setMaxCacheSize(long maxCacheSize) {
        mSAConfigOptions.setMaxCacheSize(maxCacheSize);
    }

    @Override
    public void setFlushNetworkPolicy(int networkType) {
        mSAConfigOptions.setNetworkTypePolicy(networkType);
    }

    @Override
    public int getFlushInterval() {
        return SensorsDataAPI.mSAConfigOptions.mFlushInterval;
    }

    @Override
    public void setFlushInterval(int flushInterval) {
        mSAConfigOptions.setFlushInterval(flushInterval);
    }

    @Override
    public int getFlushBulkSize() {
        return SensorsDataAPI.mSAConfigOptions.mFlushBulkSize;
    }

    @Override
    public void setFlushBulkSize(int flushBulkSize) {
        if (flushBulkSize < 0) {
            SALog.i("SA.SensorsDataAPI", "The value of flushBulkSize is invalid");
        }
        mSAConfigOptions.setFlushBulkSize(flushBulkSize);
    }

    @Override
    public int getSessionIntervalTime() {
        return this.mInternalConfigs.sessionTime;
    }

    @Override
    public void setSessionIntervalTime(int sessionIntervalTime) {
        if (DbAdapter.getInstance() == null) {
            SALog.i("SA.SensorsDataAPI", "The static method sharedInstance(context, serverURL, debugMode) should be called before calling sharedInstance()");
            return;
        }
        if (sessionIntervalTime < 10000 || sessionIntervalTime > 300000) {
            SALog.i("SA.SensorsDataAPI", "SessionIntervalTime:" + sessionIntervalTime + " is invalid, session interval time is between 10s and 300s.");
            return;
        }
        if (sessionIntervalTime != this.mInternalConfigs.sessionTime) {
            this.mInternalConfigs.sessionTime = sessionIntervalTime;
            DbAdapter.getInstance().commitSessionIntervalTime(sessionIntervalTime);
        }
    }

    @Override
    public void setGPSLocation(double latitude, double longitude) {
        this.setGPSLocation(latitude, longitude, null);
    }

    @Override
    public void setGPSLocation(final double latitude, final double longitude, final String coordinate) {
        try {
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (SensorsDataAPI.this.mInternalConfigs.gpsLocation == null) {
                            SensorsDataAPI.this.mInternalConfigs.gpsLocation = new SensorsDataGPSLocation();
                        }
                        SensorsDataAPI.this.mInternalConfigs.gpsLocation.setLatitude((long)(latitude * Math.pow(10.0, 6.0)));
                        SensorsDataAPI.this.mInternalConfigs.gpsLocation.setLongitude((long)(longitude * Math.pow(10.0, 6.0)));
                        SensorsDataAPI.this.mInternalConfigs.gpsLocation.setCoordinate(SADataHelper.assertPropertyValue(coordinate));
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void clearGPSLocation() {
        try {
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    SensorsDataAPI.this.mInternalConfigs.gpsLocation = null;
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void enableTrackScreenOrientation(boolean enable) {
        try {
            if (enable) {
                if (this.mSAContextManager.getOrientationDetector() == null) {
                    this.mSAContextManager.setOrientationDetector(new SensorsDataScreenOrientationDetector(this.mInternalConfigs.context, 3));
                }
                this.mSAContextManager.getOrientationDetector().enable();
                this.mSAContextManager.getOrientationDetector().setState(true);
            } else if (this.mSAContextManager.getOrientationDetector() != null) {
                this.mSAContextManager.getOrientationDetector().disable();
                this.mSAContextManager.getOrientationDetector().setState(false);
                this.mSAContextManager.setOrientationDetector(null);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void resumeTrackScreenOrientation() {
        try {
            if (this.mSAContextManager.getOrientationDetector() != null) {
                this.mSAContextManager.getOrientationDetector().enable();
                this.mSAContextManager.getOrientationDetector().setState(true);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void stopTrackScreenOrientation() {
        try {
            if (this.mSAContextManager.getOrientationDetector() != null) {
                this.mSAContextManager.getOrientationDetector().disable();
                this.mSAContextManager.getOrientationDetector().setState(false);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public String getScreenOrientation() {
        try {
            if (this.mSAContextManager.getOrientationDetector() != null) {
                return this.mSAContextManager.getOrientationDetector().getOrientation();
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return null;
    }

    @Override
    public void setCookie(String cookie, boolean encode) {
        try {
            this.mInternalConfigs.cookie = encode ? URLEncoder.encode(cookie, "UTF-8") : cookie;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public String getCookie(boolean decode) {
        try {
            if (decode) {
                return URLDecoder.decode(this.mInternalConfigs.cookie, "UTF-8");
            }
            return this.mInternalConfigs.cookie;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }

    @Override
    public void enableAutoTrack(List<AutoTrackEventType> eventTypeList) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "enableAutoTrack", eventTypeList);
    }

    @Override
    public void disableAutoTrack(List<AutoTrackEventType> eventTypeList) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "disableAutoTrack", eventTypeList);
    }

    @Override
    public void disableAutoTrack(AutoTrackEventType autoTrackEventType) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "disableAutoTrack", new Object[]{autoTrackEventType});
    }

    @Override
    public boolean isAutoTrackEnabled() {
        try {
            if (SensorsDataAPI.isSDKDisabled()) {
                return false;
            }
            Boolean isAutoTrack = (Boolean)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "isAutoTrackEnabled", new Object[0]);
            return isAutoTrack != null && isAutoTrack != false;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return false;
        }
    }

    @Override
    public void trackFragmentAppViewScreen() {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "trackFragmentAppViewScreen", new Object[0]);
    }

    @Override
    public boolean isTrackFragmentAppViewScreenEnabled() {
        Boolean isAutoTrackFragment = (Boolean)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "isTrackFragmentAppViewScreenEnabled", new Object[0]);
        return isAutoTrackFragment != null && isAutoTrackFragment != false;
    }

    @Override
    public void showUpWebView(WebView webView, boolean isSupportJellyBean) {
        this.showUpWebView(webView, isSupportJellyBean, null);
    }

    @Override
    public void showUpWebView(WebView webView, boolean isSupportJellyBean, boolean enableVerify) {
        this.showUpWebView(webView, null, isSupportJellyBean, enableVerify);
    }

    @Override
    @Deprecated
    public void showUpWebView(WebView webView, JSONObject properties, boolean isSupportJellyBean, boolean enableVerify) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_webview", "showUpWebView", webView, properties, isSupportJellyBean, enableVerify);
    }

    @Override
    @Deprecated
    public void showUpWebView(WebView webView, boolean isSupportJellyBean, JSONObject properties) {
        this.showUpWebView(webView, properties, isSupportJellyBean, false);
    }

    @Override
    @Deprecated
    public void showUpX5WebView(Object x5WebView, JSONObject properties, boolean isSupportJellyBean, boolean enableVerify) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_webview", "showUpX5WebView", x5WebView, properties, isSupportJellyBean, enableVerify);
    }

    @Override
    public void showUpX5WebView(Object x5WebView, boolean enableVerify) {
        this.showUpX5WebView(x5WebView, null, true, enableVerify);
    }

    @Override
    public void showUpX5WebView(Object x5WebView) {
        this.showUpX5WebView(x5WebView, false);
    }

    @Override
    public void ignoreAutoTrackActivities(List<Class<?>> activitiesList) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "ignoreAutoTrackActivities", activitiesList);
    }

    @Override
    public void resumeAutoTrackActivities(List<Class<?>> activitiesList) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "resumeAutoTrackActivities", activitiesList);
    }

    @Override
    public void ignoreAutoTrackActivity(Class<?> activity) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "ignoreAutoTrackActivity", activity);
    }

    @Override
    public void resumeAutoTrackActivity(Class<?> activity) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "resumeAutoTrackActivity", activity);
    }

    @Override
    public void enableAutoTrackFragment(Class<?> fragment) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "enableAutoTrackFragment", fragment);
    }

    @Override
    public void enableAutoTrackFragments(List<Class<?>> fragmentsList) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "enableAutoTrackFragments", fragmentsList);
    }

    @Override
    public boolean isActivityAutoTrackAppViewScreenIgnored(Class<?> activity) {
        Boolean isAutoTrackActivity = (Boolean)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "isActivityAutoTrackAppViewScreenIgnored", activity);
        return isAutoTrackActivity != null && isAutoTrackActivity != false;
    }

    @Override
    public boolean isFragmentAutoTrackAppViewScreen(Class<?> fragment) {
        Boolean isAutoTrackFragment = (Boolean)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "isFragmentAutoTrackAppViewScreen", fragment);
        return isAutoTrackFragment != null && isAutoTrackFragment != false;
    }

    @Override
    public void ignoreAutoTrackFragments(List<Class<?>> fragmentList) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "ignoreAutoTrackFragments", fragmentList);
    }

    @Override
    public void ignoreAutoTrackFragment(Class<?> fragment) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "ignoreAutoTrackFragment", fragment);
    }

    @Override
    public void resumeIgnoredAutoTrackFragments(List<Class<?>> fragmentList) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "resumeIgnoredAutoTrackFragments", fragmentList);
    }

    @Override
    public void resumeIgnoredAutoTrackFragment(Class<?> fragment) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "resumeIgnoredAutoTrackFragment", fragment);
    }

    @Override
    public boolean isActivityAutoTrackAppClickIgnored(Class<?> activity) {
        Boolean isAutoTrackActivity = (Boolean)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "isActivityAutoTrackAppClickIgnored", activity);
        return isAutoTrackActivity != null && isAutoTrackActivity != false;
    }

    @Override
    public boolean isAutoTrackEventTypeIgnored(AutoTrackEventType eventType) {
        Boolean isAutoTrackEventType = (Boolean)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "isAutoTrackEventTypeIgnored", new Object[]{eventType});
        return isAutoTrackEventType != null && isAutoTrackEventType != false;
    }

    @Override
    public boolean isAutoTrackEventTypeIgnored(int autoTrackEventType) {
        Boolean isAutoTrackEventType = (Boolean)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "isAutoTrackEventTypeIgnored", autoTrackEventType);
        return isAutoTrackEventType != null && isAutoTrackEventType != false;
    }

    @Override
    public void setViewID(View view, String viewID) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "setViewID", view, viewID);
    }

    @Override
    public void setViewID(Dialog view, String viewID) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "setViewID", view, viewID);
    }

    @Override
    public void setViewID(Object alertDialog, String viewID) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "setViewID", alertDialog, viewID);
    }

    @Override
    public void setViewActivity(View view, Activity activity) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "setViewActivity", view, activity);
    }

    @Override
    public void setViewFragmentName(View view, String fragmentName) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "setViewFragmentName", view, fragmentName);
    }

    @Override
    public void ignoreView(View view) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "ignoreView", view);
    }

    @Override
    public void ignoreView(View view, boolean ignore) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "ignoreView", view, ignore);
    }

    @Override
    public void setViewProperties(View view, JSONObject properties) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "setViewProperties", view, properties);
    }

    @Override
    public List<Class<?>> getIgnoredViewTypeList() {
        try {
            return (List)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "getIgnoredViewTypeList", new Object[0]);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return null;
        }
    }

    @Override
    public void ignoreViewType(Class<?> viewType) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "ignoreViewType", viewType);
    }

    @Override
    public boolean isVisualizedAutoTrackActivity(Class<?> activity) {
        try {
            if (activity == null) {
                return false;
            }
            if (this.mVisualizedAutoTrackActivities.size() == 0) {
                return true;
            }
            if (this.mVisualizedAutoTrackActivities.contains(activity.hashCode())) {
                return true;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return false;
    }

    @Override
    public void addVisualizedAutoTrackActivity(Class<?> activity) {
        try {
            if (activity == null) {
                return;
            }
            this.mVisualizedAutoTrackActivities.add(activity.hashCode());
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void addVisualizedAutoTrackActivities(List<Class<?>> activitiesList) {
        try {
            if (activitiesList == null || activitiesList.size() == 0) {
                return;
            }
            for (Class<?> activity : activitiesList) {
                int hashCode;
                if (activity == null || this.mVisualizedAutoTrackActivities.contains(hashCode = activity.hashCode())) continue;
                this.mVisualizedAutoTrackActivities.add(hashCode);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public boolean isVisualizedAutoTrackEnabled() {
        return SensorsDataAPI.mSAConfigOptions.mVisualizedEnabled || SensorsDataAPI.mSAConfigOptions.mVisualizedPropertiesEnabled;
    }

    @Override
    public boolean isHeatMapActivity(Class<?> activity) {
        try {
            if (activity == null) {
                return false;
            }
            if (this.mHeatMapActivities.size() == 0) {
                return true;
            }
            if (this.mHeatMapActivities.contains(activity.hashCode())) {
                return true;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return false;
    }

    @Override
    public void addHeatMapActivity(Class<?> activity) {
        try {
            if (activity == null) {
                return;
            }
            this.mHeatMapActivities.add(activity.hashCode());
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void addHeatMapActivities(List<Class<?>> activitiesList) {
        try {
            if (activitiesList == null || activitiesList.size() == 0) {
                return;
            }
            for (Class<?> activity : activitiesList) {
                int hashCode;
                if (activity == null || this.mHeatMapActivities.contains(hashCode = activity.hashCode())) continue;
                this.mHeatMapActivities.add(hashCode);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public boolean isHeatMapEnabled() {
        return SensorsDataAPI.mSAConfigOptions.mHeatMapEnabled;
    }

    @Override
    public String getDistinctId() {
        try {
            return this.mSAContextManager.getUserIdentityAPI().getDistinctId();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return "";
        }
    }

    @Override
    public String getAnonymousId() {
        try {
            return this.mSAContextManager.getUserIdentityAPI().getAnonymousId();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return "";
        }
    }

    @Override
    public void resetAnonymousId() {
        try {
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    SensorsDataAPI.this.mSAContextManager.getUserIdentityAPI().resetAnonymousId();
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public String getLoginId() {
        try {
            return this.mSAContextManager.getUserIdentityAPI().getLoginId();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return "";
        }
    }

    @Override
    public void identify(final String distinctId) {
        try {
            SADataHelper.assertDistinctId(distinctId);
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        SensorsDataAPI.this.mSAContextManager.getUserIdentityAPI().identify(distinctId);
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void login(String loginId) {
        this.login(loginId, null);
    }

    @Override
    public void login(String loginId, JSONObject properties) {
        this.loginWithKey("$identity_login_id", loginId, properties);
    }

    @Override
    public void loginWithKey(String loginIDKey, String loginId) {
        this.loginWithKey(loginIDKey, loginId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loginWithKey(final String loginIDKey, final String loginId, JSONObject properties) {
        try {
            SensorsDataContentObserver.State.LOGIN.isDid = true;
            SensorsDataContentObserver.State.LOGOUT.isDid = false;
            Object object = this.mLoginIdLock;
            synchronized (object) {
                final JSONObject cloneProperties = JSONUtils.cloneJsonObject(properties);
                if (!LoginIDAndKey.isInValidLogin(loginIDKey, loginId, this.mSAContextManager.getUserIdentityAPI().getIdentitiesInstance().getLoginIDKey(), this.mSAContextManager.getUserIdentityAPI().getIdentitiesInstance().getLoginId(), this.getAnonymousId())) {
                    this.mSAContextManager.getUserIdentityAPI().updateLoginId(loginIDKey, loginId);
                }
                this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (SensorsDataAPI.this.mSAContextManager.getUserIdentityAPI().loginWithKeyBack(loginIDKey, loginId)) {
                                SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventName("$SignUp").setEventType(EventType.TRACK_SIGNUP).setProperties(cloneProperties));
                            }
                        }
                        catch (Exception e) {
                            SALog.printStackTrace(e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() {
        Object object = this.mLoginIdLock;
        synchronized (object) {
            this.mSAContextManager.getUserIdentityAPI().updateLoginId(null, null);
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        SensorsDataAPI.this.mSAContextManager.getUserIdentityAPI().logout();
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
    }

    @Override
    public void bind(final String key, final String value) {
        try {
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (SensorsDataAPI.this.mSAContextManager.getUserIdentityAPI().bindBack(key, value)) {
                            SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventName("$BindID").setEventType(EventType.TRACK_ID_BIND));
                        }
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void unbind(final String key, final String value) {
        try {
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (SensorsDataAPI.this.mSAContextManager.getUserIdentityAPI().unbindBack(key, value)) {
                            SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventName("$UnbindID").setEventType(EventType.TRACK_ID_UNBIND));
                        }
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void resetAnonymousIdentity(final String anonymousId) {
        if (this.mTrackTaskManager != null) {
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        SensorsDataAPI.this.mSAContextManager.getUserIdentityAPI().resetAnonymousIdentity(anonymousId);
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
    }

    @Override
    public void trackInstallation(String eventName, JSONObject properties, boolean disableCallback) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "trackInstallation", eventName, properties, disableCallback);
    }

    @Override
    public void trackInstallation(String eventName, JSONObject properties) {
        this.trackInstallation(eventName, properties, false);
    }

    @Override
    public void trackInstallation(String eventName) {
        this.trackInstallation(eventName, null, false);
    }

    @Override
    public void trackAppInstall(JSONObject properties, boolean disableCallback) {
        this.trackInstallation("$AppInstall", properties, disableCallback);
    }

    @Override
    public void trackAppInstall(JSONObject properties) {
        this.trackAppInstall(properties, false);
    }

    @Override
    public void trackAppInstall() {
        this.trackAppInstall(null, false);
    }

    @Override
    public void trackChannelEvent(String eventName) {
        this.trackChannelEvent(eventName, null);
    }

    @Override
    public void trackChannelEvent(String eventName, JSONObject properties) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "trackChannelEvent", eventName, properties);
    }

    @Override
    public void track(final String eventName, JSONObject properties) {
        try {
            final JSONObject cloneProperties = JSONUtils.cloneJsonObject(properties);
            JSONUtils.mergeDistinctProperty(JSONUtils.cloneJsonObject(this.getDynamicProperty()), cloneProperties);
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        JSONObject _properties = (JSONObject)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "mergeChannelEventProperties", eventName, cloneProperties);
                        if (_properties == null) {
                            _properties = cloneProperties;
                        }
                        SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventName(eventName).setEventType(EventType.TRACK).setProperties(_properties));
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void track(String eventName) {
        this.track(eventName, null);
    }

    @Override
    @Deprecated
    public void trackTimer(final String eventName, final TimeUnit timeUnit) {
        final long startTime = SystemClock.elapsedRealtime();
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    SADataHelper.assertEventName(eventName);
                    EventTimerManager.getInstance().addEventTimer(eventName, new EventTimer(timeUnit, startTime));
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void removeTimer(final String eventName) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    SADataHelper.assertEventName(eventName);
                    EventTimerManager.getInstance().removeTimer(eventName);
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public String trackTimerStart(String eventName) {
        try {
            String eventNameRegex = String.format("%s_%s_%s", eventName, UUID.randomUUID().toString().replace("-", "_"), "SATimer");
            this.trackTimer(eventNameRegex, TimeUnit.SECONDS);
            this.trackTimer(eventName, TimeUnit.SECONDS);
            return eventNameRegex;
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return "";
        }
    }

    @Override
    public void trackTimerPause(final String eventName) {
        final long startTime = SystemClock.elapsedRealtime();
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                EventTimerManager.getInstance().updateTimerState(eventName, startTime, true);
            }
        });
    }

    @Override
    public void trackTimerResume(final String eventName) {
        final long startTime = SystemClock.elapsedRealtime();
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                EventTimerManager.getInstance().updateTimerState(eventName, startTime, false);
            }
        });
    }

    @Override
    public void trackTimerEnd(final String eventName, JSONObject properties) {
        final long endTime = SystemClock.elapsedRealtime();
        try {
            final JSONObject cloneProperties = JSONUtils.cloneJsonObject(properties);
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    if (eventName != null) {
                        EventTimerManager.getInstance().updateEndTime(eventName, endTime);
                    }
                    try {
                        JSONObject _properties = (JSONObject)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "mergeChannelEventProperties", eventName, cloneProperties);
                        if (_properties == null) {
                            _properties = cloneProperties;
                        }
                        SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventName(eventName).setEventType(EventType.TRACK).setProperties(_properties));
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void trackTimerEnd(String eventName) {
        this.trackTimerEnd(eventName, null);
    }

    @Override
    public void clearTrackTimer() {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                EventTimerManager.getInstance().clearTimers();
            }
        });
    }

    @Override
    public String getLastScreenUrl() {
        return (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "getLastScreenUrl", new Object[0]);
    }

    @Override
    public void clearReferrerWhenAppEnd() {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "clearReferrerWhenAppEnd", new Object[0]);
    }

    @Override
    public void clearLastScreenUrl() {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "clearLastScreenUrl", new Object[0]);
    }

    @Override
    public JSONObject getLastScreenTrackProperties() {
        return (JSONObject)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "getLastScreenTrackProperties", new Object[0]);
    }

    @Override
    @Deprecated
    public void trackViewScreen(String url, JSONObject properties) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "trackViewScreen", url, properties);
    }

    @Override
    public void trackViewScreen(Activity activity) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "trackViewScreen", activity);
    }

    @Override
    public void trackViewScreen(Object fragment) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "trackViewScreen", fragment);
    }

    @Override
    public void trackViewAppClick(View view) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "trackViewAppClick", view);
    }

    @Override
    public void trackViewAppClick(View view, JSONObject properties) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_autotrack", "trackViewAppClick", view, properties);
    }

    @Override
    public void flush() {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    SensorsDataAPI.this.mSAContextManager.getAnalyticsMessages().flush();
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void flushSync() {
        this.flush();
    }

    @Override
    public void flushScheduled() {
        try {
            this.mSAContextManager.getAnalyticsMessages().flushScheduled();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void registerDynamicSuperProperties(SensorsDataDynamicSuperProperties dynamicSuperProperties) {
        this.mDynamicSuperPropertiesCallBack = dynamicSuperProperties;
    }

    @Override
    public void setTrackEventCallBack(SensorsDataTrackEventCallBack trackEventCallBack) {
        this.mInternalConfigs.sensorsDataTrackEventCallBack = trackEventCallBack;
    }

    @Override
    public void registerPropertyPlugin(final SAPropertyPlugin plugin) {
        if (plugin != null) {
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    SensorsDataAPI.this.mSAContextManager.getPluginManager().registerPropertyPlugin(plugin);
                }
            });
        }
    }

    @Override
    public void unregisterPropertyPlugin(final SAPropertyPlugin plugin) {
        if (plugin != null) {
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    SensorsDataAPI.this.mSAContextManager.getPluginManager().unregisterPropertyPlugin(plugin);
                }
            });
        }
    }

    @Override
    @Deprecated
    public void setDeepLinkCallback(SensorsDataDeepLinkCallback deepLinkCallback) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "setDeepLinkCallback", deepLinkCallback);
    }

    @Override
    public void setDeepLinkCompletion(SensorsDataDeferredDeepLinkCallback callback) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "setDeepLinkCompletion", callback);
    }

    @Override
    public void stopTrackThread() {
        if (this.mTrackTaskManagerThread != null && !this.mTrackTaskManagerThread.isStopped()) {
            this.mTrackTaskManagerThread.stop();
            SALog.i("SA.SensorsDataAPI", "Data collection thread has been stopped");
        }
    }

    @Override
    public void startTrackThread() {
        if (this.mTrackTaskManagerThread == null || this.mTrackTaskManagerThread.isStopped()) {
            this.mTrackTaskManagerThread = new TrackTaskManagerThread();
            new Thread(this.mTrackTaskManagerThread).start();
            SALog.i("SA.SensorsDataAPI", "Data collection thread has been started");
        }
    }

    @Override
    public void deleteAll() {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                SensorsDataAPI.this.mSAContextManager.getAnalyticsMessages().deleteAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JSONObject getSuperProperties() {
        Class<PersistentSuperProperties> clazz = PersistentSuperProperties.class;
        synchronized (PersistentSuperProperties.class) {
            try {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new JSONObject(JSONUtils.cloneJsonObject((JSONObject)PersistentLoader.getInstance().getSuperPropertiesPst().get()).toString());
            }
            catch (Exception e) {
                SALog.printStackTrace(e);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new JSONObject();
            }
        }
    }

    @Override
    public void registerSuperProperties(JSONObject superProperties) {
        try {
            final JSONObject cloneSuperProperties = JSONUtils.cloneJsonObject(superProperties);
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (cloneSuperProperties == null) {
                            return;
                        }
                        PersistentLoader.getInstance().getSuperPropertiesPst().commit(JSONUtils.mergeSuperJSONObject(cloneSuperProperties, JSONUtils.cloneJsonObject((JSONObject)PersistentLoader.getInstance().getSuperPropertiesPst().get())));
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void unregisterSuperProperty(final String superPropertyName) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONObject superProperties = JSONUtils.cloneJsonObject((JSONObject)PersistentLoader.getInstance().getSuperPropertiesPst().get());
                    superProperties.remove(superPropertyName);
                    PersistentLoader.getInstance().getSuperPropertiesPst().commit(superProperties);
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void clearSuperProperties() {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                PersistentLoader.getInstance().getSuperPropertiesPst().commit(new JSONObject());
            }
        });
    }

    @Override
    public void profileSet(JSONObject properties) {
        try {
            final JSONObject cloneProperties = JSONUtils.cloneJsonObject(properties);
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventType(EventType.PROFILE_SET).setProperties(cloneProperties));
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void profileSet(final String property, final Object value) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventType(EventType.PROFILE_SET).setProperties(new JSONObject().put(property, value)));
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void profileSetOnce(JSONObject properties) {
        try {
            final JSONObject cloneProperties = JSONUtils.cloneJsonObject(properties);
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventType(EventType.PROFILE_SET_ONCE).setProperties(cloneProperties));
                    }
                    catch (Exception e) {
                        SALog.printStackTrace(e);
                    }
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void profileSetOnce(final String property, final Object value) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventType(EventType.PROFILE_SET_ONCE).setProperties(new JSONObject().put(property, value)));
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void profileIncrement(final Map<String, ? extends Number> properties) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventType(EventType.PROFILE_INCREMENT).setProperties(new JSONObject(properties)));
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void profileIncrement(final String property, final Number value) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventType(EventType.PROFILE_INCREMENT).setProperties(new JSONObject().put(property, (Object)value)));
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void profileAppend(final String property, final String value) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONArray append_values = new JSONArray();
                    append_values.put((Object)value);
                    JSONObject properties = new JSONObject();
                    properties.put(property, (Object)append_values);
                    SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventType(EventType.PROFILE_APPEND).setProperties(properties));
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void profileAppend(final String property, final Set<String> values) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    JSONArray append_values = new JSONArray();
                    for (String value : values) {
                        append_values.put((Object)value);
                    }
                    JSONObject properties = new JSONObject();
                    properties.put(property, (Object)append_values);
                    SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventType(EventType.PROFILE_APPEND).setProperties(properties));
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void profileUnset(final String property) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventType(EventType.PROFILE_UNSET).setProperties(new JSONObject().put(property, true)));
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void profileDelete() {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setEventType(EventType.PROFILE_DELETE));
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public boolean isDebugMode() {
        return this.mInternalConfigs.debugMode.isDebugMode();
    }

    @Override
    public boolean isNetworkRequestEnable() {
        return this.mInternalConfigs.isNetworkRequestEnable;
    }

    @Override
    public void enableNetworkRequest(boolean isRequest) {
        this.mInternalConfigs.isNetworkRequestEnable = isRequest;
    }

    @Override
    public void setServerUrl(String serverUrl) {
        this.setServerUrl(serverUrl, false);
    }

    @Override
    public void setServerUrl(final String serverUrl, boolean isRequestRemoteConfig) {
        try {
            if (isRequestRemoteConfig && this.mSAContextManager.getRemoteManager() != null) {
                try {
                    this.mSAContextManager.getRemoteManager().requestRemoteConfig(BaseSensorsDataSDKRemoteManager.RandomTimeType.RandomTimeTypeWrite, false);
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
            if (!TextUtils.equals((CharSequence)serverUrl, (CharSequence)this.mOriginServerUrl)) {
                try {
                    SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "requestVisualConfig", new Object[0]);
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
            this.mOriginServerUrl = serverUrl;
            if (TextUtils.isEmpty((CharSequence)serverUrl)) {
                SensorsDataAPI.mSAConfigOptions.mServerUrl = this.mServerUrl = serverUrl;
                SALog.i("SA.SensorsDataAPI", "Server url is null or empty.");
                return;
            }
            final Uri serverURI = Uri.parse((String)serverUrl);
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    String hostServer = serverURI.getHost();
                    if (!TextUtils.isEmpty((CharSequence)hostServer) && hostServer.contains("_")) {
                        SALog.i("SA.SensorsDataAPI", "Server url " + serverUrl + " contains '_' is not recommend\uff0csee details: https://en.wikipedia.org/wiki/Hostname");
                    }
                }
            });
            if (this.mInternalConfigs.debugMode != DebugMode.DEBUG_OFF) {
                String uriPath = serverURI.getPath();
                if (TextUtils.isEmpty((CharSequence)uriPath)) {
                    return;
                }
                int pathPrefix = uriPath.lastIndexOf(47);
                if (pathPrefix != -1) {
                    String newPath = uriPath.substring(0, pathPrefix) + "/debug";
                    this.mServerUrl = serverURI.buildUpon().path(newPath).build().toString();
                }
            } else {
                this.mServerUrl = serverUrl;
            }
            SensorsDataAPI.mSAConfigOptions.mServerUrl = this.mServerUrl;
            TrackMonitor.getInstance().callSetServerUrl();
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void profilePushId(final String pushTypeKey, final String pushId) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!SADataHelper.assertPropertyKey(pushTypeKey)) {
                        return;
                    }
                    String distinctId = SensorsDataAPI.this.getDistinctId();
                    String distinctPushId = distinctId + pushId;
                    String spDistinctPushId = DbAdapter.getInstance().getPushId("distinctId_" + pushTypeKey);
                    if (!TextUtils.equals((CharSequence)spDistinctPushId, (CharSequence)distinctPushId)) {
                        SensorsDataAPI.this.profileSet(pushTypeKey, pushId);
                        DbAdapter.getInstance().commitPushID("distinctId_" + pushTypeKey, distinctPushId);
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void profileUnsetPushId(final String pushTypeKey) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!SADataHelper.assertPropertyKey(pushTypeKey)) {
                        return;
                    }
                    String distinctId = SensorsDataAPI.this.getDistinctId();
                    String key = "distinctId_" + pushTypeKey;
                    String spDistinctPushId = DbAdapter.getInstance().getPushId(key);
                    if (!TextUtils.isEmpty((CharSequence)spDistinctPushId) && spDistinctPushId.startsWith(distinctId)) {
                        SensorsDataAPI.this.profileUnset(pushTypeKey);
                        DbAdapter.getInstance().removePushId(key);
                    }
                }
                catch (Exception e) {
                    SALog.printStackTrace(e);
                }
            }
        });
    }

    @Override
    public void itemSet(final String itemType, final String itemId, JSONObject properties) {
        try {
            final JSONObject cloneProperties = JSONUtils.cloneJsonObject(properties);
            this.mTrackTaskManager.addTrackEventTask(new Runnable(){

                @Override
                public void run() {
                    SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setItemId(itemId).setItemType(itemType).setEventType(EventType.ITEM_SET).setProperties(cloneProperties));
                }
            });
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @Override
    public void itemDelete(final String itemType, final String itemId) {
        this.mTrackTaskManager.addTrackEventTask(new Runnable(){

            @Override
            public void run() {
                SensorsDataAPI.this.mSAContextManager.trackEvent(new InputData().setItemId(itemId).setItemType(itemType).setEventType(EventType.ITEM_DELETE));
            }
        });
    }

    @Override
    public void enableDeepLinkInstallSource(boolean enable) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "enableDeepLinkInstallSource", enable);
    }

    @Override
    public String getServerUrl() {
        return this.mServerUrl;
    }

    @Override
    public void trackDeepLinkLaunch(String deepLinkUrl) {
        this.trackDeepLinkLaunch(deepLinkUrl, null);
    }

    @Override
    public void trackDeepLinkLaunch(String deepLinkUrl, String oaid) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "trackDeepLinkLaunch", deepLinkUrl, oaid);
    }

    @Override
    public void requestDeferredDeepLink(JSONObject params) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_advertisement", "requestDeferredDeepLink", params);
    }

    public String getSDKVersion() {
        return VERSION;
    }

    @Override
    public void setExposureIdentifier(View view, String exposureIdentifier) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_exposure", "setExposureIdentifier", view, exposureIdentifier);
    }

    @Override
    public void addExposureView(View view, SAExposureData exposureData) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_exposure", "addExposureView", view, exposureData);
    }

    @Override
    public void removeExposureView(View view, String identifier) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_exposure", "removeExposureView", view, identifier);
    }

    @Override
    public void removeExposureView(View view) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_exposure", "removeExposureView", view);
    }

    @Override
    public void updateExposureProperties(View view, JSONObject properties) {
        SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_exposure", "updateExposureProperties", view, properties);
    }

    @Override
    public void registerLimitKeys(Map<String, String> limitKeys) {
        SAPropertyManager.getInstance().registerLimitKeys(limitKeys);
    }

    @Override
    public void enableRemoteConfig(boolean enable) {
        try {
            if (this.mSAContextManager != null) {
                this.mInternalConfigs.isRemoteConfigEnabled = enable;
                if (this.mSAContextManager.getRemoteManager() != null) {
                    this.mSAContextManager.getRemoteManager().pullSDKConfigFromServer();
                }
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public final class NetworkType {
        public static final int TYPE_NONE = 0;
        public static final int TYPE_2G = 1;
        public static final int TYPE_3G = 2;
        public static final int TYPE_4G = 4;
        public static final int TYPE_WIFI = 8;
        public static final int TYPE_5G = 16;
        public static final int TYPE_ALL = 255;
    }

    public static enum AutoTrackEventType {
        APP_START(1),
        APP_END(2),
        APP_CLICK(4),
        APP_VIEW_SCREEN(8);

        public final int eventValue;

        private AutoTrackEventType(int eventValue) {
            this.eventValue = eventValue;
        }

        public static String autoTrackEventName(int eventType) {
            switch (eventType) {
                case 1: {
                    return "$AppStart";
                }
                case 2: {
                    return "$AppEnd";
                }
                case 4: {
                    return "$AppClick";
                }
                case 8: {
                    return "$AppViewScreen";
                }
            }
            return "";
        }

        int getEventValue() {
            return this.eventValue;
        }
    }

    public static enum DebugMode {
        DEBUG_OFF(false, false),
        DEBUG_ONLY(true, false),
        DEBUG_AND_TRACK(true, true);

        private final boolean debugMode;
        private final boolean debugWriteData;

        private DebugMode(boolean debugMode, boolean debugWriteData) {
            this.debugMode = debugMode;
            this.debugWriteData = debugWriteData;
        }

        public boolean isDebugMode() {
            return this.debugMode;
        }

        boolean isDebugWriteData() {
            return this.debugWriteData;
        }
    }
}

