/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.LruCache;
import android.view.View;
import android.view.ViewParent;
import android.view.Window;
import com.sensorsdata.analytics.android.sdk.R;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.util.SAViewUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

public class SAFragmentUtils {
    @SuppressLint(value={"NewApi"})
    private static LruCache<String, WeakReference<Object>> sFragmentLruCache = new LruCache(Integer.MAX_VALUE);

    public static void setFragmentToCache(String fragmentName, Object object) {
        if (!TextUtils.isEmpty((CharSequence)fragmentName) && null != object && Build.VERSION.SDK_INT >= 12) {
            sFragmentLruCache.put((Object)fragmentName, new WeakReference<Object>(object));
        }
    }

    public static Object getFragmentFromCache(String fragmentName) {
        try {
            if (!TextUtils.isEmpty((CharSequence)fragmentName)) {
                Object object;
                WeakReference weakReference = null;
                if (Build.VERSION.SDK_INT >= 12) {
                    weakReference = (WeakReference)sFragmentLruCache.get((Object)fragmentName);
                }
                if (null != weakReference && null != (object = weakReference.get())) {
                    return object;
                }
                object = Class.forName(fragmentName).newInstance();
                if (Build.VERSION.SDK_INT >= 12) {
                    sFragmentLruCache.put((Object)fragmentName, new WeakReference(object));
                }
                return object;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return null;
    }

    public static boolean isFragmentVisible(Object fragment) {
        Object parentFragment = null;
        try {
            Method getParentFragmentMethod = fragment.getClass().getMethod("getParentFragment", new Class[0]);
            parentFragment = getParentFragmentMethod.invoke(fragment, new Object[0]);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        try {
            if (parentFragment == null ? !SAFragmentUtils.fragmentIsHidden(fragment) && SAFragmentUtils.fragmentGetUserVisibleHint(fragment) && SAFragmentUtils.fragmentIsResumed(fragment) : !SAFragmentUtils.fragmentIsHidden(fragment) && SAFragmentUtils.fragmentGetUserVisibleHint(fragment) && SAFragmentUtils.fragmentIsResumed(fragment) && !SAFragmentUtils.fragmentIsHidden(parentFragment) && SAFragmentUtils.fragmentGetUserVisibleHint(parentFragment) && SAFragmentUtils.fragmentIsResumed(parentFragment)) {
                return true;
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return false;
    }

    public static boolean fragmentGetUserVisibleHint(Object fragment) {
        try {
            Method getUserVisibleHintMethod = fragment.getClass().getMethod("getUserVisibleHint", new Class[0]);
            return (Boolean)getUserVisibleHintMethod.invoke(fragment, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean fragmentIsHidden(Object fragment) {
        try {
            Method isHiddenMethod = fragment.getClass().getMethod("isHidden", new Class[0]);
            return (Boolean)isHiddenMethod.invoke(fragment, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isFragment(Object object) {
        try {
            if (object == null) {
                return false;
            }
            Class<?> supportFragmentClass = null;
            Class<?> androidXFragmentClass = null;
            Class<?> fragment = null;
            try {
                fragment = Class.forName("android.app.Fragment");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                supportFragmentClass = Class.forName("android.support.v4.app.Fragment");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                androidXFragmentClass = Class.forName("androidx.fragment.app.Fragment");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (supportFragmentClass == null && androidXFragmentClass == null && fragment == null) {
                return false;
            }
            if (supportFragmentClass != null && supportFragmentClass.isInstance(object) || androidXFragmentClass != null && androidXFragmentClass.isInstance(object) || fragment != null && fragment.isInstance(object)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean fragmentIsResumed(Object fragment) {
        try {
            Method isResumedMethod = fragment.getClass().getMethod("isResumed", new Class[0]);
            return (Boolean)isResumedMethod.invoke(fragment, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Object getFragmentFromView(View view) {
        return SAFragmentUtils.getFragmentFromView(view, null);
    }

    public static Activity getActivityFromFragment(Object fragment) {
        Activity activity = null;
        if (Build.VERSION.SDK_INT >= 11) {
            try {
                Method getActivityMethod = fragment.getClass().getMethod("getActivity", new Class[0]);
                activity = (Activity)getActivityMethod.invoke(fragment, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return activity;
    }

    public static Object getFragmentFromView(View view, Activity activity) {
        try {
            if (view != null) {
                String fragmentName = (String)view.getTag(R.id.sensors_analytics_tag_view_fragment_name);
                String fragmentName2 = (String)view.getTag(R.id.sensors_analytics_tag_view_fragment_name2);
                if (!TextUtils.isEmpty((CharSequence)fragmentName2)) {
                    fragmentName = fragmentName2;
                }
                if (TextUtils.isEmpty((CharSequence)fragmentName)) {
                    Object tag;
                    Window window;
                    if (activity == null) {
                        Context context = view.getContext();
                        activity = SAViewUtils.getActivityOfView(context, view);
                    }
                    if (activity != null && (window = activity.getWindow()) != null && window.isActive() && (tag = window.getDecorView().getRootView().getTag(R.id.sensors_analytics_tag_view_fragment_name)) != null) {
                        fragmentName = SAFragmentUtils.traverseParentViewTag(view);
                    }
                }
                return SAFragmentUtils.getFragmentFromCache(fragmentName);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return null;
    }

    private static String traverseParentViewTag(View view) {
        try {
            ViewParent parentView = view.getParent();
            String fragmentName = null;
            while (TextUtils.isEmpty(fragmentName) && parentView instanceof View) {
                fragmentName = (String)((View)parentView).getTag(R.id.sensors_analytics_tag_view_fragment_name);
                parentView = parentView.getParent();
            }
            return fragmentName;
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return "";
        }
    }
}

