/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.util;

import android.view.View;
import android.view.ViewGroup;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.util.SnapCache;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Pathfinder {
    private static final String TAG = "SA.PathFinder";
    private final IntStack mIndexStack = new IntStack();

    public static boolean hasClassName(Object o, String className) {
        Class<?> klass = o.getClass();
        String canonicalName = SnapCache.getInstance().getCanonicalName(klass);
        while (canonicalName != null) {
            if (canonicalName.equals(className)) {
                return true;
            }
            if (klass == Object.class) break;
            klass = klass.getSuperclass();
            canonicalName = SnapCache.getInstance().getCanonicalName(klass);
        }
        return false;
    }

    public void findTargetsInRoot(View givenRootView, List<PathElement> path, Accumulator accumulator) {
        if (path.isEmpty()) {
            return;
        }
        if (this.mIndexStack.full()) {
            SALog.i(TAG, "Path is too deep, there is no memory to perfrom the finding");
            return;
        }
        PathElement rootPathElement = path.get(0);
        List<PathElement> childPath = path.subList(1, path.size());
        int indexKey = this.mIndexStack.alloc();
        View rootView = this.findPrefixedMatch(rootPathElement, givenRootView, indexKey);
        this.mIndexStack.free();
        if (null != rootView) {
            this.findTargetsInMatchedView(rootView, childPath, accumulator);
        }
    }

    private void findTargetsInMatchedView(View alreadyMatched, List<PathElement> remainingPath, Accumulator accumulator) {
        if (remainingPath.isEmpty()) {
            accumulator.accumulate(alreadyMatched);
            return;
        }
        if (this.mIndexStack.full()) {
            SALog.i(TAG, "Path is too deep, there is no memory to perfrom the finding");
            return;
        }
        if (!(alreadyMatched instanceof ViewGroup)) {
            return;
        }
        ViewGroup parent = (ViewGroup)alreadyMatched;
        PathElement matchElement = remainingPath.get(0);
        List<PathElement> nextPath = remainingPath.subList(1, remainingPath.size());
        int childCount = parent.getChildCount();
        int indexKey = this.mIndexStack.alloc();
        for (int i = 0; i < childCount; ++i) {
            View givenChild = parent.getChildAt(i);
            View child = this.findPrefixedMatch(matchElement, givenChild, indexKey);
            if (null != child) {
                this.findTargetsInMatchedView(child, nextPath, accumulator);
            }
            if (matchElement.index >= 0 && this.mIndexStack.read(indexKey) > matchElement.index) break;
        }
        this.mIndexStack.free();
    }

    private View findPrefixedMatch(PathElement findElement, View subject, int indexKey) {
        int currentIndex = this.mIndexStack.read(indexKey);
        if (this.matches(findElement, subject)) {
            this.mIndexStack.increment(indexKey);
            if (findElement.index == -1 || findElement.index == currentIndex) {
                return subject;
            }
        }
        if (findElement.prefix == 1 && subject instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)subject;
            int childCount = group.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View result;
                View child = group.getChildAt(i);
                if (null == child || null == (result = this.findPrefixedMatch(findElement, child, indexKey))) continue;
                return result;
            }
        }
        return null;
    }

    private boolean matches(PathElement matchElement, View subject) {
        if (null != matchElement.viewClassName && !Pathfinder.hasClassName(subject, matchElement.viewClassName)) {
            return false;
        }
        return -1 == matchElement.viewId || subject.getId() == matchElement.viewId;
    }

    private static class IntStack {
        private static final int MAX_INDEX_STACK_SIZE = 256;
        private final int[] mStack = new int[256];
        private int mStackSize = 0;

        public boolean full() {
            return this.mStack.length == this.mStackSize;
        }

        public int alloc() {
            int index = this.mStackSize++;
            this.mStack[index] = 0;
            return index;
        }

        public int read(int index) {
            return this.mStack[index];
        }

        public void increment(int index) {
            int n = index;
            this.mStack[n] = this.mStack[n] + 1;
        }

        public void free() {
            --this.mStackSize;
            if (this.mStackSize < 0) {
                throw new ArrayIndexOutOfBoundsException(this.mStackSize);
            }
        }
    }

    public static class PathElement {
        public static final int ZERO_LENGTH_PREFIX = 0;
        public static final int SHORTEST_PREFIX = 1;
        public final int prefix;
        public final String viewClassName;
        public final int index;
        public final int viewId;

        public PathElement(int usePrefix, String vClass, int ix, int vId) {
            this.prefix = usePrefix;
            this.viewClassName = vClass;
            this.index = ix;
            this.viewId = vId;
        }

        public String toString() {
            try {
                JSONObject ret = new JSONObject();
                if (this.prefix == 1) {
                    ret.put("prefix", (Object)"shortest");
                }
                if (null != this.viewClassName) {
                    ret.put("view_class", (Object)this.viewClassName);
                }
                if (this.index > -1) {
                    ret.put("index", this.index);
                }
                if (this.viewId > -1) {
                    ret.put("id", this.viewId);
                }
                return ret.toString();
            }
            catch (JSONException e) {
                throw new RuntimeException("Can't serialize PathElement to String", e);
            }
        }
    }

    public static interface Accumulator {
        public void accumulate(View var1);
    }
}

