/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.monitor;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.listener.SAFunctionListener;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class TrackMonitor {
    private List<SAFunctionListener> mFunctionListener;
    private JSONObject cacheData;

    private TrackMonitor() {
    }

    private void call(String function, JSONObject jsonObject) {
        if (TextUtils.isEmpty((CharSequence)function) || this.mFunctionListener == null) {
            return;
        }
        for (SAFunctionListener listener : this.mFunctionListener) {
            listener.call(function, jsonObject);
        }
    }

    public static TrackMonitor getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void addFunctionListener(SAFunctionListener functionListener) {
        try {
            JSONObject jsonObject;
            if (this.mFunctionListener == null) {
                this.mFunctionListener = new ArrayList<SAFunctionListener>();
            }
            if (functionListener != null && !this.mFunctionListener.contains(functionListener)) {
                this.mFunctionListener.add(functionListener);
            }
            if ((jsonObject = this.cacheData) != null) {
                this.call("trackEvent", jsonObject);
            }
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
        }
    }

    public void removeFunctionListener(SAFunctionListener functionListener) {
        if (this.mFunctionListener != null && functionListener != null) {
            this.mFunctionListener.remove(functionListener);
        }
    }

    public void callTrack(JSONObject eventObject) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("eventJSON", (Object)eventObject);
            if ("$AppStart".equals(eventObject.optString("event")) && this.mFunctionListener == null) {
                this.cacheData = jsonObject;
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TrackMonitor.this.cacheData = null;
                    }
                }, 2000L);
                return;
            }
            this.call("trackEvent", jsonObject);
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public void callResetAnonymousId(String newDistinctId) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("distinctId", (Object)newDistinctId);
            this.call("resetAnonymousId", jsonObject);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    public void callLogin(String loginId) {
        if (this.mFunctionListener == null) {
            return;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("distinctId", (Object)loginId);
            this.call("login", jsonObject);
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public void callLogout() {
        this.call("logout", null);
    }

    public void callIdentify(String distinctId) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("distinctId", (Object)distinctId);
            this.call("identify", jsonObject);
        }
        catch (JSONException e) {
            SALog.printStackTrace((Exception)((Object)e));
        }
    }

    public void callEnableDataCollect() {
        this.call("enableDataCollect", null);
    }

    public void callSetServerUrl() {
        this.call("setServerUrl", null);
    }

    private static class SingletonHolder {
        private static final TrackMonitor INSTANCE = new TrackMonitor();

        private SingletonHolder() {
        }
    }
}

