/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.jsbridge;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.webkit.JavascriptInterface;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.core.mediator.SAModuleManager;
import com.sensorsdata.analytics.android.sdk.internal.beans.ServerUrl;
import com.sensorsdata.analytics.android.sdk.jsbridge.H5Helper;
import com.sensorsdata.analytics.android.sdk.util.ReflectUtil;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;

public class AppWebViewInterface {
    private static final String TAG = "SA.AppWebViewInterface";
    private final Context mContext;
    private JSONObject properties;
    private final boolean enableVerify;
    private WeakReference<View> mWebView;

    public AppWebViewInterface(Context c, JSONObject p, boolean b) {
        this(c, p, b, null);
    }

    public AppWebViewInterface(Context c, JSONObject p, boolean b, View view) {
        this.mContext = c;
        this.properties = p;
        this.enableVerify = b;
        if (view != null) {
            this.mWebView = new WeakReference<View>(view);
        }
    }

    @JavascriptInterface
    public String sensorsdata_call_app() {
        try {
            SALog.i(TAG, "sensorsdata_call_app");
            if (this.properties == null) {
                this.properties = new JSONObject();
            }
            this.properties.put("type", (Object)"Android");
            String loginId = SensorsDataAPI.sharedInstance(this.mContext).getLoginId();
            if (!TextUtils.isEmpty((CharSequence)loginId)) {
                this.properties.put("distinct_id", (Object)loginId);
                this.properties.put("is_login", true);
            } else {
                this.properties.put("distinct_id", (Object)SensorsDataAPI.sharedInstance(this.mContext).getAnonymousId());
                this.properties.put("is_login", false);
            }
            return this.properties.toString();
        }
        catch (JSONException e) {
            SALog.i(TAG, e.getMessage());
            return null;
        }
    }

    @JavascriptInterface
    public void sensorsdata_track(String event) {
        try {
            SALog.i(TAG, "sensorsdata_track event = " + event);
            H5Helper.trackEventFromH5(event, this.enableVerify);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            SALog.i(TAG, "sensorsdata_track event = exception = " + event);
        }
    }

    @JavascriptInterface
    public boolean sensorsdata_verify(String event) {
        try {
            SALog.i(TAG, "sensorsdata_verify event = " + event + ", enableVerify = " + this.enableVerify);
            if (!this.enableVerify) {
                this.sensorsdata_track(event);
                return true;
            }
            return H5Helper.verifyEventFromH5(event);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            SALog.i(TAG, "sensorsdata_verify return false,exception = " + e.getMessage());
            return false;
        }
    }

    @JavascriptInterface
    public String sensorsdata_get_server_url() {
        try {
            SALog.i(TAG, "sensorsdata_get_server_url");
            return SensorsDataAPI.getConfigOptions().isAutoTrackWebView() ? SensorsDataAPI.getConfigOptions().getServerUrl() : "";
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return "";
        }
    }

    @JavascriptInterface
    public boolean sensorsdata_visual_verify(String event) {
        try {
            if (!this.enableVerify) {
                return true;
            }
            if (TextUtils.isEmpty((CharSequence)event)) {
                return false;
            }
            JSONObject eventObject = new JSONObject(event);
            String serverUrl = eventObject.optString("server_url");
            if (!TextUtils.isEmpty((CharSequence)serverUrl)) {
                return new ServerUrl(serverUrl).check(new ServerUrl(SensorsDataAPI.getConfigOptions().getServerUrl()));
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
        return false;
    }

    @JavascriptInterface
    public void sensorsdata_js_call_app(String content) {
        try {
            SALog.i(TAG, "sensorsdata_js_call_app, content = " + content);
            if (this.mWebView != null) {
                H5Helper.handleJsMessage(this.mWebView, content);
            }
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
        }
    }

    @JavascriptInterface
    public boolean sensorsdata_abtest_module() {
        try {
            SALog.i(TAG, "sensorsdata_abtest_module");
            Class<?> sensorsABTestClass = ReflectUtil.getCurrentClass(new String[]{"com.sensorsdata.abtest.SensorsABTest"});
            Object object = ReflectUtil.callStaticMethod(sensorsABTestClass, "shareInstance", new Object[0]);
            return object != null;
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return false;
        }
    }

    @JavascriptInterface
    public String sensorsdata_get_app_visual_config() {
        try {
            SALog.i(TAG, "sensorsdata_get_app_visual_config");
            return (String)SAModuleManager.getInstance().invokeModuleFunction("sensors_analytics_module_visual", "h5GetAppVisualConfig", new Object[0]);
        }
        catch (Exception e) {
            SALog.printStackTrace(e);
            return "";
        }
    }
}

