/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk.data.persistent;

import android.annotation.SuppressLint;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.SensorsDataAPI;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.SAStoreManager;

@SuppressLint(value={"CommitPrefEdits"})
public abstract class PersistentIdentity<T> {
    private static final String TAG = "SA.PersistentIdentity";
    private final PersistentSerializer serializer;
    private final String persistentKey;
    private final SAStoreManager saStoreManager;
    private T item;

    PersistentIdentity(String persistentKey, PersistentSerializer<T> serializer) {
        this.serializer = serializer;
        this.persistentKey = persistentKey;
        this.saStoreManager = SAStoreManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        if (this.item == null) {
            String data = null;
            SAStoreManager sAStoreManager = this.saStoreManager;
            synchronized (sAStoreManager) {
                data = this.saStoreManager.getString(this.persistentKey, null);
                if (data == null) {
                    this.item = this.serializer.create();
                    this.commit(this.item);
                } else {
                    this.item = this.serializer.load(data);
                }
            }
        }
        return this.item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(T item) {
        if (SensorsDataAPI.getConfigOptions().isDisableSDK()) {
            return;
        }
        this.item = item;
        SAStoreManager sAStoreManager = this.saStoreManager;
        synchronized (sAStoreManager) {
            if (this.item == null) {
                this.item = this.serializer.create();
            }
            this.saStoreManager.setString(this.persistentKey, this.serializer.save(this.item));
        }
    }

    public boolean isExists() {
        try {
            return this.saStoreManager.isExists(this.persistentKey);
        }
        catch (Exception ex) {
            SALog.printStackTrace(ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        SAStoreManager sAStoreManager = this.saStoreManager;
        synchronized (sAStoreManager) {
            this.saStoreManager.remove(this.persistentKey);
        }
    }

    static interface PersistentSerializer<T> {
        public T load(String var1);

        public String save(T var1);

        public T create();
    }
}

