/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.sdk;

import android.text.TextUtils;
import com.sensorsdata.analytics.android.sdk.AbstractSAConfigOptions;
import com.sensorsdata.analytics.android.sdk.SAAdvertisingConfig;
import com.sensorsdata.analytics.android.sdk.SALog;
import com.sensorsdata.analytics.android.sdk.core.business.exposure.SAExposureConfig;
import com.sensorsdata.analytics.android.sdk.deeplink.SensorsDataDeferredDeepLinkCallback;
import com.sensorsdata.analytics.android.sdk.encrypt.IPersistentSecretKey;
import com.sensorsdata.analytics.android.sdk.encrypt.SAEncryptListener;
import com.sensorsdata.analytics.android.sdk.plugin.encrypt.StorePlugin;
import com.sensorsdata.analytics.android.sdk.plugin.property.SAPropertyPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

public final class SAConfigOptions
extends AbstractSAConfigOptions
implements Cloneable {
    boolean mInvokeHeatMapEnabled;
    boolean mInvokeVisualizedEnabled;
    boolean mInvokeLog;

    private SAConfigOptions() {
    }

    public SAConfigOptions(String serverUrl) {
        this.mServerUrl = serverUrl;
    }

    public SAConfigOptions setRemoteConfigUrl(String remoteConfigUrl) {
        this.mRemoteConfigUrl = remoteConfigUrl;
        return this;
    }

    public SAConfigOptions setServerUrl(String serverUrl) {
        this.mServerUrl = serverUrl;
        return this;
    }

    public SAConfigOptions setAutoTrackEventType(int autoTrackEventType) {
        this.mAutoTrackEventType = autoTrackEventType;
        return this;
    }

    public SAConfigOptions enableTrackAppCrash() {
        this.mEnableTrackAppCrash = true;
        return this;
    }

    public SAConfigOptions setFlushInterval(int flushInterval) {
        this.mFlushInterval = Math.max(5000, flushInterval);
        return this;
    }

    public SAConfigOptions setFlushBulkSize(int flushBulkSize) {
        this.mFlushBulkSize = Math.max(50, flushBulkSize);
        return this;
    }

    public SAConfigOptions setMaxCacheSize(long maxCacheSize) {
        this.mMaxCacheSize = Math.max(0x1000000L, maxCacheSize);
        return this;
    }

    public SAConfigOptions setMinRequestInterval(int minRequestInterval) {
        if (minRequestInterval > 0) {
            this.mMinRequestInterval = Math.min(minRequestInterval, 168);
        }
        return this;
    }

    public SAConfigOptions setMaxRequestInterval(int maxRequestInterval) {
        if (maxRequestInterval > 0) {
            this.mMaxRequestInterval = Math.min(maxRequestInterval, 168);
        }
        return this;
    }

    public SAConfigOptions disableRandomTimeRequestRemoteConfig() {
        this.mDisableRandomTimeRequestRemoteConfig = true;
        return this;
    }

    public SAConfigOptions disableDebugAssistant() {
        this.mDisableDebugAssistant = true;
        return this;
    }

    public SAConfigOptions enableHeatMap(boolean enableHeatMap) {
        this.mHeatMapEnabled = enableHeatMap;
        this.mInvokeHeatMapEnabled = true;
        return this;
    }

    public SAConfigOptions enableVisualizedProperties(boolean enableVisualizedProperties) {
        this.mVisualizedPropertiesEnabled = enableVisualizedProperties;
        return this;
    }

    public SAConfigOptions enableVisualizedAutoTrack(boolean enableVisualizedAutoTrack) {
        this.mVisualizedEnabled = enableVisualizedAutoTrack;
        this.mInvokeVisualizedEnabled = true;
        return this;
    }

    public SAConfigOptions enableLog(boolean enableLog) {
        this.mLogEnabled = enableLog;
        this.mInvokeLog = true;
        return this;
    }

    public SAConfigOptions enableTrackScreenOrientation(boolean enableScreenOrientation) {
        this.mTrackScreenOrientationEnabled = enableScreenOrientation;
        return this;
    }

    public SAConfigOptions setNetworkTypePolicy(int networkTypePolicy) {
        this.mNetworkTypePolicy = networkTypePolicy;
        return this;
    }

    public SAConfigOptions enableSaveDeepLinkInfo(boolean enableSave) {
        this.mEnableSaveDeepLinkInfo = enableSave;
        return this;
    }

    public SAConfigOptions setSourceChannels(String ... channels) {
        this.channelSourceKeys = channels;
        return this;
    }

    public SAConfigOptions enableJavaScriptBridge(boolean isSupportJellyBean) {
        this.isAutoTrackWebView = true;
        this.isWebViewSupportJellyBean = isSupportJellyBean;
        return this;
    }

    public SAConfigOptions enableAutoAddChannelCallbackEvent(boolean isAutoAddChannelCallbackEvent) {
        this.isAutoAddChannelCallbackEvent = isAutoAddChannelCallbackEvent;
        return this;
    }

    public SAConfigOptions enableEncrypt(boolean enableEncrypt) {
        this.mEnableEncrypt = enableEncrypt;
        return this;
    }

    public SAConfigOptions enableTransportEncrypt() {
        this.mTransportEncrypt = true;
        return this;
    }

    public SAConfigOptions persistentSecretKey(IPersistentSecretKey persistentSecretKey) {
        this.mPersistentSecretKey = persistentSecretKey;
        return this;
    }

    public SAConfigOptions enableSubProcessFlushData() {
        this.isSubProcessFlushData = true;
        return this;
    }

    public SAConfigOptions setSSLSocketFactory(SSLSocketFactory SSLSocketFactory2) {
        this.mSSLSocketFactory = SSLSocketFactory2;
        return this;
    }

    public SAConfigOptions enableTrackPush(boolean enableTrackPush) {
        this.mEnableTrackPush = enableTrackPush;
        return this;
    }

    public SAConfigOptions disableSDK(boolean disableSDK) {
        this.isDisableSDK = disableSDK;
        return this;
    }

    @Deprecated
    public SAConfigOptions enableTrackPageLeave(boolean isTrackPageLeave) {
        return this.enableTrackPageLeave(isTrackPageLeave, false);
    }

    public SAConfigOptions enableTrackPageLeave(boolean isTrackPageLeave, boolean isTrackFragmentPageLeave) {
        this.mIsTrackPageLeave = isTrackPageLeave;
        this.mIsTrackFragmentPageLeave = isTrackFragmentPageLeave;
        return this;
    }

    public SAConfigOptions ignorePageLeave(List<Class<?>> ignoreList) {
        this.mIgnorePageLeave = ignoreList;
        return this;
    }

    public SAConfigOptions registerEncryptor(SAEncryptListener encryptListener) {
        if (encryptListener == null || TextUtils.isEmpty((CharSequence)encryptListener.asymmetricEncryptType()) || TextUtils.isEmpty((CharSequence)encryptListener.symmetricEncryptType())) {
            return this;
        }
        if (!this.mEncryptors.contains(encryptListener)) {
            this.mEncryptors.add(0, encryptListener);
        }
        return this;
    }

    public SAConfigOptions registerStorePlugin(StorePlugin plugin) {
        if (this.mStorePlugins == null) {
            this.mStorePlugins = new ArrayList();
        }
        this.mStorePlugins.add(plugin);
        return this;
    }

    public SAConfigOptions disableDeviceId() {
        this.mDisableDeviceId = true;
        return this;
    }

    public SAConfigOptions setCustomAdChannelUrl(String url) {
        this.mCustomADChannelUrl = url;
        return this;
    }

    public SAConfigOptions clone() {
        SAConfigOptions copyObject = this;
        try {
            copyObject = (SAConfigOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            SALog.printStackTrace(e);
        }
        return copyObject;
    }

    public SAConfigOptions enableSession(boolean enableSession) {
        this.mEnableSession = enableSession;
        return this;
    }

    public SAConfigOptions setEventSessionTimeout(int time) {
        this.mEventSessionTimeout = time;
        return this;
    }

    public SAConfigOptions registerPropertyPlugin(SAPropertyPlugin property) {
        if (this.mPropertyPlugins == null) {
            this.mPropertyPlugins = new ArrayList();
        }
        this.mPropertyPlugins.add(property);
        return this;
    }

    public SAExposureConfig getExposureConfig() {
        return this.mExposureConfig;
    }

    public SAConfigOptions setExposureConfig(SAExposureConfig exposureConfig) {
        this.mExposureConfig = exposureConfig;
        return this;
    }

    public SAConfigOptions setAnonymousId(String anonymousId) {
        this.mAnonymousId = anonymousId;
        return this;
    }

    public SAConfigOptions setDeepLinkCompletion(SensorsDataDeferredDeepLinkCallback callback) {
        this.mDeeplinkCallback = callback;
        return this;
    }

    public SAConfigOptions registerLimitKeys(Map<String, String> limitKeys) {
        this.mLimitKeys = limitKeys;
        return this;
    }

    public SAConfigOptions setInstantEvents(List<String> listInstantEvents) {
        this.mListInstantEvents = listInstantEvents;
        return this;
    }

    public SAConfigOptions setAdvertConfig(SAAdvertisingConfig config) {
        this.mSATConfig = config;
        return this;
    }

    public SAConfigOptions disableAppEndTimer() {
        this.mDisableAppEndTimer = true;
        return this;
    }
}

