/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.configs;

import com.sensorsdata.analytics.android.plugin.configs.SensorsAnalyticsSDKHookConfig;
import com.sensorsdata.analytics.android.plugin.extension.SAExtension;
import com.sensorsdata.analytics.android.plugin.extension.SASDKExtension;
import com.sensorsdata.analytics.android.plugin.visitor.SensorsAnalyticsMethodCell;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/sensorsdata/analytics/android/plugin/configs/SAConfigHookHelper;", "", "()V", "mHookMethodCells", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/sensorsdata/analytics/android/plugin/visitor/SensorsAnalyticsMethodCell;", "sClassInConfigCells", "disableIdentifierMethod", "", "classVisitor", "Lorg/objectweb/asm/ClassVisitor;", "initConfigCellInClass", "className", "", "isConfigsMethod", "", "name", "desc", "Companion", "sa-gradle-plugin"})
public final class SAConfigHookHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private CopyOnWriteArrayList<SensorsAnalyticsMethodCell> sClassInConfigCells = new CopyOnWriteArrayList();
    @NotNull
    private final CopyOnWriteArrayList<SensorsAnalyticsMethodCell> mHookMethodCells = new CopyOnWriteArrayList();
    @NotNull
    private static final HashMap<String, HashMap<String, List<SensorsAnalyticsMethodCell>>> mConfigCells = new HashMap();

    public final void initConfigCellInClass(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        this.sClassInConfigCells.clear();
        for (HashMap<String, List<SensorsAnalyticsMethodCell>> cell : mConfigCells.values()) {
            if (!cell.containsKey(className)) continue;
            List<SensorsAnalyticsMethodCell> list = cell.get(className);
            Intrinsics.checkNotNull(list);
            this.sClassInConfigCells.addAll((Collection<SensorsAnalyticsMethodCell>)list);
        }
    }

    public final boolean isConfigsMethod(@Nullable String name, @Nullable String desc) {
        for (SensorsAnalyticsMethodCell methodCell : this.sClassInConfigCells) {
            if (!Intrinsics.areEqual((Object)methodCell.getName(), (Object)name) || !Intrinsics.areEqual((Object)methodCell.getDesc(), (Object)desc)) continue;
            this.mHookMethodCells.add(methodCell);
            return true;
        }
        return false;
    }

    public final void disableIdentifierMethod(@NotNull ClassVisitor classVisitor) {
        Intrinsics.checkNotNullParameter((Object)classVisitor, (String)"classVisitor");
        for (SensorsAnalyticsMethodCell cell : this.mHookMethodCells) {
            switch (cell.getAgentName()) {
                case "createGetIMEI": {
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    SensorsAnalyticsSDKHookConfig.INSTANCE.createGetIMEI(classVisitor, cell);
                    break;
                }
                case "createGetDeviceID": {
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    SensorsAnalyticsSDKHookConfig.INSTANCE.createGetDeviceID(classVisitor, cell);
                    break;
                }
                case "createGetAndroidID": {
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    SensorsAnalyticsSDKHookConfig.INSTANCE.createGetAndroidID(classVisitor, cell);
                    break;
                }
                case "createGetMacAddress": {
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    SensorsAnalyticsSDKHookConfig.INSTANCE.createGetMacAddress(classVisitor, cell);
                    break;
                }
                case "createGetCarrier": {
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    SensorsAnalyticsSDKHookConfig.INSTANCE.createGetCarrier(classVisitor, cell);
                    break;
                }
                case "createGetOAID": {
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    SensorsAnalyticsSDKHookConfig.INSTANCE.createGetOAID(classVisitor, cell);
                    break;
                }
                case "createSALogInfo": {
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    SensorsAnalyticsSDKHookConfig.INSTANCE.createSALogInfo(classVisitor, cell);
                    break;
                }
                case "createPrintStackTrack": {
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    SensorsAnalyticsSDKHookConfig.INSTANCE.createPrintStackTrack(classVisitor, cell);
                    break;
                }
                case "createShowUpWebViewFour": {
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    SensorsAnalyticsSDKHookConfig.INSTANCE.createShowUpWebViewFour(classVisitor, cell);
                    break;
                }
                case "createShowUpX5WebViewFour": {
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    SensorsAnalyticsSDKHookConfig.INSTANCE.createShowUpX5WebViewFour(classVisitor, cell);
                    break;
                }
                case "createShowUpX5WebViewTwo": {
                    Intrinsics.checkNotNullExpressionValue((Object)cell, (String)"cell");
                    SensorsAnalyticsSDKHookConfig.INSTANCE.createShowUpX5WebViewTwo(classVisitor, cell);
                }
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR/\u0010\u0003\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/sensorsdata/analytics/android/plugin/configs/SAConfigHookHelper$Companion;", "", "()V", "mConfigCells", "Ljava/util/HashMap;", "", "", "Lcom/sensorsdata/analytics/android/plugin/visitor/SensorsAnalyticsMethodCell;", "getMConfigCells", "()Ljava/util/HashMap;", "initSDKConfigCells", "", "extension", "Lcom/sensorsdata/analytics/android/plugin/extension/SAExtension;", "sa-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HashMap<String, HashMap<String, List<SensorsAnalyticsMethodCell>>> getMConfigCells() {
            return mConfigCells;
        }

        public final void initSDKConfigCells(@NotNull SAExtension extension) {
            HashMap cells;
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            SASDKExtension sdkExtension = Objects.requireNonNull(extension).getSdk();
            this.getMConfigCells().clear();
            if (sdkExtension.getDisableAndroidID()) {
                cells = new HashMap();
                ((Map)cells).put("com/sensorsdata/analytics/android/sdk/util/SensorsDataUtils", SensorsAnalyticsSDKHookConfig.INSTANCE.disableAndroidID());
                ((Map)this.getMConfigCells()).put("disableAndroidID", cells);
            }
            if (sdkExtension.getDisableCarrier()) {
                cells = new HashMap();
                ((Map)cells).put("com/sensorsdata/analytics/android/sdk/util/SensorsDataUtils", SensorsAnalyticsSDKHookConfig.INSTANCE.disableCarrier());
                ((Map)this.getMConfigCells()).put("disableCarrier", cells);
            }
            if (sdkExtension.getDisableIMEI()) {
                cells = new HashMap();
                ((Map)cells).put("com/sensorsdata/analytics/android/sdk/util/SensorsDataUtils", SensorsAnalyticsSDKHookConfig.INSTANCE.disableIMEI());
                ((Map)this.getMConfigCells()).put("disableIMEI", cells);
            }
            if (sdkExtension.getDisableMacAddress()) {
                cells = new HashMap();
                ((Map)cells).put("com/sensorsdata/analytics/android/sdk/util/SensorsDataUtils", SensorsAnalyticsSDKHookConfig.INSTANCE.disableMacAddress());
                ((Map)this.getMConfigCells()).put("disableMacAddress", cells);
            }
            if (sdkExtension.getDisableOAID()) {
                cells = new HashMap();
                ((Map)cells).put("com/sensorsdata/analytics/android/sdk/advert/oaid/SAOaidHelper", SensorsAnalyticsSDKHookConfig.INSTANCE.disableOAID());
                ((Map)this.getMConfigCells()).put("disableOAID", cells);
            }
            if (sdkExtension.getDisableJsInterface()) {
                cells = new HashMap();
                ((Map)cells).put("com/sensorsdata/analytics/android/sdk/SensorsDataAPI", SensorsAnalyticsSDKHookConfig.INSTANCE.disableJsInterface());
                ((Map)this.getMConfigCells()).put("disableJsInterface", cells);
            }
            if (sdkExtension.getDisableLog()) {
                cells = new HashMap();
                ((Map)cells).put("com/sensorsdata/analytics/android/sdk/SALog", SensorsAnalyticsSDKHookConfig.INSTANCE.disableLog());
                ((Map)this.getMConfigCells()).put("disableLog", cells);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

