/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin;

import com.sensorsdata.analytics.android.gradle.AsmCompatFactory;
import com.sensorsdata.analytics.android.gradle.ClassInfo;
import com.sensorsdata.analytics.android.gradle.ClassInheritance;
import com.sensorsdata.analytics.android.plugin.manager.SAPluginManager;
import com.sensorsdata.analytics.android.plugin.utils.Logger;
import com.sensorsdata.analytics.android.plugin.visitor.SAPrimaryClassVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/sensorsdata/analytics/android/plugin/AsmCompatFactoryImpl;", "Lcom/sensorsdata/analytics/android/gradle/AsmCompatFactory;", "pluginManager", "Lcom/sensorsdata/analytics/android/plugin/manager/SAPluginManager;", "(Lcom/sensorsdata/analytics/android/plugin/manager/SAPluginManager;)V", "asmAPI", "", "getAsmAPI", "()I", "setAsmAPI", "(I)V", "extension", "", "getExtension", "()Ljava/lang/Object;", "isIncremental", "", "()Z", "isInit", "name", "", "getName", "()Ljava/lang/String;", "isInstrumentable", "classInfo", "Lcom/sensorsdata/analytics/android/gradle/ClassInfo;", "onBeforeTransform", "", "printPluginInfo", "transform", "Lorg/objectweb/asm/ClassVisitor;", "classVisitor", "classInheritance", "Lcom/sensorsdata/analytics/android/gradle/ClassInheritance;", "sa-gradle-plugin"})
public final class AsmCompatFactoryImpl
extends AsmCompatFactory {
    @NotNull
    private final SAPluginManager pluginManager;
    private boolean isInit;
    private int asmAPI;

    public AsmCompatFactoryImpl(@NotNull SAPluginManager pluginManager) {
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"pluginManager");
        this.pluginManager = pluginManager;
        this.asmAPI = this.pluginManager.getASMVersion();
    }

    @NotNull
    public ClassVisitor transform(@NotNull ClassVisitor classVisitor, @NotNull ClassInheritance classInheritance) {
        Intrinsics.checkNotNullParameter((Object)classVisitor, (String)"classVisitor");
        Intrinsics.checkNotNullParameter((Object)classInheritance, (String)"classInheritance");
        return new SAPrimaryClassVisitor(classVisitor, this.pluginManager, classInheritance);
    }

    public boolean isInstrumentable(@NotNull ClassInfo classInfo) {
        Intrinsics.checkNotNullParameter((Object)classInfo, (String)"classInfo");
        return this.pluginManager.getPackageManager().isInstrument(classInfo.getQualifiedName(), this.pluginManager.getExtension());
    }

    public boolean isIncremental() {
        return true;
    }

    @NotNull
    public String getName() {
        return "sensorsAnalyticsAutoTrack";
    }

    public synchronized void onBeforeTransform() {
        if (!this.isInit) {
            this.isInit = true;
            this.printPluginInfo();
        }
    }

    public int getAsmAPI() {
        return this.asmAPI;
    }

    public void setAsmAPI(int n) {
        this.asmAPI = n;
    }

    @NotNull
    public Object getExtension() {
        return this.pluginManager.getExtension();
    }

    private final void printPluginInfo() {
        Logger.INSTANCE.printCopyright();
        Logger.INSTANCE.info("plugin config detail:\nsensorsAnalytics {\n " + this.pluginManager.getExtension() + " \n}");
        Logger.INSTANCE.info("\u662f\u5426\u5728\u65b9\u6cd5\u8fdb\u5165\u65f6\u63d2\u5165\u4ee3\u7801: " + this.pluginManager.isHookOnMethodEnter());
        Logger.INSTANCE.info("\u662f\u5426\u6dfb\u52a0 TV \u652f\u6301: " + this.pluginManager.isAndroidTV());
        Logger.INSTANCE.info("ASM \u7248\u672c\u4e3a: " + this.pluginManager.getASMVersionStr$sa_gradle_plugin());
        Logger.INSTANCE.printNoLimit("");
    }
}

