/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.version;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sensorsdata.analytics.android.plugin.utils.TextUtil;
import com.sensorsdata.analytics.android.plugin.version.SensorsDataSDKVersionBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SensorsDataSDKVersionHelper {
    public static final String VERSION_KEY_SENSORDATA_VERSION_CONFIG = "SensorsDataVersionConfig";
    public static final String VERSION_KEY_CURRENT_VERSION = "SDK_VERSION";
    public static final String VERSION_KEY_DEPENDENT_SDK_VERSION = "DEPENDENT_SDK_VERSIONS";
    public static final String VERSION_KEY_PLUGIN_SDK_PATH = "com/sensorsdata/analytics/android/plugin";
    public static final String DEFAULT_MESSAGE = "\u5f53\u524d\u795e\u7b56 Android SDK \u7248\u672c %s \u8fc7\u4f4e\uff0c\u8bf7\u5347\u7ea7\u81f3 %s \u53ca\u5176\u4ee5\u4e0a\u7248\u672c\u540e\u8fdb\u884c\u4f7f\u7528";
    private Map<String, List<SensorsDataSDKVersionBean>> mDependentVersionMap = new HashMap<String, List<SensorsDataSDKVersionBean>>();
    private Map<String, String> mCurrentVersionMap = new HashMap<String, String>();

    public SensorsDataSDKVersionHelper() {
        this.mCurrentVersionMap.put(VERSION_KEY_PLUGIN_SDK_PATH, "3.5.3");
    }

    public String getMessageBySDKRelyVersion(String classname, String relatedVersion) {
        JsonArray jsonArray;
        JsonElement jsonElement;
        if (!TextUtil.isEmpty(classname) && !TextUtil.isEmpty(relatedVersion) && null != (jsonElement = new JsonParser().parse(relatedVersion)) && jsonElement.isJsonArray() && null != (jsonArray = jsonElement.getAsJsonArray()) && jsonArray.size() > 0) {
            ArrayList<SensorsDataSDKVersionBean> sensorSDKBeanList = new ArrayList<SensorsDataSDKVersionBean>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject jsonObjectSon;
                SensorsDataSDKVersionBean sensorSDKBean;
                JsonElement jsonElementSon = jsonArray.get(i);
                if (!jsonElementSon.isJsonObject() || null == (sensorSDKBean = SensorsDataSDKVersionBean.createSensorDataSDKBean(jsonObjectSon = jsonElementSon.getAsJsonObject()))) continue;
                sensorSDKBeanList.add(sensorSDKBean);
            }
            if (sensorSDKBeanList.size() > 0) {
                this.mDependentVersionMap.put(classname, sensorSDKBeanList);
            }
        }
        if (null != this.mCurrentVersionMap && this.mCurrentVersionMap.size() > 0) {
            return this.checkSensorsSDKVersionOnAnalytic();
        }
        return "";
    }

    public String getMessageBySDKCurrentVersion(String classname, String currentVersion) {
        this.mCurrentVersionMap.put(classname, currentVersion);
        return this.mDependentVersionMap.size() > 0 ? this.checkSensorsSDKVersionOnAnalytic() : "";
    }

    private String checkSensorsSDKVersionOnAnalytic() {
        for (List<SensorsDataSDKVersionBean> beanList : this.mDependentVersionMap.values()) {
            if (beanList.size() <= 0) continue;
            Iterator<SensorsDataSDKVersionBean> itList = beanList.iterator();
            while (itList.hasNext()) {
                SensorsDataSDKVersionBean sensorSDKBean = itList.next();
                if (!this.mCurrentVersionMap.containsKey(sensorSDKBean.getSensorsDataSDKPath())) continue;
                String message = sensorSDKBean.getSensorsDataSDKVersionMessage(this.mCurrentVersionMap.get(sensorSDKBean.getSensorsDataSDKPath()));
                itList.remove();
                if (TextUtil.isEmpty(message)) continue;
                return message;
            }
        }
        return "";
    }
}

