/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.android.plugin.push;

import com.sensorsdata.analytics.android.plugin.SensorsAnalyticsUtil;
import com.sensorsdata.analytics.android.plugin.push.SensorsPushInjected;
import java.util.ArrayList;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;

public class SensorsAnalyticsPushMethodVisitor
extends AdviceAdapter {
    private static final String PENDING_INTENT_OWNER = "android/app/PendingIntent";
    private final String mNameDesc;
    private final MethodVisitor mMethodVisitor;
    private final String mSuperName;

    public SensorsAnalyticsPushMethodVisitor(MethodVisitor methodVisitor, int access, String name, String descriptor, String superName) {
        super(SensorsAnalyticsUtil.ASM_VERSION, methodVisitor, access, name, descriptor);
        this.mMethodVisitor = methodVisitor;
        this.mNameDesc = name + descriptor;
        this.mSuperName = superName;
    }

    protected void onMethodEnter() {
        super.onMethodEnter();
        if (!SensorsAnalyticsUtil.isStatic(this.methodAccess)) {
            SensorsPushInjected.handlePush(this.mMethodVisitor, this.mSuperName, this.mNameDesc);
        }
    }

    public void visitCode() {
        super.visitCode();
    }

    public void visitMethodInsn(int opcodeAndSource, String owner, String name, String descriptor, boolean isInterface) {
        if (opcodeAndSource == 184 && PENDING_INTENT_OWNER.equals(owner) && this.checkPendingIntentName(name)) {
            Type[] argTypes = Type.getArgumentTypes((String)descriptor);
            ArrayList<Integer> positionList = new ArrayList<Integer>();
            for (int index = argTypes.length - 1; index >= 0; --index) {
                int position = this.newLocal(argTypes[index]);
                this.storeLocal(position, argTypes[index]);
                positionList.add(0, position);
            }
            positionList.forEach(arg_0 -> ((SensorsAnalyticsPushMethodVisitor)this).loadLocal(arg_0));
            this.mv.visitMethodInsn(184, "com/sensorsdata/analytics/android/sdk/aop/push/PushAutoTrackHelper", this.getIntentHookMethodName(argTypes.length, name), this.refactorHookBeforeMethodDescriptor(descriptor), false);
            positionList.forEach(arg_0 -> ((SensorsAnalyticsPushMethodVisitor)this).loadLocal(arg_0));
            super.visitMethodInsn(opcodeAndSource, owner, name, descriptor, isInterface);
            this.mv.visitInsn(89);
            positionList.forEach(arg_0 -> ((SensorsAnalyticsPushMethodVisitor)this).loadLocal(arg_0));
            this.mv.visitMethodInsn(184, "com/sensorsdata/analytics/android/sdk/aop/push/PushAutoTrackHelper", this.getPendingIntentHookMethodName(argTypes.length, name), this.refactorHookAfterMethodDescriptor(descriptor), false);
            return;
        }
        if (opcodeAndSource == 182 && "android/app/NotificationManager".equals(owner) && "notify".equals(name)) {
            Type[] argTypes = Type.getArgumentTypes((String)descriptor);
            ArrayList<Integer> positionList = new ArrayList<Integer>();
            for (int index = argTypes.length - 1; index >= 0; --index) {
                int position = this.newLocal(argTypes[index]);
                this.storeLocal(position, argTypes[index]);
                positionList.add(0, position);
            }
            this.mv.visitInsn(89);
            positionList.forEach(arg_0 -> ((SensorsAnalyticsPushMethodVisitor)this).loadLocal(arg_0));
            super.visitMethodInsn(opcodeAndSource, owner, name, descriptor, isInterface);
            positionList.forEach(arg_0 -> ((SensorsAnalyticsPushMethodVisitor)this).loadLocal(arg_0));
            this.mv.visitMethodInsn(184, "com/sensorsdata/analytics/android/sdk/aop/push/PushAutoTrackHelper", "onNotify", SensorsAnalyticsUtil.appendDescBeforeGiven(descriptor, "Landroid/app/NotificationManager;"), false);
            return;
        }
        super.visitMethodInsn(opcodeAndSource, owner, name, descriptor, isInterface);
    }

    private boolean checkPendingIntentName(String methodName) {
        return "getActivity".equals(methodName) || "getService".equals(methodName) || "getBroadcast".equals(methodName) || "getForegroundService".equals(methodName);
    }

    private String refactorHookBeforeMethodDescriptor(String desc) {
        return desc.substring(0, desc.lastIndexOf(")") + 1) + "V";
    }

    private String refactorHookAfterMethodDescriptor(String desc) {
        return "(Landroid/app/PendingIntent;" + desc.substring(1, desc.lastIndexOf(")") + 1) + "V";
    }

    private String getIntentHookMethodName(int argsLength, String name) {
        if ("getActivity".equals(name)) {
            return argsLength == 4 ? "hookIntentGetActivity" : "hookIntentGetActivityBundle";
        }
        return String.format("hookIntent%s", SensorsAnalyticsPushMethodVisitor.firstLetterUpper(name));
    }

    private String getPendingIntentHookMethodName(int argsLength, String name) {
        if ("getActivity".equals(name)) {
            return argsLength == 4 ? "hookPendingIntentGetActivity" : "hookPendingIntentGetActivityBundle";
        }
        return String.format("hookPendingIntent%s", SensorsAnalyticsPushMethodVisitor.firstLetterUpper(name));
    }

    private static String firstLetterUpper(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }
}

