/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.scanner;

import android.content.SharedPreferences;
import android.os.Message;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.RunLoop;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.internal.transport.interfaces.TransportHistoryCallback;
import com.sensorberg.sdk.model.persistence.ActionConversion;
import com.sensorberg.sdk.model.persistence.BeaconAction;
import com.sensorberg.sdk.model.persistence.BeaconScan;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.ResolverListener;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.ScannerListener;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BeaconActionHistoryPublisher
implements ScannerListener,
RunLoop.MessageHandlerCallback {
    private static final String SUPRESSION_TIME_STORE_SHARED_PREFS_TAG = "com.sensorberg.sdk.SupressionTimeStore";
    private static final int MSG_PUBLISH_HISTORY = 1;
    private static final int MSG_DELETE_ALL_DATA = 6;
    private static final int MSG_SAVE_SUPPRESSION_STORE = 7;
    static final int MAX_UPLOAD_SIZE = 2000;
    static final long MAX_SUPPRESSION_AGE = 604800000L;
    private Clock clock;
    private final RunLoop runloop;
    private final Transport transport;
    private ResolverListener resolverListener = ResolverListener.NONE;
    private final SharedPreferences sharedPreferences;
    private final Gson gson;
    private final Object lock = new Object();
    private List<BeaconScan> beaconScans = new LinkedList<BeaconScan>();
    private List<BeaconAction> beaconActions = new LinkedList<BeaconAction>();
    private Map<String, ActionConversion> actionConversions = new HashMap<String, ActionConversion>();
    private HashMap<String, Long> suppressionTimeStore = new HashMap();

    public BeaconActionHistoryPublisher(Transport transport, Clock clock, HandlerManager handlerManager, SharedPreferences sharedPrefs, Gson gson) {
        this.transport = transport;
        this.clock = clock;
        this.runloop = handlerManager.getBeaconPublisherRunLoop(this);
        this.sharedPreferences = sharedPrefs;
        this.gson = gson;
        this.loadAllData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onScanEventDetected(ScanEvent scanEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.beaconScans.add(BeaconScan.from(scanEvent));
        }
        this.saveAllData();
    }

    @Override
    public void handleMessage(Message queueEvent) {
        switch (queueEvent.what) {
            case 1: {
                this.publishHistorySynchronously();
                break;
            }
            case 6: {
                this.deleteAllData();
                break;
            }
            case 7: {
                this.saveSuppressionTimeStore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishHistorySynchronously() {
        List<ActionConversion> notSentConversionsValues;
        List<String> notSentConversionsKeys;
        List<BeaconAction> notSentActions;
        List<BeaconScan> notSentScans;
        Object object = this.lock;
        synchronized (object) {
            notSentScans = BeaconActionHistoryPublisher.getList(this.beaconScans);
            notSentActions = BeaconActionHistoryPublisher.getList(this.beaconActions);
            notSentConversionsKeys = BeaconActionHistoryPublisher.getList(this.actionConversions.keySet());
            notSentConversionsValues = BeaconActionHistoryPublisher.getList(this.actionConversions.values());
        }
        if (notSentScans.isEmpty() && notSentActions.isEmpty() && notSentConversionsKeys.isEmpty()) {
            Logger.log.logBeaconHistoryPublisherState("nothing to report");
            return;
        }
        Logger.log.logBeaconHistoryPublisherState("reporting " + notSentScans.size() + " scans and " + notSentActions.size() + " actions and " + notSentConversionsKeys.size() + " conversions");
        TransportHistoryCallback transportHistoryCallback = new TransportHistoryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(List<BeaconScan> scanObjectList, List<BeaconAction> actionList, List<ActionConversion> conversions) {
                Object object = BeaconActionHistoryPublisher.this.lock;
                synchronized (object) {
                    BeaconActionHistoryPublisher.this.beaconActions.removeAll(notSentActions);
                    BeaconActionHistoryPublisher.this.beaconScans.removeAll(notSentScans);
                    BeaconActionHistoryPublisher.this.actionConversions.keySet().removeAll(notSentConversionsKeys);
                }
                Logger.log.logBeaconHistoryPublisherState("published " + notSentActions.size() + " campaignStats and " + notSentScans.size() + " beaconStats and " + notSentConversionsKeys.size() + " actionConversions successfully.");
                BeaconActionHistoryPublisher.this.saveAllData();
            }

            @Override
            public void onFailure(Exception throwable) {
                Logger.log.logError("not able to publish history", throwable);
            }

            @Override
            public void onInstantActions(List<BeaconEvent> instantActions) {
                BeaconActionHistoryPublisher.this.resolverListener.onResolutionsFinished(instantActions);
            }
        };
        this.transport.publishHistory(notSentScans, notSentActions, notSentConversionsValues, transportHistoryCallback);
    }

    private static <T> List<T> getList(Collection<T> collection) {
        if (collection.size() > 2000) {
            if (collection instanceof List) {
                return new LinkedList(((List)collection).subList(0, 2000));
            }
            return new LinkedList(new LinkedList<T>(collection).subList(0, 2000));
        }
        return new LinkedList<T>(collection);
    }

    public void publishHistory() {
        this.runloop.add(this.runloop.obtainMessage(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActionPresented(BeaconEvent beaconEvent) {
        Object object = this.lock;
        synchronized (object) {
            this.beaconActions.add(BeaconAction.from(beaconEvent));
        }
        this.saveAllData();
        if (beaconEvent.isReportImmediately()) {
            this.publishHistory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConversionUpdate(ActionConversion incoming) {
        Object object = this.lock;
        synchronized (object) {
            ActionConversion existing = this.actionConversions.get(incoming.getActionInstanceUuid());
            if (existing != null && incoming.getType() <= existing.getType()) {
                Logger.log.verbose("Conversion " + existing.getActionInstanceUuid() + " type change rejected. Type can be changed only to higher. Existing type: " + existing.getType() + " Incoming type: " + incoming.getType());
                return;
            }
            this.actionConversions.put(incoming.getActionInstanceUuid(), incoming);
        }
        this.saveAllData();
    }

    public void deleteAllObjects() {
        this.runloop.sendMessage(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean actionShouldBeSuppressed(long lastAllowedPresentationTime, UUID actionUUID) {
        boolean value;
        Long lastPresentation;
        Object object = this.lock;
        synchronized (object) {
            lastPresentation = this.suppressionTimeStore.get(actionUUID.toString());
        }
        boolean bl = value = lastPresentation != null && lastPresentation >= lastAllowedPresentationTime;
        if (!value) {
            Object object2 = this.lock;
            synchronized (object2) {
                this.suppressionTimeStore.put(actionUUID.toString(), this.clock.now());
            }
            this.saveAllData();
            this.runloop.add(this.runloop.obtainMessage(7));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean actionWasShownBefore(UUID actionUUID) {
        boolean value;
        Object object = this.lock;
        synchronized (object) {
            value = this.suppressionTimeStore.containsKey(actionUUID.toString());
        }
        if (!value) {
            object = this.lock;
            synchronized (object) {
                this.suppressionTimeStore.put(actionUUID.toString(), this.clock.now());
            }
            this.saveAllData();
            this.runloop.add(this.runloop.obtainMessage(7));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllData() {
        Object object = this.lock;
        synchronized (object) {
            String conversionJson;
            String scanJson;
            String actionJson = this.sharedPreferences.getString("com.sensorberg.sdk.InternalBeaconActions", "");
            if (!actionJson.isEmpty()) {
                Type listType = new TypeToken<List<BeaconAction>>(){}.getType();
                this.beaconActions = (List)this.gson.fromJson(actionJson, listType);
            }
            if (!(scanJson = this.sharedPreferences.getString("com.sensorberg.sdk.BeaconScan", "")).isEmpty()) {
                Type listType = new TypeToken<List<BeaconScan>>(){}.getType();
                this.beaconScans = (List)this.gson.fromJson(scanJson, listType);
            }
            if (!(conversionJson = this.sharedPreferences.getString("com.sensorberg.sdk.InternalActionConversion", "")).isEmpty()) {
                Type mapType = new TypeToken<HashMap<String, ActionConversion>>(){}.getType();
                this.actionConversions = (Map)this.gson.fromJson(conversionJson, mapType);
            }
            Logger.log.logBeaconHistoryPublisherState("loaded " + this.beaconActions.size() + " campaignStats and " + this.beaconScans.size() + " beaconStats " + this.actionConversions.size() + " actionConversions from shared preferences");
            String supressionTimeStoreString = this.sharedPreferences.getString(SUPRESSION_TIME_STORE_SHARED_PREFS_TAG, "");
            if (!supressionTimeStoreString.isEmpty()) {
                Type hashMapType = new TypeToken<HashMap<String, Long>>(){}.getType();
                this.suppressionTimeStore = (HashMap)this.gson.fromJson(supressionTimeStoreString, hashMapType);
                Iterator<Map.Entry<String, Long>> iterator = this.suppressionTimeStore.entrySet().iterator();
                long old = this.clock.now() - 604800000L;
                while (iterator.hasNext()) {
                    Map.Entry<String, Long> entry = iterator.next();
                    if (entry.getValue() > old) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllData() {
        String supressionTimeStoreJson;
        String conversionJson;
        String scansJson;
        String actionsJson;
        Object object = this.lock;
        synchronized (object) {
            actionsJson = this.gson.toJson(this.beaconActions);
            scansJson = this.gson.toJson(this.beaconScans);
            conversionJson = this.gson.toJson(this.actionConversions);
            supressionTimeStoreJson = this.gson.toJson(this.suppressionTimeStore);
        }
        if (Logger.isVerboseLoggingEnabled()) {
            try {
                Logger.log.logBeaconHistoryPublisherState("size of the stats campaignStats:" + actionsJson.getBytes("UTF-8").length + " beaconStats:" + scansJson.getBytes("UTF-8").length + " conversionStats:" + conversionJson.getBytes("UTF-8").length);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putString("com.sensorberg.sdk.InternalBeaconActions", actionsJson).putString("com.sensorberg.sdk.BeaconScan", scansJson).putString("com.sensorberg.sdk.InternalActionConversion", conversionJson).putString(SUPRESSION_TIME_STORE_SHARED_PREFS_TAG, supressionTimeStoreJson).apply();
        Logger.log.logBeaconHistoryPublisherState("saved " + this.beaconActions.size() + " campaignStats and " + this.beaconScans.size() + " beaconStats and " + this.actionConversions.size() + " actionConversions and " + this.suppressionTimeStore.size() + " supression related items to shared preferences");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSuppressionTimeStore() {
        String supressionTimeStoreJson;
        Object object = this.lock;
        synchronized (object) {
            supressionTimeStoreJson = this.gson.toJson(this.suppressionTimeStore);
        }
        this.sharedPreferences.edit().putString(SUPRESSION_TIME_STORE_SHARED_PREFS_TAG, supressionTimeStoreJson).apply();
    }

    private void deleteSavedFromSharedPreferences(String key) {
        if (this.sharedPreferences.contains(key)) {
            this.sharedPreferences.edit().remove(key).apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllData() {
        Logger.log.logBeaconHistoryPublisherState("will purge the saved data of " + this.beaconActions.size() + " campaignStats and " + this.beaconScans.size() + " beaconStats and " + this.actionConversions.size() + "actionConversions");
        Object object = this.lock;
        synchronized (object) {
            this.beaconActions = new LinkedList<BeaconAction>();
            this.beaconScans = new LinkedList<BeaconScan>();
            this.actionConversions = new HashMap<String, ActionConversion>();
            this.suppressionTimeStore = new HashMap();
        }
        this.deleteSavedFromSharedPreferences(SUPRESSION_TIME_STORE_SHARED_PREFS_TAG);
        this.deleteSavedFromSharedPreferences("com.sensorberg.sdk.BeaconScan");
        this.deleteSavedFromSharedPreferences("com.sensorberg.sdk.InternalBeaconActions");
        this.deleteSavedFromSharedPreferences("com.sensorberg.sdk.InternalActionConversion");
    }

    public void setResolverListener(ResolverListener resolverListener) {
        this.resolverListener = resolverListener;
    }
}

