/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.SensorbergService;
import com.sensorberg.sdk.internal.PermissionChecker;
import javax.inject.Inject;

public class PermissionBroadcastReceiver
extends BroadcastReceiver {
    @Inject
    PermissionChecker permissionChecker;

    public void onReceive(Context context, Intent intent) {
        if (SensorbergSdk.blocked()) {
            return;
        }
        String action = intent.getAction();
        if (action.equals("com.sensorberg.android.sdk.intent.permissionState")) {
            int flagType = intent.getExtras().getInt("type");
            switch (flagType) {
                case 107: {
                    this.shouldDisplayPermission(context, false);
                    break;
                }
                case 106: {
                    this.shouldDisplayPermission(context, true);
                }
            }
        }
    }

    private void shouldDisplayPermission(Context context, boolean toShow) {
        Intent service = new Intent(context, SensorbergService.class);
        service.putExtra("com.sensorberg.android.sdk.intent.generic.type", 13);
        service.putExtra("com.sensorberg.android.sdk.intent.permissionState", toShow);
        context.startService(service);
    }
}

