/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.receivers;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.SensorbergService;
import com.sensorberg.sdk.receivers.SensorbergBroadcastReceiver;

public class GenericBroadcastReceiver
extends SensorbergBroadcastReceiver {
    public static void setManifestReceiverEnabled(boolean enabled, Context context) {
        SensorbergBroadcastReceiver.setManifestReceiverEnabled(enabled, context, GenericBroadcastReceiver.class);
    }

    public void onReceive(Context context, Intent intent) {
        if (SensorbergSdk.blocked()) {
            return;
        }
        Intent service = new Intent(context, SensorbergService.class);
        service.putExtras(intent.getExtras());
        try {
            context.startService(service);
        }
        catch (RuntimeException e) {
            Logger.log.logError("System bug throwing error.", e);
        }
    }

    private String toString(Intent intent) {
        StringBuilder builder = new StringBuilder("action:" + intent.getAction());
        Bundle extras = intent.getExtras();
        for (String key : extras.keySet()) {
            Object value = extras.get(key);
            builder.append("\nextra key:\"").append(key).append("\" value:\"").append(value).append("\" of type: ").append(value.getClass().getName());
        }
        return builder.toString();
    }
}

