/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.os.Build;
import com.sensorberg.bluetooth.CrashCallBackWrapper;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.PermissionChecker;
import com.sensorberg.sdk.internal.interfaces.BluetoothPlatform;

public class AndroidBluetoothPlatform
implements BluetoothPlatform {
    private final CrashCallBackWrapper crashCallBackWrapper;
    private BluetoothAdapter bluetoothAdapter;
    private final Context context;
    private boolean leScanRunning = false;
    private PermissionChecker permissionChecker;

    public AndroidBluetoothPlatform(Context ctx) {
        this.context = ctx;
        this.permissionChecker = new PermissionChecker(ctx);
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.crashCallBackWrapper = Build.VERSION.SDK_INT >= 18 ? new CrashCallBackWrapper(ctx) : null;
    }

    @Override
    public boolean isBluetoothLowEnergyDeviceTurnedOn() {
        return this.isBluetoothLowEnergySupported() && this.bluetoothAdapter.isEnabled();
    }

    @Override
    public boolean isBluetoothLowEnergySupported() {
        return this.bluetoothAdapter != null && this.crashCallBackWrapper != null && Build.VERSION.SDK_INT >= 18 && this.context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    @Override
    @TargetApi(value=18)
    public void startLeScan(BluetoothAdapter.LeScanCallback scanCallback) {
        if (this.isBluetoothLowEnergySupported() && this.crashCallBackWrapper != null && this.bluetoothAdapter.getState() == 12 && this.permissionChecker.hasScanPermissionCheckAndroid6()) {
            try {
                this.bluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)this.crashCallBackWrapper);
                this.crashCallBackWrapper.setCallback(scanCallback);
                this.leScanRunning = true;
            }
            catch (IllegalStateException e) {
                Logger.log.logError("System bug throwing error.", e);
                this.leScanRunning = false;
                this.crashCallBackWrapper.setCallback(null);
            }
        }
    }

    @Override
    @TargetApi(value=18)
    public void stopLeScan() {
        if (this.isBluetoothLowEnergySupported() && this.crashCallBackWrapper != null) {
            try {
                this.bluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)this.crashCallBackWrapper);
            }
            catch (Exception sentBySysteminternally) {
                Logger.log.logError("System bug throwing a NullPointerException internally.", sentBySysteminternally);
            }
            finally {
                this.leScanRunning = false;
                this.crashCallBackWrapper.setCallback(null);
            }
        }
    }

    @Override
    public boolean isLeScanRunning() {
        return this.leScanRunning;
    }
}

