/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.sensorberg.sdk.location.GeofenceData;
import com.sensorberg.utils.Objects;
import com.sensorberg.utils.UUIDUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;

public class BeaconId
implements Parcelable,
Serializable {
    public static final String INTENT_KEY = "com.sensorberg.sdk.BeaconId";
    private static final long serialVersionUID = 1L;
    public static final Parcelable.Creator<BeaconId> CREATOR = new Parcelable.Creator<BeaconId>(){

        public BeaconId createFromParcel(Parcel in) {
            return new BeaconId(in);
        }

        public BeaconId[] newArray(int size) {
            return new BeaconId[size];
        }
    };
    private final byte[] beaconId;
    private final GeofenceData geofenceData;
    private transient UUID uuid = null;

    public BeaconId(byte[] beaconId) {
        if (beaconId == null || beaconId.length != 20) {
            throw new IllegalArgumentException("Illegal beacon id");
        }
        this.beaconId = new byte[20];
        System.arraycopy(beaconId, 0, this.beaconId, 0, 20);
        this.geofenceData = null;
    }

    public BeaconId(byte[] data, int offset) {
        if (data == null || data.length < offset + 20) {
            throw new IllegalArgumentException("Illegal beacon id");
        }
        this.beaconId = new byte[20];
        System.arraycopy(data, offset, this.beaconId, 0, 20);
        this.geofenceData = null;
    }

    protected BeaconId(Parcel source) {
        this.beaconId = new byte[20];
        source.readByteArray(this.beaconId);
        this.geofenceData = (GeofenceData)source.readParcelable(GeofenceData.class.getClassLoader());
    }

    public BeaconId(String beaconId) {
        if (beaconId.length() != 40) {
            throw new IllegalArgumentException("Invalid beacon id");
        }
        this.beaconId = BeaconId.hexToByteArray(beaconId);
        this.geofenceData = null;
    }

    public BeaconId(String beaconId, GeofenceData geofenceData) {
        if (beaconId.length() != 40) {
            throw new IllegalArgumentException("Invalid beacon id");
        }
        this.beaconId = BeaconId.hexToByteArray(beaconId);
        this.geofenceData = geofenceData;
    }

    private static byte[] hexToByteArray(String hex) throws IllegalArgumentException {
        int length = hex.length();
        byte[] data = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            int digitHigh = Character.digit(hex.charAt(i), 16);
            int digitLow = Character.digit(hex.charAt(i + 1), 16);
            if (digitHigh == -1 || digitLow == -1) {
                throw new IllegalArgumentException("Invalid beacon id");
            }
            data[i / 2] = (byte)((digitHigh << 4) + digitLow);
        }
        return data;
    }

    public BeaconId(UUID uuid, int majorId, int minorId) {
        this.uuid = uuid;
        ByteArrayOutputStream stream = new ByteArrayOutputStream(20);
        DataOutputStream streamOuter = new DataOutputStream(stream);
        try {
            streamOuter.writeLong(uuid.getMostSignificantBits());
            streamOuter.writeLong(uuid.getLeastSignificantBits());
            streamOuter.writeShort(majorId);
            streamOuter.writeShort(minorId);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.beaconId = stream.toByteArray();
        this.geofenceData = null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel destination, int flags) {
        destination.writeByteArray(this.beaconId);
        destination.writeParcelable((Parcelable)this.geofenceData, flags);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        BeaconId otherId = (BeaconId)other;
        return Arrays.equals(this.beaconId, otherId.beaconId) && Objects.equals(this.geofenceData, otherId.geofenceData);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.beaconId);
        if (this.geofenceData != null) {
            result = 31 * result + this.geofenceData.hashCode();
        }
        return result;
    }

    public byte[] getBeaconId() {
        byte[] beaconIdCopy = new byte[20];
        System.arraycopy(this.beaconId, 0, beaconIdCopy, 0, 20);
        return beaconIdCopy;
    }

    public GeofenceData getGeofenceData() {
        return this.geofenceData;
    }

    public String toTraditionalString() {
        return String.format(Locale.US, "%s:%d:%d", this.getUuid(), this.getMajorId(), this.getMinorId());
    }

    public int getMajorId() {
        return this.beaconId[17] & 0xFF | (this.beaconId[16] & 0xFF) << 8;
    }

    public int getMinorId() {
        return this.beaconId[19] & 0xFF | (this.beaconId[18] & 0xFF) << 8;
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            byte[] uuidHigh = new byte[8];
            byte[] uuidLow = new byte[8];
            System.arraycopy(this.beaconId, 0, uuidHigh, 0, 8);
            System.arraycopy(this.beaconId, 8, uuidLow, 0, 8);
            this.uuid = new UUID(BeaconId.toLong(uuidHigh), BeaconId.toLong(uuidLow));
        }
        return this.uuid;
    }

    private static long toLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes, 0, bytes.length);
        buffer.flip();
        return buffer.getLong();
    }

    public String getNormalizedUUIDString() {
        return UUIDUtils.uuidWithoutDashesString(this.getUuid());
    }

    public String getPid() {
        return String.format("%1s%2$05d%3$05d", this.getProximityUUIDWithoutDashes(), this.getMajorId(), this.getMinorId());
    }

    public String toString() {
        return "BeaconId{uuid=" + this.getNormalizedUUIDString() + ", major=" + this.getMajorId() + ", minor=" + this.getMinorId() + ", geofence=" + this.getGeofenceData() + '}';
    }

    public String getProximityUUIDWithoutDashes() {
        return UUIDUtils.uuidWithoutDashesString(this.getUuid());
    }
}

