/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.model.persistence;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.utils.Objects;

public class BeaconAction {
    public static final String SHARED_PREFS_TAG = "com.sensorberg.sdk.InternalBeaconActions";
    @Expose
    @SerializedName(value="eid")
    private String actionId;
    @Expose
    @SerializedName(value="dt")
    private long timeOfPresentation;
    @Expose
    @SerializedName(value="trigger")
    private int trigger;
    @Expose
    @SerializedName(value="pid")
    private String pid;
    @Expose
    @SerializedName(value="location")
    private String geohash;
    @Expose
    @SerializedName(value="uuid")
    private String actionInstanceUuid;

    public static BeaconAction from(BeaconEvent beaconEvent) {
        BeaconAction value = new BeaconAction();
        value.setActionId(beaconEvent.getAction().getUuid().toString());
        value.setTimeOfPresentation(beaconEvent.getPresentationTime());
        value.setTrigger(beaconEvent.getTrigger());
        value.setGeohash(beaconEvent.getGeohash());
        value.setActionInstanceUuid(beaconEvent.getAction().getInstanceUuid());
        if (beaconEvent.getBeaconId() != null) {
            if (beaconEvent.getBeaconId().getGeofenceData() == null) {
                value.setPid(beaconEvent.getBeaconId().getPid());
            } else {
                value.setPid(beaconEvent.getBeaconId().getGeofenceData().getFence());
            }
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeaconAction that = (BeaconAction)o;
        if (this.timeOfPresentation != that.timeOfPresentation) {
            return false;
        }
        if (this.trigger != that.trigger) {
            return false;
        }
        if (!this.actionId.equals(that.actionId)) {
            return false;
        }
        if (!this.actionInstanceUuid.equals(that.actionInstanceUuid)) {
            return false;
        }
        if (!Objects.equals(this.geohash, that.geohash)) {
            return false;
        }
        return !(this.pid == null ? that.pid != null : !this.pid.equals(that.pid));
    }

    public int hashCode() {
        int result = this.actionId.hashCode();
        result = 31 * result + (int)(this.timeOfPresentation ^ this.timeOfPresentation >>> 32);
        result = 31 * result + this.actionInstanceUuid.hashCode();
        result = 31 * result + this.trigger;
        result = 31 * result + (this.pid != null ? this.pid.hashCode() : 0);
        result = 31 * result + (this.geohash != null ? this.geohash.hashCode() : 0);
        return result;
    }

    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public long getTimeOfPresentation() {
        return this.timeOfPresentation;
    }

    public void setTimeOfPresentation(long timeOfPresentation) {
        this.timeOfPresentation = timeOfPresentation;
    }

    public int getTrigger() {
        return this.trigger;
    }

    public void setTrigger(int trigger) {
        this.trigger = trigger;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getGeohash() {
        return this.geohash;
    }

    public void setGeohash(String geohash) {
        this.geohash = geohash;
    }

    public String getActionInstanceUuid() {
        return this.actionInstanceUuid;
    }

    public void setActionInstanceUuid(String actionInstanceUuid) {
        this.actionInstanceUuid = actionInstanceUuid;
    }
}

