/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.SyncStatusObserver;
import android.location.Location;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.MinimalBootstrapper;
import com.sensorberg.sdk.SensorbergService;
import com.sensorberg.sdk.action.Action;
import com.sensorberg.sdk.action.ActionType;
import com.sensorberg.sdk.internal.PermissionChecker;
import com.sensorberg.sdk.internal.interfaces.BluetoothPlatform;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.FileManager;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.MessageDelayWindowLengthListener;
import com.sensorberg.sdk.internal.interfaces.ServiceScheduler;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.location.GeofenceData;
import com.sensorberg.sdk.location.GeofenceListener;
import com.sensorberg.sdk.location.GeofenceManager;
import com.sensorberg.sdk.location.LocationHelper;
import com.sensorberg.sdk.model.BeaconId;
import com.sensorberg.sdk.model.persistence.ActionConversion;
import com.sensorberg.sdk.presenter.LocalBroadcastManager;
import com.sensorberg.sdk.receivers.GenericBroadcastReceiver;
import com.sensorberg.sdk.receivers.NetworkInfoBroadcastReceiver;
import com.sensorberg.sdk.receivers.ScannerBroadcastReceiver;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.Resolver;
import com.sensorberg.sdk.resolver.ResolverConfiguration;
import com.sensorberg.sdk.resolver.ResolverListener;
import com.sensorberg.sdk.scanner.BeaconActionHistoryPublisher;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.Scanner;
import com.sensorberg.sdk.scanner.ScannerListener;
import com.sensorberg.sdk.settings.SettingsManager;
import com.sensorberg.sdk.settings.SettingsUpdateCallback;
import com.sensorberg.utils.ListUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;

public class InternalApplicationBootstrapper
extends MinimalBootstrapper
implements ScannerListener,
SyncStatusObserver,
Transport.ProximityUUIDUpdateHandler,
GeofenceListener {
    private static final boolean SURVIVE_REBOOT = true;
    protected final Transport transport;
    protected final Resolver resolver;
    protected Scanner scanner;
    @Inject
    @Named(value="realSettingsManager")
    protected SettingsManager settingsManager;
    @Inject
    @Named(value="realBeaconActionHistoryPublisher")
    protected BeaconActionHistoryPublisher beaconActionHistoryPublisher;
    protected final Object proximityUUIDsMonitor = new Object();
    protected SensorbergService.MessengerList presentationDelegate;
    protected final Set<String> proximityUUIDs = new HashSet<String>();
    protected SortedMap<String, String> attributes;
    @Inject
    protected Context context;
    protected Clock clock;
    @Inject
    protected FileManager fileManager;
    @Inject
    protected PermissionChecker permissionChecker;
    @Inject
    protected LocationHelper locationHelper;
    protected BluetoothPlatform bluetoothPlatform;
    @Inject
    protected SharedPreferences preferences;
    @Inject
    @Nullable
    protected GeofenceManager geofenceManager;
    @Inject
    protected Gson gson;
    protected final boolean geofenceAvailable;
    public ListUtils.Filter<BeaconEvent> beaconEventFilter = new ListUtils.Filter<BeaconEvent>(){

        @Override
        public boolean matches(BeaconEvent beaconEvent) {
            long lastAllowedPresentationTime;
            if (beaconEvent.getSuppressionTimeMillis() > 0L && InternalApplicationBootstrapper.this.beaconActionHistoryPublisher.actionShouldBeSuppressed(lastAllowedPresentationTime = InternalApplicationBootstrapper.this.clock.now() - beaconEvent.getSuppressionTimeMillis(), beaconEvent.getAction().getUuid())) {
                return false;
            }
            return !beaconEvent.isSendOnlyOnce() || !InternalApplicationBootstrapper.this.beaconActionHistoryPublisher.actionWasShownBefore(beaconEvent.getAction().getUuid());
        }
    };
    private ResolverListener resolverListener = new ResolverListener(){

        @Override
        public void onResolutionFailed(Throwable cause, ScanEvent scanEvent) {
            Logger.log.logError("resolution failed:" + scanEvent.getBeaconId().toTraditionalString(), cause);
        }

        @Override
        public void onResolutionsFinished(List<BeaconEvent> beaconEvents) {
            List<BeaconEvent> events = ListUtils.filter(beaconEvents, InternalApplicationBootstrapper.this.beaconEventFilter);
            for (BeaconEvent event : events) {
                InternalApplicationBootstrapper.this.presentBeaconEvent(event);
            }
        }
    };
    private SettingsUpdateCallback settingsUpdateCallbackListener = new SettingsUpdateCallback(){

        @Override
        public void onSettingsUpdateIntervalChange(Long updateIntervalMillies) {
            InternalApplicationBootstrapper.this.serviceScheduler.cancelIntent(102);
            InternalApplicationBootstrapper.this.serviceScheduler.scheduleRepeating(102, updateIntervalMillies, TimeUnit.MILLISECONDS);
        }

        @Override
        public void onSettingsBeaconLayoutUpdateIntervalChange(long newLayoutUpdateInterval) {
            InternalApplicationBootstrapper.this.serviceScheduler.cancelIntent(11);
            InternalApplicationBootstrapper.this.serviceScheduler.scheduleRepeating(11, newLayoutUpdateInterval, TimeUnit.MILLISECONDS);
        }

        @Override
        public void onHistoryUploadIntervalChange(long newHistoryUploadInterval) {
            InternalApplicationBootstrapper.this.serviceScheduler.cancelIntent(10);
            InternalApplicationBootstrapper.this.serviceScheduler.scheduleRepeating(10, newHistoryUploadInterval, TimeUnit.MILLISECONDS);
        }
    };

    public InternalApplicationBootstrapper(Transport transport, ServiceScheduler scheduler, HandlerManager handlerManager, Clock clk, BluetoothPlatform btPlatform, ResolverConfiguration resolverConfiguration) {
        super(scheduler);
        SensorbergSdk.getComponent().inject(this);
        this.geofenceAvailable = this.geofenceManager != null;
        this.transport = transport;
        transport.setProximityUUIDUpdateHandler(this);
        if (this.geofenceAvailable) {
            this.geofenceManager.addListener(this);
        }
        this.settingsManager.setSettingsUpdateCallback(this.settingsUpdateCallbackListener);
        this.settingsManager.setMessageDelayWindowLengthListener((MessageDelayWindowLengthListener)((Object)scheduler));
        this.clock = clk;
        this.bluetoothPlatform = btPlatform;
        this.attributes = this.loadAttributes();
        this.beaconActionHistoryPublisher.setResolverListener(this.resolverListener);
        this.scanner = new Scanner(this.settingsManager, this.settingsManager.isShouldRestoreBeaconStates(), this.clock, this.fileManager, scheduler, handlerManager, btPlatform);
        this.resolver = new Resolver(resolverConfiguration, handlerManager, transport, this.attributes);
        this.resolver.setListener(this.resolverListener);
        this.scanner.addScannerListener(this);
        this.serviceScheduler.restorePendingIntents();
        ScannerBroadcastReceiver.setManifestReceiverEnabled(true, this.context);
        GenericBroadcastReceiver.setManifestReceiverEnabled(true, this.context);
        this.setUpAlarmsForSettings();
        this.setUpAlarmForBeaconActionHistoryPublisher();
        this.updateAlarmsForActionLayoutFetch();
        NetworkInfoBroadcastReceiver.triggerListenerWithCurrentState(this.context);
        ContentResolver.addStatusChangeListener((int)1, (SyncStatusObserver)this);
    }

    private void setUpAlarmForBeaconActionHistoryPublisher() {
        this.serviceScheduler.scheduleRepeating(10, this.settingsManager.getHistoryUploadInterval(), TimeUnit.MILLISECONDS);
    }

    private void setUpAlarmsForSettings() {
        this.serviceScheduler.scheduleRepeating(102, this.settingsManager.getSettingsUpdateInterval(), TimeUnit.MILLISECONDS);
    }

    private void updateAlarmsForActionLayoutFetch() {
        if (this.isSyncEnabled()) {
            this.serviceScheduler.scheduleRepeating(11, this.settingsManager.getLayoutUpdateInterval(), TimeUnit.MILLISECONDS);
        } else {
            this.serviceScheduler.cancelIntent(11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onScanEventDetected(ScanEvent scanEvent) {
        boolean contained;
        int reportLevel = this.settingsManager.getBeaconReportLevel();
        if (reportLevel == 0) {
            this.beaconActionHistoryPublisher.onScanEventDetected(scanEvent);
        }
        Object object = this.proximityUUIDsMonitor;
        synchronized (object) {
            contained = scanEvent.getBeaconId().getGeofenceData() == null ? this.proximityUUIDs.isEmpty() || this.proximityUUIDs.contains(scanEvent.getBeaconId().getProximityUUIDWithoutDashes()) : true;
        }
        if (contained) {
            if (reportLevel == 1) {
                this.beaconActionHistoryPublisher.onScanEventDetected(scanEvent);
            }
            this.resolver.resolve(scanEvent);
        }
    }

    @Override
    public void onGeofenceEvent(GeofenceData geofenceData, boolean entry, String pairingId) {
        BeaconId beaconId = new BeaconId("0000000000000000000000000000000000000000", geofenceData);
        ScanEvent scanEvent = new ScanEvent(beaconId, this.clock.now(), entry, "00:00:00:00:00:00", -127, 0, this.locationHelper.getGeohash(), pairingId);
        this.onScanEventDetected(scanEvent);
    }

    @Override
    public void onLocationChanged(Location location) {
    }

    public void onConversionUpdate(ActionConversion conversion) {
        conversion.setGeohash(this.locationHelper.getGeohash());
        this.beaconActionHistoryPublisher.onConversionUpdate(conversion);
    }

    public void setAttributes(HashMap<String, String> incoming) {
        this.attributes = new TreeMap<String, String>();
        this.attributes.putAll(incoming);
        this.resolver.setAttributes(this.attributes);
        this.saveAttributes(this.attributes);
    }

    private void saveAttributes(Map<String, String> attributes) {
        String attrs = this.gson.toJson(attributes);
        Logger.log.logAttributes("Saved " + attributes.size() + " attributes");
        this.preferences.edit().putString("com.sensorberg.preferences.data.targeting", attrs).apply();
    }

    private SortedMap<String, String> loadAttributes() {
        SortedMap<String, String> map;
        String attrsJson = this.preferences.getString("com.sensorberg.preferences.data.targeting", "");
        if (!attrsJson.isEmpty()) {
            Type mapType = new TypeToken<TreeMap<String, String>>(){}.getType();
            map = Collections.synchronizedSortedMap((TreeMap)this.gson.fromJson(attrsJson, mapType));
        } else {
            map = Collections.synchronizedSortedMap(new TreeMap());
        }
        Logger.log.logAttributes("Read " + map.size() + " attributes");
        return map;
    }

    public void presentBeaconEvent(BeaconEvent beaconEvent) {
        if (beaconEvent != null && beaconEvent.getAction() != null) {
            Action beaconEventAction = beaconEvent.getAction();
            if (beaconEvent.getDeliverAt() != null) {
                this.serviceScheduler.postDeliverAtOrUpdate(beaconEvent.getDeliverAt(), beaconEvent);
            } else if (beaconEventAction.getDelayTime() > 0L) {
                this.serviceScheduler.postToServiceDelayed(beaconEventAction.getDelayTime(), 1001, beaconEvent, true);
                Logger.log.beaconResolveState(beaconEvent, "delaying the display of this BeaconEvent");
            } else {
                this.presentEventDirectly(beaconEvent);
            }
        }
    }

    private void presentEventDirectly(BeaconEvent beaconEvent) {
        if (beaconEvent.getAction() != null) {
            beaconEvent.setPresentationTime(this.clock.now());
            this.beaconActionHistoryPublisher.onActionPresented(beaconEvent);
            if (beaconEvent.getAction().getType() == ActionType.SILENT) {
                Logger.log.beaconResolveState(beaconEvent, "Silent campaign handled, no callback to host application");
                return;
            }
            ActionConversion conversion = new ActionConversion(beaconEvent.getAction().getUuid(), -1);
            this.onConversionUpdate(conversion);
            if (this.presentationDelegate == null) {
                Intent broadcastIntent = new Intent("com.sensorberg.android.PRESENT_ACTION");
                broadcastIntent.putExtra("com.sensorberg.sdk.Action", (Parcelable)beaconEvent.getAction());
                broadcastIntent.putExtra("com.sensorberg.sdk.BeaconId", (Parcelable)beaconEvent.getBeaconId());
                LocalBroadcastManager.getInstance(this.context).sendBroadcast(broadcastIntent);
            } else {
                Logger.log.beaconResolveState(beaconEvent, "delegating the display of the beacon event to the application");
                this.presentationDelegate.send(beaconEvent);
            }
        }
    }

    public void presentEventDirectly(BeaconEvent beaconEvent, int index) {
        this.serviceScheduler.removeStoredPendingIntent(index);
        if (beaconEvent != null) {
            this.presentEventDirectly(beaconEvent);
        }
    }

    public void sentPresentationDelegationTo(SensorbergService.MessengerList messengerList) {
        this.presentationDelegate = messengerList;
    }

    public void startScanning() {
        if (this.bluetoothPlatform.isBluetoothLowEnergySupported() && this.bluetoothPlatform.isBluetoothLowEnergyDeviceTurnedOn()) {
            if (!this.permissionChecker.hasScanPermissionCheckAndroid6()) {
                Logger.log.logError("User needs to be shown runtime dialogue asking for coarse location services");
            } else {
                this.scanner.start();
            }
        }
    }

    @Override
    public void stopScanning() {
        this.scanner.stop();
    }

    public void startGeofences() {
        if (this.geofenceAvailable) {
            this.geofenceManager.ping();
        }
    }

    public void saveAllDataBeforeDestroy() {
        this.beaconActionHistoryPublisher.saveAllData();
    }

    public void hostApplicationInForeground() {
        this.scanner.hostApplicationInForeground();
        this.updateSettings();
        this.transport.updateBeaconLayout(this.attributes);
        this.beaconActionHistoryPublisher.publishHistory();
    }

    public void hostApplicationInBackground() {
        this.scanner.hostApplicationInBackground();
        this.beaconActionHistoryPublisher.publishHistory();
    }

    public void setApiToken(String apiToken) {
        if (this.resolver.configuration.setApiToken(apiToken)) {
            Logger.log.applicationStateChanged("New token received. Restarting everything");
            this.scanner.stop();
            this.unscheduleAllPendingActions();
            this.beaconActionHistoryPublisher.deleteAllObjects();
            if (this.geofenceAvailable) {
                this.geofenceManager.clear();
            }
            this.transport.setApiToken(apiToken);
            this.updateSettings();
            this.updateBeaconLayout();
            this.scanner.clearCache();
            this.scanner.start();
        }
    }

    public void updateSettings() {
        this.settingsManager.updateSettingsFromNetwork();
    }

    public void uploadHistory() {
        if (NetworkInfoBroadcastReceiver.latestNetworkInfo != null) {
            this.beaconActionHistoryPublisher.publishHistory();
        } else {
            Logger.log.logError("Did not try to upload the history because it seems we\u00b4e offline.");
        }
    }

    boolean isSyncEnabled() {
        if (this.permissionChecker.hasReadSyncSettingsPermissions()) {
            return ContentResolver.getMasterSyncAutomatically();
        }
        return true;
    }

    public void updateBeaconLayout() {
        if (this.isSyncEnabled()) {
            this.transport.updateBeaconLayout(this.attributes);
        }
    }

    public void onStatusChanged(int which) {
        this.updateAlarmsForActionLayoutFetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proximityUUIDListUpdated(List<String> proximityUUIDs, boolean changed) {
        Object object = this.proximityUUIDsMonitor;
        synchronized (object) {
            boolean doFences;
            this.proximityUUIDs.clear();
            ArrayList<String> fences = null;
            boolean bl = doFences = this.geofenceAvailable && (changed || this.geofenceManager.shouldForceUpdate());
            if (doFences) {
                fences = new ArrayList<String>();
            }
            for (String proximityUUID : proximityUUIDs) {
                if (proximityUUID.length() == 32) {
                    this.proximityUUIDs.add(proximityUUID.toLowerCase());
                    continue;
                }
                if (proximityUUID.length() == 14) {
                    if (!doFences) continue;
                    fences.add(proximityUUID.toLowerCase());
                    continue;
                }
                Logger.log.logError("Invalid proximityUUID: " + proximityUUID);
            }
            if (doFences) {
                try {
                    this.geofenceManager.onFencesChanged(fences);
                }
                catch (IllegalArgumentException ex) {
                    Logger.log.logError(ex.getMessage(), ex);
                }
            }
        }
    }
}

