/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.settings;

import android.content.SharedPreferences;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.sensorberg.sdk.settings.SettingsUpdateCallback;

public class Settings {
    @Expose
    @SerializedName(value="network.beaconLayoutUpdateInterval")
    private long layoutUpdateInterval = 86400000L;
    @Expose
    @SerializedName(value="presenter.messageDelayWindowLength")
    private long messageDelayWindowLength = 10000L;
    @Expose
    @SerializedName(value="scanner.exitTimeoutMillis")
    private long exitTimeoutMillis = 9000L;
    @Expose
    @SerializedName(value="scanner.foreGroundScanTime")
    private long foreGroundScanTime = 10000L;
    @Expose
    @SerializedName(value="scanner.foreGroundWaitTime")
    private long foreGroundWaitTime = 10000L;
    @Expose
    @SerializedName(value="scanner.backgroundScanTime")
    private long backgroundScanTime = 20000L;
    @Expose
    @SerializedName(value="scanner.backgroundWaitTime")
    private long backgroundWaitTime = 120000L;
    @Expose
    @SerializedName(value="location.geohashMaxAge")
    private long geohashMaxAge = 60000L;
    @Expose
    @SerializedName(value="location.geohashMinAccuracyRadius")
    private int geohashMinAccuracyRadius = 25;
    @Expose
    @SerializedName(value="network.millisBetweenRetries")
    private long millisBetweenRetries = 5000L;
    @Expose
    @SerializedName(value="network.maximumResolveRetries")
    private int maxRetries = 3;
    @Expose
    @SerializedName(value="network.historyUploadInterval")
    private long historyUploadInterval = 1800000L;
    @Expose
    @SerializedName(value="scanner.cleanBeaconMapRestartTimeout")
    private long cleanBeaconMapRestartTimeout = 60000L;
    @Expose
    @SerializedName(value="settings.updateTime")
    private long settingsUpdateInterval = 86400000L;
    @Expose
    @SerializedName(value="scanner.restoreBeaconStates")
    private boolean shouldRestoreBeaconStates = true;
    @Expose
    @SerializedName(value="scanner.minimumAcceptableRssi")
    private int scannerMinRssi = Integer.MIN_VALUE;
    @Expose
    @SerializedName(value="scanner.maximumAcceptableDistanceMeters")
    private int scannerMaxDistance = Integer.MAX_VALUE;
    @Expose
    @SerializedName(value="network.beaconReportLevel")
    private int beaconReportLevel = 0;
    public static final int BEACON_REPORT_LEVEL_ALL = 0;
    public static final int BEACON_REPORT_LEVEL_ONLY_CONTAINED = 1;
    public static final int BEACON_REPORT_LEVEL_NONE = 2;
    private Long revision = null;

    public Settings() {
    }

    public Settings(SharedPreferences preferences) {
        if (preferences != null) {
            this.exitTimeoutMillis = preferences.getLong("com.sensorberg.preferences.scanner.exitTimeoutMillis", 9000L);
            this.foreGroundScanTime = preferences.getLong("com.sensorberg.preferences.scanner.foreGroundScanTime", 10000L);
            this.foreGroundWaitTime = preferences.getLong("com.sensorberg.preferences.scanner.foreGroundWaitTime", 10000L);
            this.backgroundScanTime = preferences.getLong("com.sensorberg.preferences.scanner.backgroundScanTime", 20000L);
            this.backgroundWaitTime = preferences.getLong("com.sensorberg.preferences.scanner.backgroundWaitTime", 120000L);
            this.geohashMaxAge = preferences.getLong("com.sensorberg.preferences.location.geohashMaxAge", 60000L);
            this.geohashMinAccuracyRadius = preferences.getInt("com.sensorberg.preferences.location.geohashMinAccuracyRadius", 25);
            this.cleanBeaconMapRestartTimeout = preferences.getLong("com.sensorberg.preferences.scanner.cleanBeaconMapRestartTimeout", 60000L);
            this.revision = preferences.getLong("com.sensorberg.preferences.settings.revision", Long.MIN_VALUE);
            this.settingsUpdateInterval = preferences.getLong("com.sensorberg.preferences.settings.updateInterval", 86400000L);
            this.maxRetries = preferences.getInt("com.sensorberg.preferences.settings.maxResolveRetries", 3);
            this.millisBetweenRetries = preferences.getLong("com.sensorberg.preferences.settings.timeBetweenResolveRetries", 5000L);
            this.historyUploadInterval = preferences.getLong("com.sensorberg.preferences.settings.timeBetweenHistoryUploads", 1800000L);
            this.layoutUpdateInterval = preferences.getLong("com.sensorberg.preferences.settings.timeBetweenBeaconLayoutUpdates", 1800000L);
            this.shouldRestoreBeaconStates = preferences.getBoolean("com.sensorberg.preferences.settings.restoreBeaconStates", true);
            this.beaconReportLevel = preferences.getInt("com.sensorberg.preferences.network.beaconReportLevel", 0);
            this.scannerMinRssi = preferences.getInt("com.sensorberg.preferences.settings.scannerMinRssi", Integer.MIN_VALUE);
            this.scannerMaxDistance = preferences.getInt("com.sensorberg.preferences.settings.scannerMaxDistance", Integer.MAX_VALUE);
        }
    }

    public Settings(long rev, Settings newSettings, SettingsUpdateCallback settingsUpdateCallback) {
        this.exitTimeoutMillis = newSettings.getExitTimeoutMillis();
        this.foreGroundScanTime = newSettings.getForeGroundScanTime();
        this.foreGroundWaitTime = newSettings.getForeGroundWaitTime();
        this.backgroundScanTime = newSettings.getBackgroundScanTime();
        this.backgroundWaitTime = newSettings.getBackgroundWaitTime();
        this.geohashMaxAge = newSettings.getGeohashMaxAge();
        this.geohashMinAccuracyRadius = newSettings.getGeohashMinAccuracyRadius();
        this.cleanBeaconMapRestartTimeout = newSettings.getCleanBeaconMapRestartTimeout();
        this.messageDelayWindowLength = newSettings.getMessageDelayWindowLength();
        this.maxRetries = newSettings.getMaxRetries();
        this.millisBetweenRetries = newSettings.getMillisBetweenRetries();
        this.shouldRestoreBeaconStates = newSettings.isShouldRestoreBeaconStates();
        this.beaconReportLevel = newSettings.getBeaconReportLevel();
        this.scannerMinRssi = newSettings.getScannerMinRssi();
        this.scannerMaxDistance = newSettings.getScannerMaxDistance();
        this.revision = rev >= 0L ? Long.valueOf(rev) : null;
        if (newSettings.getHistoryUploadInterval() != this.historyUploadInterval) {
            this.historyUploadInterval = newSettings.getHistoryUploadInterval();
            settingsUpdateCallback.onHistoryUploadIntervalChange(this.historyUploadInterval);
        }
        if (newSettings.getLayoutUpdateInterval() != this.layoutUpdateInterval) {
            this.layoutUpdateInterval = newSettings.getLayoutUpdateInterval();
            settingsUpdateCallback.onSettingsBeaconLayoutUpdateIntervalChange(this.layoutUpdateInterval);
        }
        if (newSettings.getSettingsUpdateInterval() != this.settingsUpdateInterval) {
            this.settingsUpdateInterval = newSettings.getSettingsUpdateInterval();
            settingsUpdateCallback.onSettingsUpdateIntervalChange(this.settingsUpdateInterval);
        }
    }

    public void persistToPreferences(SharedPreferences preferences) {
        if (preferences != null) {
            SharedPreferences.Editor editor = preferences.edit();
            if (this.revision != null) {
                editor.putLong("com.sensorberg.preferences.settings.revision", this.revision.longValue());
            } else {
                editor.remove("com.sensorberg.preferences.settings.revision");
            }
            editor.putLong("com.sensorberg.preferences.scanner.exitTimeoutMillis", this.exitTimeoutMillis);
            editor.putLong("com.sensorberg.preferences.scanner.foreGroundScanTime", this.foreGroundScanTime);
            editor.putLong("com.sensorberg.preferences.scanner.foreGroundWaitTime", this.foreGroundWaitTime);
            editor.putLong("com.sensorberg.preferences.scanner.backgroundScanTime", this.backgroundScanTime);
            editor.putLong("com.sensorberg.preferences.scanner.backgroundWaitTime", this.backgroundWaitTime);
            editor.putLong("com.sensorberg.preferences.location.geohashMaxAge", this.geohashMaxAge);
            editor.putInt("com.sensorberg.preferences.location.geohashMinAccuracyRadius", this.geohashMinAccuracyRadius);
            editor.putBoolean("com.sensorberg.preferences.settings.restoreBeaconStates", this.shouldRestoreBeaconStates);
            editor.putLong("com.sensorberg.preferences.settings.messageDelayWindowLength", this.messageDelayWindowLength);
            editor.putLong("com.sensorberg.preferences.settings.updateInterval", this.settingsUpdateInterval);
            editor.putInt("com.sensorberg.preferences.settings.maxResolveRetries", this.maxRetries);
            editor.putLong("com.sensorberg.preferences.settings.timeBetweenResolveRetries", this.millisBetweenRetries);
            editor.putLong("com.sensorberg.preferences.settings.timeBetweenHistoryUploads", this.historyUploadInterval);
            editor.putLong("com.sensorberg.preferences.settings.timeBetweenBeaconLayoutUpdates", this.layoutUpdateInterval);
            editor.putInt("com.sensorberg.preferences.network.beaconReportLevel", this.beaconReportLevel);
            editor.putInt("com.sensorberg.preferences.settings.scannerMinRssi", this.scannerMinRssi);
            editor.putInt("com.sensorberg.preferences.settings.scannerMaxDistance", this.scannerMaxDistance);
            editor.apply();
        }
    }

    public String toString() {
        return "Settings(layoutUpdateInterval=" + this.getLayoutUpdateInterval() + ", messageDelayWindowLength=" + this.getMessageDelayWindowLength() + ", exitTimeoutMillis=" + this.getExitTimeoutMillis() + ", foreGroundScanTime=" + this.getForeGroundScanTime() + ", foreGroundWaitTime=" + this.getForeGroundWaitTime() + ", backgroundScanTime=" + this.getBackgroundScanTime() + ", backgroundWaitTime=" + this.getBackgroundWaitTime() + ", geohashMaxAge=" + this.getGeohashMaxAge() + ", geohashMinAccuracyRadius=" + this.getGeohashMinAccuracyRadius() + ", millisBetweenRetries=" + this.getMillisBetweenRetries() + ", maxRetries=" + this.getMaxRetries() + ", historyUploadInterval=" + this.getHistoryUploadInterval() + ", cleanBeaconMapRestartTimeout=" + this.getCleanBeaconMapRestartTimeout() + ", settingsUpdateInterval=" + this.getSettingsUpdateInterval() + ", shouldRestoreBeaconStates=" + this.isShouldRestoreBeaconStates() + ", scannerMinRssi=" + this.getScannerMinRssi() + ", scannerMaxDistance=" + this.getScannerMaxDistance() + ", beaconReportLevel=" + this.getBeaconReportLevel() + ", revision=" + this.getRevision() + ")";
    }

    public long getLayoutUpdateInterval() {
        return this.layoutUpdateInterval;
    }

    public long getMessageDelayWindowLength() {
        return this.messageDelayWindowLength;
    }

    public long getExitTimeoutMillis() {
        return this.exitTimeoutMillis;
    }

    public long getForeGroundScanTime() {
        return this.foreGroundScanTime;
    }

    public long getForeGroundWaitTime() {
        return this.foreGroundWaitTime;
    }

    public long getBackgroundScanTime() {
        return this.backgroundScanTime;
    }

    public long getBackgroundWaitTime() {
        return this.backgroundWaitTime;
    }

    public long getGeohashMaxAge() {
        return this.geohashMaxAge;
    }

    public int getGeohashMinAccuracyRadius() {
        return this.geohashMinAccuracyRadius;
    }

    public long getMillisBetweenRetries() {
        return this.millisBetweenRetries;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getHistoryUploadInterval() {
        return this.historyUploadInterval;
    }

    public void setHistoryUploadInterval(long historyUploadInterval) {
        this.historyUploadInterval = historyUploadInterval;
    }

    public long getCleanBeaconMapRestartTimeout() {
        return this.cleanBeaconMapRestartTimeout;
    }

    public long getSettingsUpdateInterval() {
        return this.settingsUpdateInterval;
    }

    public boolean isShouldRestoreBeaconStates() {
        return this.shouldRestoreBeaconStates;
    }

    public int getScannerMinRssi() {
        return this.scannerMinRssi;
    }

    public int getScannerMaxDistance() {
        return this.scannerMaxDistance;
    }

    public int getBeaconReportLevel() {
        return this.beaconReportLevel;
    }

    public Long getRevision() {
        return this.revision;
    }

    public static class Builder {
        private Settings settings;

        public Builder(Settings inputSettings) {
            this.settings = inputSettings;
        }

        public Settings build() {
            return this.settings;
        }

        public Builder withExitTimeoutMillis(long timeoutMillis) {
            this.settings.exitTimeoutMillis = timeoutMillis;
            return this;
        }

        public Builder withForegroundScanTime(long scanTime) {
            this.settings.foreGroundScanTime = scanTime;
            return this;
        }

        public Builder withForegroundWaitTime(long scanTime) {
            this.settings.foreGroundWaitTime = scanTime;
            return this;
        }

        public Builder withBackgroundScanTime(long scanTime) {
            this.settings.backgroundScanTime = scanTime;
            return this;
        }

        public Builder withBackgroundWaitTime(long scanTime) {
            this.settings.backgroundWaitTime = scanTime;
            return this;
        }
    }
}

