/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.action;

import android.net.Uri;
import android.webkit.URLUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.action.Action;
import com.sensorberg.sdk.action.InAppAction;
import com.sensorberg.sdk.action.SilentAction;
import com.sensorberg.sdk.action.UriMessageAction;
import com.sensorberg.sdk.action.VisitWebsiteAction;
import com.sensorberg.sdk.model.ISO8601TypeAdapter;
import java.util.Date;
import java.util.UUID;
import org.json.JSONException;

public class ActionFactory {
    private static Gson gson;
    private static final String SUBJECT = "subject";
    private static final String BODY = "body";
    private static final String URL = "url";
    private static final String PAYLOAD = "payload";

    public static Action getAction(int actionType, JsonObject message, UUID actionUUID, long delay) throws JSONException {
        JsonElement subjectJsonElement;
        if (actionType == 4) {
            return new SilentAction(actionUUID);
        }
        if (message == null) {
            return null;
        }
        Action value = null;
        String payload = null;
        JsonElement payloadElement = message.get(PAYLOAD);
        if (payloadElement != null && !payloadElement.isJsonNull()) {
            payload = payloadElement.isJsonArray() || payloadElement.isJsonObject() ? ActionFactory.getGson().toJson(message.get(PAYLOAD)) : payloadElement.getAsString();
        }
        String subject = (subjectJsonElement = message.get(SUBJECT)) == null || subjectJsonElement.isJsonNull() ? null : subjectJsonElement.getAsString();
        JsonElement bodyJsonElement = message.get(BODY);
        String body = bodyJsonElement == null || bodyJsonElement.isJsonNull() ? null : bodyJsonElement.getAsString();
        String url = ActionFactory.getUriFromJson(message.get(URL), actionType);
        switch (actionType) {
            case 1: {
                value = new UriMessageAction(actionUUID, subject, body, url, payload, delay);
                break;
            }
            case 2: {
                value = new VisitWebsiteAction(actionUUID, subject, body, Uri.parse((String)url), payload, delay);
                break;
            }
            case 3: {
                value = new InAppAction(actionUUID, subject, body, payload, Uri.parse((String)url), delay);
            }
        }
        return value;
    }

    private static Gson getGson() {
        if (gson == null) {
            gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(Date.class, ISO8601TypeAdapter.DATE_ADAPTER).setLenient().create();
        }
        return gson;
    }

    public static String getUriFromJson(JsonElement jsonElement, int messageType) {
        String urlToCheck = jsonElement == null || jsonElement.isJsonNull() ? "" : jsonElement.getAsString();
        String returnUrl = "";
        if (messageType == 3 && ActionFactory.validatedUrl(urlToCheck) || messageType == 1 && ActionFactory.validatedUrl(urlToCheck) || URLUtil.isNetworkUrl((String)urlToCheck)) {
            returnUrl = urlToCheck;
        }
        if (returnUrl.isEmpty()) {
            Logger.log.logError("URL is invalid, please change in the campaign settings.");
        }
        return returnUrl;
    }

    public static boolean validatedUrl(String urlToCheck) {
        Uri uri;
        try {
            uri = Uri.parse((String)urlToCheck);
        }
        catch (Exception e) {
            uri = Uri.parse((String)"");
        }
        return uri.getScheme() != null || uri.getPath() != null;
    }

    public static interface ServerType {
        public static final int URL_MESSAGE = 1;
        public static final int VISIT_WEBSITE = 2;
        public static final int IN_APP = 3;
        public static final int SILENT = 4;
    }
}

