/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import com.radiusnetworks.bluetooth.BluetoothCrashResolver;

@TargetApi(value=18)
public class CrashCallBackWrapper
implements BluetoothAdapter.LeScanCallback {
    private final BluetoothAdapter.LeScanCallback NONE;
    private final BluetoothCrashResolver bluetoothCrashResolver;
    private BluetoothAdapter.LeScanCallback callback;

    public CrashCallBackWrapper(Context application) {
        this.callback = this.NONE = new BluetoothAdapter.LeScanCallback(){

            public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            }
        };
        if (application.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            this.bluetoothCrashResolver = new BluetoothCrashResolver(application);
            this.bluetoothCrashResolver.start();
        } else {
            this.bluetoothCrashResolver = null;
        }
    }

    public void setCallback(BluetoothAdapter.LeScanCallback incoming) {
        this.callback = incoming == null ? this.NONE : incoming;
    }

    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        if (this.bluetoothCrashResolver != null) {
            this.bluetoothCrashResolver.notifyScannedDevice(device, this);
        }
        this.callback.onLeScan(device, rssi, scanRecord);
    }
}

