/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.action.Action;
import com.sensorberg.sdk.action.InAppAction;
import com.sensorberg.sdk.action.UriMessageAction;
import com.sensorberg.sdk.action.VisitWebsiteAction;
import com.sensorberg.sdk.model.BeaconId;

public abstract class ActionReceiver
extends BroadcastReceiver {
    private static final String TAG = ActionReceiver.class.getName();
    private static final String ACTION_PRESENT = "com.sensorberg.android.PRESENT_ACTION";
    private static final String ACTION_CONVERSION_SUCCESS = "com.sensorberg.android.CONVERSION_SUCCESS";
    private static final String ACTION_CONVERSION_DELETE = "com.sensorberg.android.CONVERSION_DELETE";
    private static final String EXTRA_ACTION = "action";
    private static final String EXTRA_BEACON = "beacon";
    private static final String EXTRA_URI = "uri";
    private static final String EXTRA_BUNDLE = "bundle";

    public void onReceive(Context context, Intent intent) {
        if (intent == null) {
            Logger.log.debug("Received null intent");
            return;
        }
        String intentAction = intent.getAction();
        if (intentAction == null) {
            Logger.log.debug("Received intent without intent action string");
            return;
        }
        if (intentAction.equals(ACTION_PRESENT)) {
            Uri uri;
            Action sdkAction = (Action)intent.getExtras().getParcelable("com.sensorberg.sdk.Action");
            if (sdkAction == null) {
                Logger.log.debug("Received intent without SDK Action");
                return;
            }
            BeaconId beaconId = (BeaconId)intent.getExtras().getParcelable("com.sensorberg.sdk.BeaconId");
            Notification notification = this.onGetNotification(sdkAction, beaconId, uri = this.processAction(sdkAction, beaconId, context), context);
            if (notification != null) {
                NotificationManager manager = (NotificationManager)context.getSystemService("notification");
                manager.notify(sdkAction.hashCode(), notification);
                SensorbergSdk.notifyActionShowAttempt(sdkAction.getUuid(), context);
            }
        } else if (intentAction.equals(ACTION_CONVERSION_SUCCESS) || intentAction.equals(ACTION_CONVERSION_DELETE)) {
            BeaconId beaconId;
            Action action = (Action)intent.getParcelableExtra(EXTRA_ACTION);
            if (action == null) {
                Logger.log.debug("Received com.sensorberg.android.CONVERSION_SUCCESS intent is missing SDK Action");
            }
            if ((beaconId = (BeaconId)intent.getParcelableExtra(EXTRA_BEACON)) == null) {
                Logger.log.debug("Received com.sensorberg.android.CONVERSION_SUCCESS intent is missing BeaconId");
            }
            Uri uri = (Uri)intent.getParcelableExtra(EXTRA_URI);
            Bundle bundle = intent.getBundleExtra(EXTRA_BUNDLE);
            if (intentAction.equals(ACTION_CONVERSION_SUCCESS)) {
                this.onNotificationSuccess(action, beaconId, uri, bundle, context);
            } else {
                this.onNotificationDeleted(action, beaconId, uri, bundle, context);
            }
        } else {
            Logger.log.debug("Received intent with unknown intent action string: " + intentAction);
        }
    }

    private Uri processAction(Action action, BeaconId beaconId, Context context) {
        this.onAction(action, beaconId, context);
        Uri uri = null;
        switch (action.getType()) {
            case MESSAGE_URI: {
                UriMessageAction uriMessageAction = (UriMessageAction)action;
                uri = Uri.parse((String)uriMessageAction.getUri());
                this.onUriAction(uriMessageAction, beaconId, context);
                break;
            }
            case MESSAGE_WEBSITE: {
                VisitWebsiteAction visitWebsiteAction = (VisitWebsiteAction)action;
                uri = visitWebsiteAction.getUri();
                this.onVisitWebsiteAction(visitWebsiteAction, beaconId, context);
                break;
            }
            case MESSAGE_IN_APP: {
                InAppAction inAppAction = (InAppAction)action;
                uri = inAppAction.getUri();
                this.onInAppAction(inAppAction, beaconId, context);
            }
        }
        return uri;
    }

    public abstract void onAction(Action var1, BeaconId var2, Context var3);

    public abstract void onUriAction(UriMessageAction var1, BeaconId var2, Context var3);

    public abstract void onVisitWebsiteAction(VisitWebsiteAction var1, BeaconId var2, Context var3);

    public abstract void onInAppAction(InAppAction var1, BeaconId var2, Context var3);

    public abstract Notification onGetNotification(Action var1, BeaconId var2, Uri var3, Context var4);

    public void onNotificationSuccess(Action action, BeaconId beaconId, Uri uri, Bundle bundle, Context context) {
        SensorbergSdk.notifyActionSuccess(action.getUuid(), context);
    }

    private void onNotificationDeleted(Action action, BeaconId beaconId, Uri uri, Bundle bundle, Context context) {
        SensorbergSdk.notifyActionRejected(action.getUuid(), context);
    }

    public PendingIntent getNotificationContentPendingIntent(Action action, BeaconId beaconId, Uri uri, Bundle bundle, Context context, int flags) {
        return this.getPendingIntent(ACTION_CONVERSION_SUCCESS, action, beaconId, uri, bundle, context, flags);
    }

    private PendingIntent getNotificationDeletedPendingIntent(Action action, BeaconId beaconId, Uri uri, Bundle bundle, Context context, int flags) {
        return this.getPendingIntent(ACTION_CONVERSION_DELETE, action, beaconId, uri, bundle, context, flags);
    }

    private PendingIntent getPendingIntent(String actionString, Action action, BeaconId beaconId, Uri uri, Bundle bundle, Context context, int flags) {
        Intent intent = new Intent(actionString);
        intent.setClass(context, ((Object)((Object)this)).getClass());
        if (action == null) {
            Logger.log.debug("Missing SDK Action! Action will be null in onNotificationSuccess");
        }
        if (beaconId == null) {
            Logger.log.debug("Missing BeaconId! BeaconId will be null in onNotificationSuccess");
        }
        intent.putExtra(EXTRA_ACTION, (Parcelable)action);
        intent.putExtra(EXTRA_BEACON, (Parcelable)beaconId);
        intent.putExtra(EXTRA_URI, (Parcelable)uri);
        intent.putExtra(EXTRA_BUNDLE, bundle);
        return PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)flags);
    }
}

