/*
 * Decompiled with CFR 0.152.
 */
package com.radiusnetworks.bluetooth;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import com.sensorberg.sdk.Logger;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@TargetApi(value=5)
public class BluetoothCrashResolver {
    private static final String TAG = "BluetoothCrashResolver";
    private static final boolean PREEMPTIVE_ACTION_ENABLED = true;
    private boolean debugEnabled = false;
    private static final String DISTINCT_BLUETOOTH_ADDRESSES_FILE = "BluetoothCrashResolverState.txt";
    private boolean recoveryInProgress = false;
    private boolean discoveryStartConfirmed = false;
    private long lastBluetoothOffTime = 0L;
    private long lastBluetoothTurningOnTime = 0L;
    private long lastBluetoothCrashDetectionTime = 0L;
    private int detectedCrashCount = 0;
    private int recoveryAttemptCount = 0;
    private boolean lastRecoverySucceeded = false;
    private long lastStateSaveTime = 0L;
    private static final long MIN_TIME_BETWEEN_STATE_SAVES_MILLIS = 60000L;
    private Context context = null;
    private UpdateNotifier updateNotifier;
    private final Set<String> distinctBluetoothAddresses = new HashSet<String>();
    private final DiscoveryCanceller discoveryCanceller = new DiscoveryCanceller();
    private static final long SUSPICIOUSLY_SHORT_BLUETOOTH_OFF_INTERVAL_MILLIS = 600L;
    private static final int BLUEDROID_MAX_BLUETOOTH_MAC_COUNT = 1990;
    private static final int BLUEDROID_POST_DISCOVERY_ESTIMATED_BLUETOOTH_MAC_COUNT = 400;
    private static final int TIME_TO_LET_DISCOVERY_RUN_MILLIS = 5000;
    private final BroadcastReceiver receiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.bluetooth.adapter.action.DISCOVERY_FINISHED")) {
                if (BluetoothCrashResolver.this.recoveryInProgress) {
                    if (BluetoothCrashResolver.this.isDebugEnabled()) {
                        Log.d((String)BluetoothCrashResolver.TAG, (String)"Bluetooth discovery finished");
                    }
                    BluetoothCrashResolver.this.finishRecovery();
                } else if (BluetoothCrashResolver.this.isDebugEnabled()) {
                    Log.d((String)BluetoothCrashResolver.TAG, (String)"Bluetooth discovery finished (external)");
                }
            }
            if (action.equals("android.bluetooth.adapter.action.DISCOVERY_STARTED")) {
                if (BluetoothCrashResolver.this.recoveryInProgress) {
                    BluetoothCrashResolver.this.discoveryStartConfirmed = true;
                    if (BluetoothCrashResolver.this.isDebugEnabled()) {
                        Log.d((String)BluetoothCrashResolver.TAG, (String)"Bluetooth discovery started");
                    }
                } else if (BluetoothCrashResolver.this.isDebugEnabled()) {
                    Log.d((String)BluetoothCrashResolver.TAG, (String)"Bluetooth discovery started (external)");
                }
            }
            if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                switch (state) {
                    case -2147483648: {
                        if (!BluetoothCrashResolver.this.isDebugEnabled()) break;
                        Log.d((String)BluetoothCrashResolver.TAG, (String)"Bluetooth state is ERROR");
                        break;
                    }
                    case 10: {
                        if (BluetoothCrashResolver.this.isDebugEnabled()) {
                            Log.d((String)BluetoothCrashResolver.TAG, (String)"Bluetooth state is OFF");
                        }
                        BluetoothCrashResolver.this.lastBluetoothOffTime = new Date().getTime();
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 12: {
                        if (BluetoothCrashResolver.this.isDebugEnabled()) {
                            Log.d((String)BluetoothCrashResolver.TAG, (String)"Bluetooth state is ON");
                        }
                        if (BluetoothCrashResolver.this.isDebugEnabled()) {
                            Log.d((String)BluetoothCrashResolver.TAG, (String)("Bluetooth was turned off for " + (BluetoothCrashResolver.this.lastBluetoothTurningOnTime - BluetoothCrashResolver.this.lastBluetoothOffTime) + " milliseconds"));
                        }
                        if (BluetoothCrashResolver.this.lastBluetoothTurningOnTime - BluetoothCrashResolver.this.lastBluetoothOffTime >= 600L) break;
                        BluetoothCrashResolver.this.crashDetected();
                        break;
                    }
                    case 11: {
                        BluetoothCrashResolver.this.lastBluetoothTurningOnTime = new Date().getTime();
                        if (!BluetoothCrashResolver.this.isDebugEnabled()) break;
                        Log.d((String)BluetoothCrashResolver.TAG, (String)"Bluetooth state is TURNING_ON");
                    }
                }
            }
        }
    };

    public BluetoothCrashResolver(Context context) {
        this.context = context.getApplicationContext();
        if (this.isDebugEnabled()) {
            Log.d((String)TAG, (String)"constructed");
        }
        this.loadState();
    }

    public void start() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        this.context.registerReceiver(this.receiver, filter);
        if (this.isDebugEnabled()) {
            Log.d((String)TAG, (String)"started listening for BluetoothAdapter events");
        }
    }

    public void stop() {
        this.context.unregisterReceiver(this.receiver);
        if (this.isDebugEnabled()) {
            Log.d((String)TAG, (String)"stopped listening for BluetoothAdapter events");
        }
        this.saveState();
    }

    public void enableDebug() {
        this.debugEnabled = true;
    }

    public void disableDebug() {
        this.debugEnabled = false;
    }

    @TargetApi(value=18)
    public void notifyScannedDevice(BluetoothDevice device, BluetoothAdapter.LeScanCallback scanner) {
        int newSize;
        int oldSize = 0;
        if (this.isDebugEnabled()) {
            oldSize = this.distinctBluetoothAddresses.size();
        }
        this.distinctBluetoothAddresses.add(device.getAddress());
        if (this.isDebugEnabled() && oldSize != (newSize = this.distinctBluetoothAddresses.size()) && newSize % 100 == 0 && this.isDebugEnabled()) {
            Log.d((String)TAG, (String)("Distinct bluetooth devices seen: " + this.distinctBluetoothAddresses.size()));
        }
        if (this.distinctBluetoothAddresses.size() > this.getCrashRiskDeviceCount() && !this.recoveryInProgress) {
            Logger.log.verbose("Large number of bluetooth devices detected: " + this.distinctBluetoothAddresses.size() + " Proactively attempting to clear out address list to prevent a crash");
            Logger.log.verbose("Stopping LE Scan");
            BluetoothAdapter.getDefaultAdapter().stopLeScan(scanner);
            this.startRecovery();
            this.processStateChange();
        }
    }

    public void crashDetected() {
        if (Build.VERSION.SDK_INT < 18) {
            if (this.isDebugEnabled()) {
                Log.d((String)TAG, (String)"Ignoring crashes before SDK 18, because BLE is unsupported.");
            }
            return;
        }
        Logger.log.verbose("BluetoothService crash detected");
        if (this.distinctBluetoothAddresses.size() > 0 && this.isDebugEnabled()) {
            Log.d((String)TAG, (String)("Distinct bluetooth devices seen at crash: " + this.distinctBluetoothAddresses.size()));
        }
        this.lastBluetoothCrashDetectionTime = new Date().getTime();
        ++this.detectedCrashCount;
        if (this.recoveryInProgress) {
            if (this.isDebugEnabled()) {
                Log.d((String)TAG, (String)"Ignoring bluetooth crash because recovery is already in progress.");
            }
        } else {
            this.startRecovery();
        }
        this.processStateChange();
    }

    public boolean isLastRecoverySucceeded() {
        return this.lastRecoverySucceeded;
    }

    public boolean isRecoveryInProgress() {
        return this.recoveryInProgress;
    }

    public void forceFlush() {
        this.startRecovery();
        this.processStateChange();
    }

    private boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    private int getCrashRiskDeviceCount() {
        return 1590;
    }

    private void processStateChange() {
        if (this.updateNotifier != null) {
            this.updateNotifier.dataUpdated();
        }
        if (new Date().getTime() - this.lastStateSaveTime > 60000L) {
            this.saveState();
        }
    }

    @TargetApi(value=17)
    private void startRecovery() {
        ++this.recoveryAttemptCount;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (this.isDebugEnabled()) {
            Log.d((String)TAG, (String)"about to check if discovery is active");
        }
        if (!adapter.isDiscovering()) {
            Logger.log.verbose("Recovery attempt started");
            this.recoveryInProgress = true;
            this.discoveryStartConfirmed = false;
            if (this.isDebugEnabled()) {
                Log.d((String)TAG, (String)"about to command discovery");
            }
            if (!adapter.startDiscovery()) {
                Logger.log.verbose("Can't start discovery.  Is bluetooth turned on?");
            }
            if (this.isDebugEnabled()) {
                Log.d((String)TAG, (String)("startDiscovery commanded.  isDiscovering()=" + adapter.isDiscovering()));
            }
            if (this.isDebugEnabled()) {
                Log.d((String)TAG, (String)"We will be cancelling this discovery in 5000 milliseconds.");
            }
            this.discoveryCanceller.doInBackground(new Void[0]);
        } else {
            Logger.log.verbose("Already discovering.Recovery attempt abandoned.");
        }
    }

    private void finishRecovery() {
        Logger.log.verbose("Recovery attempt finished");
        this.distinctBluetoothAddresses.clear();
        this.recoveryInProgress = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState() {
        OutputStreamWriter writer = null;
        this.lastStateSaveTime = new Date().getTime();
        try {
            FileOutputStream outputStream = this.context.openFileOutput(DISTINCT_BLUETOOTH_ADDRESSES_FILE, 0);
            writer = new OutputStreamWriter(outputStream);
            writer.write(this.lastBluetoothCrashDetectionTime + "\n");
            writer.write(this.detectedCrashCount + "\n");
            writer.write(this.recoveryAttemptCount + "\n");
            writer.write(this.lastRecoverySucceeded ? "1\n" : "0\n");
            Set<String> set = this.distinctBluetoothAddresses;
            synchronized (set) {
                for (String mac : this.distinctBluetoothAddresses) {
                    writer.write(mac);
                    writer.write("\n");
                }
            }
        }
        catch (IOException e) {
            Logger.log.verbose("Can't write macs to BluetoothCrashResolverState.txt");
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e1) {
                    Logger.log.logError("Cant\u00b4 write macs", e1);
                }
            }
        }
        if (this.isDebugEnabled()) {
            Log.d((String)TAG, (String)("Wrote " + this.distinctBluetoothAddresses.size() + " bluetooth addresses"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadState() {
        BufferedReader reader = null;
        try {
            String mac;
            FileInputStream inputStream = this.context.openFileInput(DISTINCT_BLUETOOTH_ADDRESSES_FILE);
            reader = new BufferedReader(new InputStreamReader(inputStream));
            String line = reader.readLine();
            if (line != null) {
                this.lastBluetoothCrashDetectionTime = Long.parseLong(line);
            }
            if ((line = reader.readLine()) != null) {
                this.detectedCrashCount = Integer.parseInt(line);
            }
            if ((line = reader.readLine()) != null) {
                this.recoveryAttemptCount = Integer.parseInt(line);
            }
            if ((line = reader.readLine()) != null) {
                this.lastRecoverySucceeded = line.equals("1");
            }
            while ((mac = reader.readLine()) != null) {
                this.distinctBluetoothAddresses.add(mac);
            }
        }
        catch (IOException e) {
            Logger.log.verbose("Can't read macs from BluetoothCrashResolverState.txt");
        }
        catch (NumberFormatException e) {
            Logger.log.verbose("Can't parse file BluetoothCrashResolverState.txt");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {
                    Logger.log.logError("close mac reader", e1);
                }
            }
        }
        if (this.isDebugEnabled()) {
            Log.d((String)TAG, (String)("Read " + this.distinctBluetoothAddresses.size() + " bluetooth addresses"));
        }
    }

    public long getLastBluetoothCrashDetectionTime() {
        return this.lastBluetoothCrashDetectionTime;
    }

    public int getDetectedCrashCount() {
        return this.detectedCrashCount;
    }

    public int getRecoveryAttemptCount() {
        return this.recoveryAttemptCount;
    }

    public void setUpdateNotifier(UpdateNotifier updateNotifier) {
        this.updateNotifier = updateNotifier;
    }

    private class DiscoveryCanceller
    extends AsyncTask<Void, Void, Void> {
        private DiscoveryCanceller() {
        }

        protected Void doInBackground(Void ... params) {
            block7: {
                try {
                    BluetoothAdapter adapter;
                    Thread.sleep(5000L);
                    if (!BluetoothCrashResolver.this.discoveryStartConfirmed) {
                        Logger.log.verbose("BluetoothAdapter.ACTION_DISCOVERY_STARTED never received.  Recovery may fail.");
                    }
                    if ((adapter = BluetoothAdapter.getDefaultAdapter()).isDiscovering()) {
                        if (BluetoothCrashResolver.this.isDebugEnabled()) {
                            Log.d((String)BluetoothCrashResolver.TAG, (String)"Cancelling discovery");
                        }
                        adapter.cancelDiscovery();
                    } else if (BluetoothCrashResolver.this.isDebugEnabled()) {
                        Log.d((String)BluetoothCrashResolver.TAG, (String)"Discovery not running.  Won't cancel it");
                    }
                }
                catch (InterruptedException e) {
                    if (!BluetoothCrashResolver.this.isDebugEnabled()) break block7;
                    Log.d((String)BluetoothCrashResolver.TAG, (String)"DiscoveryCanceller sleep interrupted.");
                }
            }
            return null;
        }

        protected void onPostExecute(Void result) {
        }

        protected void onPreExecute() {
        }

        protected void onProgressUpdate(Void ... values) {
        }
    }

    public static interface UpdateNotifier {
        public void dataUpdated();
    }
}

