/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.location;

import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.location.Location;
import ch.hsr.geohash.GeoHash;
import ch.hsr.geohash.WGS84Point;
import ch.hsr.geohash.queries.GeoHashCircleQuery;
import com.google.android.gms.location.Geofence;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.location.GeofenceData;
import com.sensorberg.sdk.settings.SettingsManager;
import com.sensorberg.sdk.storage.DBHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class GeofenceStorage {
    private static final int MIN_RADIUS = 100;
    private static final int MAX_RADIUS = 819200;
    public static final int HIGH = 100;
    public static final int LOW = 50;
    private SharedPreferences preferences;
    private SettingsManager settings;
    private SQLiteDatabase db;
    private int radius;
    private int count;

    public GeofenceStorage(Context context, SettingsManager settings, SharedPreferences preferences) {
        this.settings = settings;
        this.preferences = preferences;
        this.radius = preferences.getInt("com.sensorberg.preferences.initialGeofencesSearchRadius", 100000);
        this.db = DBHelper.getInstance(context).getReadableDatabase();
        this.count = this.getCountQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFences(List<String> fences) {
        SQLiteStatement stmt = null;
        try {
            long start = System.currentTimeMillis();
            this.db.beginTransaction();
            this.db.execSQL("DELETE FROM geofences");
            stmt = this.db.compileStatement("INSERT OR IGNORE INTO geofences (fence) VALUES (?)");
            for (String fence : fences) {
                stmt.clearBindings();
                stmt.bindString(1, fence);
                stmt.executeInsert();
            }
            this.db.setTransactionSuccessful();
            this.count = fences.size();
            Logger.log.geofence("Saved " + fences.size() + " in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (SQLException ex) {
            Logger.log.geofenceError("Storage error", ex);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            this.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, Geofence> getGeofences(Location location) throws SQLException {
        Cursor cursor;
        WGS84Point center;
        long start;
        block7: {
            if (this.count == 0) {
                return new HashMap<String, Geofence>(0);
            }
            if (this.count < 100 || location == null) {
                String sql = "SELECT fence FROM geofences LIMIT 100";
                Cursor cursor2 = null;
                try {
                    cursor2 = this.db.rawQuery(sql, null);
                    HashMap<String, Geofence> hashMap = this.getGeofencesFromCursor(cursor2, this.count);
                    this.close(cursor2);
                    return hashMap;
                }
                catch (Throwable throwable) {
                    this.close(cursor2);
                    throw throwable;
                }
            }
            start = System.currentTimeMillis();
            center = new WGS84Point(location.getLatitude(), location.getLongitude());
            this.radius = this.preferences.getInt("com.sensorberg.preferences.initialGeofencesSearchRadius", 100000);
            cursor = null;
            try {
                cursor = this.searchGeofencesRange(center, this.radius);
                if (cursor.getCount() <= 50 || cursor.getCount() > 100) break block7;
                HashMap<String, Geofence> hashMap = this.getGeofencesFromCursor(cursor, cursor.getCount());
                this.close(cursor);
                return hashMap;
            }
            catch (Throwable throwable) {
                this.close(cursor);
                throw throwable;
            }
        }
        cursor = cursor.getCount() > 100 ? this.searchAndReduce(center, this.radius, cursor) : this.searchAndExtend(center, this.radius, cursor);
        Logger.log.geofence("Filtered " + cursor.getCount() + " out of " + this.count + " in " + (System.currentTimeMillis() - start) + " ms");
        HashMap<String, Geofence> hashMap = this.getGeofencesFromCursor(cursor, 100);
        this.close(cursor);
        return hashMap;
    }

    private Cursor searchAndReduce(WGS84Point center, int radius, Cursor current) {
        Cursor result = current;
        Cursor previous = null;
        int radiusPrev = radius;
        boolean done = false;
        while (!done) {
            if (current.getCount() <= 100) {
                if (current.getCount() > 0) {
                    result = current;
                    this.close(previous);
                } else {
                    radius = radiusPrev;
                    if (previous != null) {
                        result = previous;
                        this.close(current);
                    } else {
                        result = current;
                        this.close(previous);
                    }
                }
                Logger.log.geofence("Found " + result.getCount() + " by reducing radius to " + radius + " m");
                this.preferences.edit().putInt("com.sensorberg.preferences.initialGeofencesSearchRadius", radius).apply();
                this.radius = radius;
                break;
            }
            this.close(previous);
            radiusPrev = radius;
            if ((radius /= 2) < 100) {
                radius = 100;
                done = true;
                Logger.log.geofence("Minimal radius reached: " + radius);
            }
            previous = current;
            current = this.searchGeofencesRange(center, radius);
        }
        return result;
    }

    private Cursor searchAndExtend(WGS84Point center, int radius, Cursor current) {
        Cursor result = current;
        Cursor previous = null;
        int radiusPrev = radius;
        boolean done = false;
        while (!done) {
            if (current.getCount() > 50) {
                if (current.getCount() <= 100) {
                    result = current;
                    this.close(previous);
                } else {
                    radius = radiusPrev;
                    if (previous != null && previous.getCount() != 0) {
                        result = previous;
                        this.close(current);
                    } else {
                        result = current;
                        this.close(previous);
                    }
                }
                Logger.log.geofence("Found: " + result.getCount() + " by extending radius to " + radius + " m");
                this.preferences.edit().putInt("com.sensorberg.preferences.initialGeofencesSearchRadius", radius).apply();
                this.radius = radius;
                break;
            }
            this.close(previous);
            radiusPrev = radius;
            if ((radius *= 2) > 819200) {
                radius = 819200;
                done = true;
                Logger.log.geofence("Maximum radius reached: " + radius);
            }
            previous = current;
            current = this.searchGeofencesRange(center, radius);
        }
        return result;
    }

    private List<GeoHash> truncateToBase32(List<GeoHash> geoHashes) {
        ArrayList<GeoHash> result = new ArrayList<GeoHash>(geoHashes.size());
        for (GeoHash search : geoHashes) {
            int bits = search.significantBits();
            int floor = (int)(5.0 * Math.floor(bits / 5));
            if (floor == 0) {
                floor = 5;
            }
            GeoHash round = GeoHash.fromLongValue((long)search.longValue(), (int)floor);
            result.add(round);
        }
        return result;
    }

    private HashMap<String, Geofence> getGeofencesFromCursor(Cursor cursor, int limit) {
        HashMap<String, Geofence> result = new HashMap<String, Geofence>(limit);
        int i = 0;
        while (cursor.moveToNext()) {
            if (++i <= 100) {
                String fence = cursor.getString(cursor.getColumnIndex("fence"));
                Geofence geofence = this.buildGeofence(fence);
                if (geofence == null) continue;
                result.put(fence, geofence);
                continue;
            }
            Logger.log.geofenceError("Over 100 found in cursor", null);
            break;
        }
        return result;
    }

    private Cursor searchGeofencesRange(WGS84Point center, int radius) throws SQLException {
        GeoHashCircleQuery query = new GeoHashCircleQuery(center, (double)radius);
        List<GeoHash> geoHashes = this.truncateToBase32(query.getSearchHashes());
        String sql = "SELECT fence FROM geofences WHERE fence LIKE ?";
        String[] args = new String[geoHashes.size()];
        for (int i = 0; i < geoHashes.size(); ++i) {
            args[i] = geoHashes.get(i).toBase32() + "%";
            if (i <= 0) continue;
            sql = sql + " OR fence LIKE ?";
        }
        sql = sql + " LIMIT 101";
        return this.db.rawQuery(sql, args);
    }

    private int getCountQuery() throws SQLException {
        Cursor cursor;
        block3: {
            cursor = null;
            try {
                cursor = this.db.rawQuery("SELECT count(1) FROM geofences", null);
                if (!cursor.moveToNext()) break block3;
                int n = cursor.getInt(0);
                this.close(cursor);
                return n;
            }
            catch (Throwable throwable) {
                this.close(cursor);
                throw throwable;
            }
        }
        int n = 0;
        this.close(cursor);
        return n;
    }

    private Geofence buildGeofence(String fence) {
        try {
            GeofenceData temp = new GeofenceData(fence, false);
            return new Geofence.Builder().setRequestId(temp.getFence()).setCircularRegion(temp.getLatitude(), temp.getLongitude(), (float)temp.getRadius()).setExpirationDuration(Long.MAX_VALUE).setNotificationResponsiveness(this.settings.getGeofenceNotificationResponsiveness()).setTransitionTypes(3).build();
        }
        catch (IllegalArgumentException ex) {
            Logger.log.geofenceError("Invalid geofence: " + fence, ex);
            return null;
        }
    }

    private void close(Cursor cursor) {
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public int getCount() {
        return this.count;
    }
}

