/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal.transport;

import com.google.gson.Gson;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.PlatformIdentifier;
import com.sensorberg.sdk.internal.transport.RetrofitApiTransport;
import com.sensorberg.sdk.internal.transport.interfaces.RetrofitApiServiceV0;
import com.sensorberg.sdk.internal.transport.interfaces.RetrofitApiServiceV1;
import com.sensorberg.sdk.internal.transport.interfaces.RetrofitApiServiceV2;
import com.sensorberg.sdk.internal.transport.model.HistoryBody;
import com.sensorberg.sdk.internal.transport.model.SettingsResponse;
import com.sensorberg.sdk.model.server.ResolveResponse;
import com.sensorberg.utils.Objects;
import java.io.File;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Cache;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.Url;

public class RetrofitApiServiceImpl {
    public static final String OKHTTP_HEADER = "okhttp-header";
    private static final int CONNECTION_TIMEOUT = 30;
    private static final long HTTP_RESPONSE_DISK_CACHE_MAX_SIZE = 0x500000L;
    final Gson mGson;
    private final PlatformIdentifier mPlatformIdentifier;
    private String mApiToken;
    private final RetrofitApiServiceV0 mApiServiceV0;
    private final RetrofitApiServiceV1 mApiServiceV1;
    private final RetrofitApiServiceV2 mApiServiceV2;
    private final int version;
    private OkHttpClient mClient;
    private HttpLoggingInterceptor httpLoggingInterceptor;
    private final Interceptor headerAuthorizationInterceptor = new Interceptor(){

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            Headers.Builder headersBuilder = request.headers().newBuilder().add("User-Agent", RetrofitApiServiceImpl.this.mPlatformIdentifier.getUserAgentString()).add("X-iid", RetrofitApiServiceImpl.this.mPlatformIdentifier.getDeviceInstallationIdentifier());
            if (RetrofitApiServiceImpl.this.mPlatformIdentifier.getAdvertiserIdentifier() != null) {
                headersBuilder.add("X-aid", RetrofitApiServiceImpl.this.mPlatformIdentifier.getAdvertiserIdentifier());
            }
            if (RetrofitApiServiceImpl.this.mApiToken != null) {
                headersBuilder.add("X-Api-Key", RetrofitApiServiceImpl.this.mApiToken);
            }
            request = request.newBuilder().headers(headersBuilder.build()).build();
            return chain.proceed(request);
        }
    };

    public RetrofitApiServiceImpl(File cacheFolder, Gson gson, PlatformIdentifier platformId, String baseUrl) {
        this.mGson = gson;
        this.mPlatformIdentifier = platformId;
        Retrofit restAdapter = new Retrofit.Builder().baseUrl(baseUrl).client(this.getOkHttpClient(cacheFolder)).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.mGson)).build();
        this.version = RetrofitApiTransport.BACKEND_VERSION;
        if (this.version == 0) {
            this.mApiServiceV0 = (RetrofitApiServiceV0)restAdapter.create(RetrofitApiServiceV0.class);
            this.mApiServiceV1 = null;
            this.mApiServiceV2 = null;
        } else if (this.version == 1) {
            this.mApiServiceV0 = null;
            this.mApiServiceV1 = (RetrofitApiServiceV1)restAdapter.create(RetrofitApiServiceV1.class);
            this.mApiServiceV2 = null;
        } else if (this.version == 2) {
            this.mApiServiceV0 = null;
            this.mApiServiceV1 = null;
            this.mApiServiceV2 = (RetrofitApiServiceV2)restAdapter.create(RetrofitApiServiceV2.class);
        } else {
            this.mApiServiceV0 = null;
            this.mApiServiceV1 = null;
            this.mApiServiceV2 = null;
            throw new IllegalArgumentException("Sorry, only available beackend versions are 0, 1, 2");
        }
    }

    private OkHttpClient getOkHttpClient(File baseDir) {
        OkHttpClient.Builder okClientBuilder = new OkHttpClient.Builder();
        okClientBuilder.addInterceptor(this.headerAuthorizationInterceptor);
        this.httpLoggingInterceptor = new HttpLoggingInterceptor();
        this.httpLoggingInterceptor.setLevel(Logger.isVerboseLoggingEnabled() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE);
        okClientBuilder.addInterceptor((Interceptor)this.httpLoggingInterceptor);
        okClientBuilder.addNetworkInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Response response = chain.proceed(chain.request());
                return response.newBuilder().addHeader(RetrofitApiServiceImpl.OKHTTP_HEADER, String.valueOf(response.code())).build();
            }
        });
        okClientBuilder.retryOnConnectionFailure(true);
        if (baseDir != null) {
            File cacheDir = new File(baseDir, "HttpResponseCache");
            okClientBuilder.cache(new Cache(cacheDir, 0x500000L));
        }
        okClientBuilder.connectTimeout(30L, TimeUnit.SECONDS);
        okClientBuilder.readTimeout(30L, TimeUnit.SECONDS);
        okClientBuilder.writeTimeout(30L, TimeUnit.SECONDS);
        this.mClient = okClientBuilder.build();
        return this.mClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoggingEnabled(boolean enabled) {
        Gson gson = this.mGson;
        synchronized (gson) {
            if (enabled) {
                this.httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            } else {
                this.httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
            }
        }
    }

    public Call<ResolveResponse> updateBeaconLayout(SortedMap<String, String> attributes) {
        if (attributes == null) {
            attributes = new TreeMap<String, String>();
        }
        if (this.version == 0) {
            return this.mApiServiceV0.updateBeaconLayout();
        }
        if (this.version == 1) {
            return this.mApiServiceV1.updateBeaconLayout(this.mApiToken, attributes);
        }
        return this.mApiServiceV2.updateBeaconLayout(this.mApiToken, attributes);
    }

    public Call<ResolveResponse> getBeacon(@Header(value="X-pid") String beaconId, @Header(value="X-qos") String networkInfo, SortedMap<String, String> attributes) {
        if (attributes == null) {
            attributes = new TreeMap<String, String>();
        }
        if (this.version == 0) {
            return this.mApiServiceV0.getBeacon(beaconId, networkInfo);
        }
        if (this.version == 1) {
            return this.mApiServiceV1.getBeacon(beaconId, networkInfo, this.mApiToken, attributes);
        }
        return this.mApiServiceV2.getBeacon(this.mApiToken, attributes);
    }

    public Call<ResponseBody> publishHistory(@Body HistoryBody body) {
        if (this.version == 0) {
            return this.mApiServiceV0.publishHistory(body);
        }
        if (this.version == 1) {
            return this.mApiServiceV1.publishHistory(body);
        }
        return this.mApiServiceV2.publishHistory(this.mApiToken, body);
    }

    public Call<SettingsResponse> getSettings() {
        return this.getSettings(this.mApiToken);
    }

    public Call<SettingsResponse> getSettings(@Url String url) {
        if (this.version == 0) {
            return this.mApiServiceV0.getSettings(url);
        }
        if (this.version == 1) {
            return this.mApiServiceV1.getSettings(url);
        }
        return this.mApiServiceV2.getSettings(url);
    }

    public boolean setApiToken(String newToken) {
        boolean tokensDiffer;
        boolean bl = tokensDiffer = this.mApiToken != null && !Objects.equals(newToken, this.mApiToken);
        if (tokensDiffer && this.mClient != null) {
            try {
                this.mClient.cache().evictAll();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.mApiToken = newToken;
        return tokensDiffer;
    }
}

