/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SyncStatusObserver;
import android.os.Parcelable;
import com.sensorberg.SensorbergSdk;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.MinimalBootstrapper;
import com.sensorberg.sdk.SensorbergService;
import com.sensorberg.sdk.action.Action;
import com.sensorberg.sdk.action.ActionType;
import com.sensorberg.sdk.internal.PermissionChecker;
import com.sensorberg.sdk.internal.interfaces.BluetoothPlatform;
import com.sensorberg.sdk.internal.interfaces.Clock;
import com.sensorberg.sdk.internal.interfaces.FileManager;
import com.sensorberg.sdk.internal.interfaces.HandlerManager;
import com.sensorberg.sdk.internal.interfaces.MessageDelayWindowLengthListener;
import com.sensorberg.sdk.internal.interfaces.ServiceScheduler;
import com.sensorberg.sdk.internal.transport.interfaces.Transport;
import com.sensorberg.sdk.presenter.LocalBroadcastManager;
import com.sensorberg.sdk.receivers.GenericBroadcastReceiver;
import com.sensorberg.sdk.receivers.NetworkInfoBroadcastReceiver;
import com.sensorberg.sdk.receivers.ScannerBroadcastReceiver;
import com.sensorberg.sdk.resolver.BeaconEvent;
import com.sensorberg.sdk.resolver.Resolver;
import com.sensorberg.sdk.resolver.ResolverConfiguration;
import com.sensorberg.sdk.resolver.ResolverListener;
import com.sensorberg.sdk.scanner.BeaconActionHistoryPublisher;
import com.sensorberg.sdk.scanner.ScanEvent;
import com.sensorberg.sdk.scanner.Scanner;
import com.sensorberg.sdk.scanner.ScannerListener;
import com.sensorberg.sdk.settings.SettingsManager;
import com.sensorberg.sdk.settings.SettingsUpdateCallback;
import com.sensorberg.utils.ListUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;

public class InternalApplicationBootstrapper
extends MinimalBootstrapper
implements ScannerListener,
SyncStatusObserver,
Transport.ProximityUUIDUpdateHandler {
    private static final boolean SURVIVE_REBOOT = true;
    protected final Transport transport;
    protected final Resolver resolver;
    protected Scanner scanner;
    @Inject
    @Named(value="realSettingsManager")
    protected SettingsManager settingsManager;
    @Inject
    @Named(value="realBeaconActionHistoryPublisher")
    protected BeaconActionHistoryPublisher beaconActionHistoryPublisher;
    protected final Object proximityUUIDsMonitor = new Object();
    protected SensorbergService.MessengerList presentationDelegate;
    protected final Set<String> proximityUUIDs = new HashSet<String>();
    @Inject
    protected Context context;
    protected Clock clock;
    @Inject
    protected FileManager fileManager;
    @Inject
    protected PermissionChecker permissionChecker;
    protected BluetoothPlatform bluetoothPlatform;
    public ListUtils.Filter<BeaconEvent> beaconEventFilter = new ListUtils.Filter<BeaconEvent>(){

        @Override
        public boolean matches(BeaconEvent beaconEvent) {
            long lastAllowedPresentationTime;
            if (beaconEvent.getSuppressionTimeMillis() > 0L && InternalApplicationBootstrapper.this.beaconActionHistoryPublisher.actionShouldBeSuppressed(lastAllowedPresentationTime = InternalApplicationBootstrapper.this.clock.now() - beaconEvent.getSuppressionTimeMillis(), beaconEvent.getAction().getUuid())) {
                return false;
            }
            return !beaconEvent.isSendOnlyOnce() || !InternalApplicationBootstrapper.this.beaconActionHistoryPublisher.actionWasShownBefore(beaconEvent.getAction().getUuid());
        }
    };
    private ResolverListener resolverListener = new ResolverListener(){

        @Override
        public void onResolutionFailed(Throwable cause, ScanEvent scanEvent) {
            Logger.log.logError("resolution failed:" + scanEvent.getBeaconId().toTraditionalString(), cause);
        }

        @Override
        public void onResolutionsFinished(List<BeaconEvent> beaconEvents) {
            List<BeaconEvent> events = ListUtils.filter(beaconEvents, InternalApplicationBootstrapper.this.beaconEventFilter);
            for (BeaconEvent event : events) {
                InternalApplicationBootstrapper.this.presentBeaconEvent(event);
            }
        }
    };
    private SettingsUpdateCallback settingsUpdateCallbackListener = new SettingsUpdateCallback(){

        @Override
        public void onSettingsUpdateIntervalChange(Long updateIntervalMillies) {
            InternalApplicationBootstrapper.this.serviceScheduler.cancelIntent(102);
            InternalApplicationBootstrapper.this.serviceScheduler.scheduleRepeating(102, updateIntervalMillies, TimeUnit.MILLISECONDS);
        }

        @Override
        public void onSettingsBeaconLayoutUpdateIntervalChange(long newLayoutUpdateInterval) {
            InternalApplicationBootstrapper.this.serviceScheduler.cancelIntent(11);
            InternalApplicationBootstrapper.this.serviceScheduler.scheduleRepeating(11, newLayoutUpdateInterval, TimeUnit.MILLISECONDS);
        }

        @Override
        public void onHistoryUploadIntervalChange(long newHistoryUploadInterval) {
            InternalApplicationBootstrapper.this.serviceScheduler.cancelIntent(10);
            InternalApplicationBootstrapper.this.serviceScheduler.scheduleRepeating(10, newHistoryUploadInterval, TimeUnit.MILLISECONDS);
        }
    };

    public InternalApplicationBootstrapper(Transport transport, ServiceScheduler scheduler, HandlerManager handlerManager, Clock clk, BluetoothPlatform btPlatform, ResolverConfiguration resolverConfiguration) {
        super(scheduler);
        SensorbergSdk.getComponent().inject(this);
        this.transport = transport;
        this.settingsManager.setSettingsUpdateCallback(this.settingsUpdateCallbackListener);
        this.settingsManager.setMessageDelayWindowLengthListener((MessageDelayWindowLengthListener)((Object)scheduler));
        this.clock = clk;
        this.bluetoothPlatform = btPlatform;
        this.beaconActionHistoryPublisher.setResolverListener(this.resolverListener);
        this.scanner = new Scanner(this.settingsManager, this.settingsManager.isShouldRestoreBeaconStates(), this.clock, this.fileManager, scheduler, handlerManager, btPlatform);
        this.resolver = new Resolver(resolverConfiguration, handlerManager, transport);
        this.resolver.setListener(this.resolverListener);
        this.scanner.addScannerListener(this);
        this.serviceScheduler.restorePendingIntents();
        ScannerBroadcastReceiver.setManifestReceiverEnabled(true, this.context);
        GenericBroadcastReceiver.setManifestReceiverEnabled(true, this.context);
        this.setUpAlarmsForSettings();
        this.setUpAlarmForBeaconActionHistoryPublisher();
        this.updateAlarmsForActionLayoutFetch();
        NetworkInfoBroadcastReceiver.triggerListenerWithCurrentState(this.context);
        ContentResolver.addStatusChangeListener((int)1, (SyncStatusObserver)this);
    }

    private void setUpAlarmForBeaconActionHistoryPublisher() {
        this.serviceScheduler.scheduleRepeating(10, this.settingsManager.getHistoryUploadInterval(), TimeUnit.MILLISECONDS);
    }

    private void setUpAlarmsForSettings() {
        this.serviceScheduler.scheduleRepeating(102, this.settingsManager.getSettingsUpdateInterval(), TimeUnit.MILLISECONDS);
    }

    private void updateAlarmsForActionLayoutFetch() {
        if (this.isSyncEnabled()) {
            this.serviceScheduler.scheduleRepeating(11, this.settingsManager.getLayoutUpdateInterval(), TimeUnit.MILLISECONDS);
        } else {
            this.serviceScheduler.cancelIntent(11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onScanEventDetected(ScanEvent scanEvent) {
        boolean contained;
        this.beaconActionHistoryPublisher.onScanEventDetected(scanEvent);
        Object object = this.proximityUUIDsMonitor;
        synchronized (object) {
            contained = this.proximityUUIDs.isEmpty() || this.proximityUUIDs.contains(scanEvent.getBeaconId().getProximityUUIDWithoutDashes());
        }
        if (contained) {
            this.resolver.resolve(scanEvent);
        }
    }

    public void presentBeaconEvent(BeaconEvent beaconEvent) {
        if (beaconEvent != null && beaconEvent.getAction() != null) {
            Action beaconEventAction = beaconEvent.getAction();
            if (beaconEvent.getDeliverAt() != null) {
                this.serviceScheduler.postDeliverAtOrUpdate(beaconEvent.getDeliverAt(), beaconEvent);
            } else if (beaconEventAction.getDelayTime() > 0L) {
                this.serviceScheduler.postToServiceDelayed(beaconEventAction.getDelayTime(), 1001, beaconEvent, true);
                Logger.log.beaconResolveState(beaconEvent, "delaying the display of this BeaconEvent");
            } else {
                this.presentEventDirectly(beaconEvent);
            }
        }
    }

    private void presentEventDirectly(BeaconEvent beaconEvent) {
        if (beaconEvent.getAction() != null) {
            beaconEvent.setPresentationTime(this.clock.now());
            this.beaconActionHistoryPublisher.onActionPresented(beaconEvent);
            if (beaconEvent.getAction().getType() == ActionType.SILENT) {
                Logger.log.beaconResolveState(beaconEvent, "Silent campaign handled, no callback to host application");
                return;
            }
            if (this.presentationDelegate == null) {
                Intent broadcastIntent = new Intent("com.sensorberg.android.PRESENT_ACTION");
                broadcastIntent.putExtra("com.sensorberg.sdk.Action", (Parcelable)beaconEvent.getAction());
                LocalBroadcastManager.getInstance(this.context).sendBroadcast(broadcastIntent);
            } else {
                Logger.log.beaconResolveState(beaconEvent, "delegating the display of the beacon event to the application");
                this.presentationDelegate.send(beaconEvent);
            }
        }
    }

    public void presentEventDirectly(BeaconEvent beaconEvent, int index) {
        this.serviceScheduler.removeStoredPendingIntent(index);
        if (beaconEvent != null) {
            this.presentEventDirectly(beaconEvent);
        }
    }

    public void sentPresentationDelegationTo(SensorbergService.MessengerList messengerList) {
        this.presentationDelegate = messengerList;
    }

    public void startScanning() {
        if (this.bluetoothPlatform.isBluetoothLowEnergySupported() && this.bluetoothPlatform.isBluetoothLowEnergyDeviceTurnedOn()) {
            if (!this.permissionChecker.hasScanPermissionCheckAndroid6()) {
                Logger.log.logError("User needs to be shown runtime dialogue asking for coarse location services");
            } else {
                this.scanner.start();
            }
        }
    }

    @Override
    public void stopScanning() {
        this.scanner.stop();
    }

    public void saveAllDataBeforeDestroy() {
        this.beaconActionHistoryPublisher.saveAllData();
    }

    public void hostApplicationInForeground() {
        this.scanner.hostApplicationInForeground();
        this.updateSettings();
        this.transport.updateBeaconLayout();
        this.beaconActionHistoryPublisher.publishHistory();
    }

    public void hostApplicationInBackground() {
        this.scanner.hostApplicationInBackground();
        this.beaconActionHistoryPublisher.publishHistory();
    }

    public void setApiToken(String apiToken) {
        this.transport.setApiToken(apiToken);
        this.beaconActionHistoryPublisher.publishHistory();
        if (this.resolver.configuration.setApiToken(apiToken)) {
            this.unscheduleAllPendingActions();
            this.beaconActionHistoryPublisher.deleteAllObjects();
        }
    }

    public void updateSettings() {
        this.settingsManager.updateSettingsFromNetwork();
    }

    public void uploadHistory() {
        if (NetworkInfoBroadcastReceiver.latestNetworkInfo != null) {
            this.beaconActionHistoryPublisher.publishHistory();
        } else {
            Logger.log.logError("Did not try to upload the history because it seems we\u00b4e offline.");
        }
    }

    boolean isSyncEnabled() {
        if (this.permissionChecker.hasReadSyncSettingsPermissions()) {
            return ContentResolver.getMasterSyncAutomatically();
        }
        return true;
    }

    public void updateBeaconLayout() {
        if (this.isSyncEnabled()) {
            this.transport.updateBeaconLayout();
        }
    }

    public void onStatusChanged(int which) {
        this.updateAlarmsForActionLayoutFetch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proximityUUIDListUpdated(List<String> proximityUUIDs) {
        Object object = this.proximityUUIDsMonitor;
        synchronized (object) {
            this.proximityUUIDs.clear();
            for (String proximityUUID : proximityUUIDs) {
                this.proximityUUIDs.add(proximityUUID.toLowerCase());
            }
        }
    }
}

