/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.content.Context;
import com.sensorberg.sdk.Logger;
import com.sensorberg.sdk.internal.interfaces.FileManager;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class AndroidFileManager
implements FileManager {
    protected final Context context;

    public AndroidFileManager(Context ctx) {
        this.context = ctx;
    }

    @Override
    public File getFile(String fileName) {
        return new File(this.context.getFilesDir() + File.separator + fileName);
    }

    @Override
    public void write(Serializable serializableObject, String fileName) {
        this.write(serializableObject, this.getFile(fileName));
    }

    @Override
    public void removeFile(String fileName) {
        this.getFile(fileName).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean write(Serializable object, File file) {
        boolean bl;
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
            bl = true;
        }
        catch (Exception e) {
            try {
                Logger.log.logError("error writing file", e);
            }
            catch (Throwable throwable) {
                Closeables.close(fos);
                Closeables.close(oos);
                throw throwable;
            }
            Closeables.close(fos);
            Closeables.close(oos);
            return false;
        }
        Closeables.close(fos);
        Closeables.close(oos);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getContentsOfFileOrNull(File file) {
        Object object;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            object = ois.readObject();
        }
        catch (Exception e) {
            try {
                Logger.log.logError("error reading file", e);
            }
            catch (Throwable throwable) {
                Closeables.close(fis);
                Closeables.close(ois);
                throw throwable;
            }
            Closeables.close(fis);
            Closeables.close(ois);
            return null;
        }
        Closeables.close(fis);
        Closeables.close(ois);
        return object;
    }

    static class Closeables {
        Closeables() {
        }

        public static void close(Closeable closeable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

