/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.sensorberg.sdk.internal.interfaces.PlatformIdentifier;
import com.sensorberg.utils.UUIDUtils;
import java.net.URLEncoder;
import java.util.UUID;

public class AndroidPlatformIdentifier
implements PlatformIdentifier {
    private static final String SENSORBERG_PREFERENCE_INSTALLATION_IDENTIFIER = "com.sensorberg.preferences.installationUuidIdentifier";
    private final Context context;
    private final SharedPreferences sharedPreferences;
    private String userAgentString;
    private String deviceInstallationIdentifier;
    private String advertiserIdentifier;

    public AndroidPlatformIdentifier(Context ctx, SharedPreferences sharedPrefs) {
        this.context = ctx;
        this.sharedPreferences = sharedPrefs;
        if (sharedPrefs.contains("com.sensorberg.preferences.network.advertisingIdentifier")) {
            this.advertiserIdentifier = sharedPrefs.getString("com.sensorberg.preferences.network.advertisingIdentifier", null);
        }
        this.deviceInstallationIdentifier = this.getOrCreateInstallationIdentifier();
    }

    @Override
    public String getUserAgentString() {
        if (this.userAgentString == null) {
            String packageName = this.context.getPackageName();
            String appLabel = URLEncoder.encode(AndroidPlatformIdentifier.getAppLabel(this.context));
            String appVersion = AndroidPlatformIdentifier.getAppVersionString(this.context);
            StringBuilder userAgent = new StringBuilder();
            userAgent.append(appLabel + "/" + packageName + "/" + appVersion);
            userAgent.append(" ");
            userAgent.append("(Android " + Build.VERSION.RELEASE + " " + Build.CPU_ABI + ")");
            userAgent.append(" ");
            userAgent.append("(" + Build.MANUFACTURER + ":" + Build.MODEL + ":" + Build.PRODUCT + ")");
            userAgent.append(" ");
            userAgent.append("Sensorberg SDK 2.0.5");
            this.userAgentString = userAgent.toString();
        }
        return this.userAgentString;
    }

    @Override
    public String getDeviceInstallationIdentifier() {
        return this.deviceInstallationIdentifier;
    }

    @Override
    public String getAdvertiserIdentifier() {
        return this.advertiserIdentifier;
    }

    @Override
    public void setAdvertisingIdentifier(String advertisingIdentifier) {
        this.advertiserIdentifier = advertisingIdentifier;
        this.persistAdvertiserIdentifier(this.advertiserIdentifier);
    }

    private String getOrCreateInstallationIdentifier() {
        String value;
        String uuidString = this.sharedPreferences.getString(SENSORBERG_PREFERENCE_INSTALLATION_IDENTIFIER, null);
        if (uuidString != null) {
            value = uuidString;
        } else {
            value = UUIDUtils.uuidWithoutDashesString(UUID.randomUUID());
            this.persistInstallationIdentifier(value);
        }
        return value;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void persistInstallationIdentifier(String value) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putString(SENSORBERG_PREFERENCE_INSTALLATION_IDENTIFIER, value);
        editor.commit();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void persistAdvertiserIdentifier(String advertisingIdentifier) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        if (advertisingIdentifier == null) {
            editor.remove("com.sensorberg.preferences.network.advertisingIdentifier");
        } else {
            editor.putString("com.sensorberg.preferences.network.advertisingIdentifier", advertisingIdentifier);
            editor.apply();
        }
    }

    private static String getAppVersionString(Context context) {
        try {
            PackageInfo myInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return URLEncoder.encode(myInfo.versionName) + "/" + myInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            return "<unknown>";
        }
        catch (NullPointerException e) {
            return "<unknown>";
        }
    }

    @TargetApi(value=4)
    private static String getAppLabel(Context application) {
        PackageManager pm = application.getPackageManager();
        ApplicationInfo ai = application.getApplicationInfo();
        return String.valueOf(pm.getApplicationLabel(ai));
    }
}

