/*
 * Decompiled with CFR 0.152.
 */
package com.sensorberg.sdk.internal;

import android.content.SharedPreferences;
import com.sensorberg.sdk.Logger;

public class PersistentIntegerCounter {
    private SharedPreferences settingsSharedPrefs;
    private int postToServiceCounter;
    private final Object postToServiceCounterMonitor = new Object();

    public PersistentIntegerCounter(SharedPreferences prefs) {
        this.settingsSharedPrefs = prefs;
        if (this.settingsSharedPrefs.contains("com.sensorberg.preferences.platform.serviceIntentCounter")) {
            try {
                this.postToServiceCounter = this.settingsSharedPrefs.getInt("com.sensorberg.preferences.platform.serviceIntentCounter", 0);
            }
            catch (Exception e) {
                Logger.log.logError("Could not fetch the last postToServiceCounter because of some weird Framework bug", e);
                this.postToServiceCounter = 0;
            }
        } else {
            this.postToServiceCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int next() {
        Object object = this.postToServiceCounterMonitor;
        synchronized (object) {
            this.postToServiceCounter = this.postToServiceCounter == Integer.MAX_VALUE ? 0 : ++this.postToServiceCounter;
            this.settingsSharedPrefs.edit().putInt("com.sensorberg.preferences.platform.serviceIntentCounter", this.postToServiceCounter).apply();
            return this.postToServiceCounter;
        }
    }
}

